/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.util.Tuple2;
import java.util.Arrays;
import java.util.List;

public class StringEscapeUtil {
    private static final List<Tuple2<String, String>> XML_ESCAPES = Arrays.asList(Tuple2.of("&", "&amp;"), Tuple2.of("<", "&lt;"), Tuple2.of(">", "&gt;"), Tuple2.of("\"", "&quot;"), Tuple2.of("'", "&apos;"));
    private static final List<Tuple2<String, String>> HTML_ESCAPES = Arrays.asList(Tuple2.of("&", "&amp;"), Tuple2.of("<", "&lt;"), Tuple2.of(">", "&gt;"), Tuple2.of("\"", "&quot;"), Tuple2.of("'", "&apos;"), Tuple2.of("\u00a0", "&nbsp;"));

    public static String escapeXml(String s) {
        return StringEscapeUtil.replace(s, XML_ESCAPES);
    }

    public static String escapeHtml(String s) {
        return StringEscapeUtil.replace(s, HTML_ESCAPES);
    }

    private static String replace(String str, List<Tuple2<String, String>> replacements) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        String s = str;
        for (Tuple2<String, String> r : replacements) {
            s = s.replace((CharSequence)r._1, (CharSequence)r._2);
        }
        return s;
    }
}

