/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.util.CallFrame;
import java.util.function.Supplier;

public class WithCallStack
implements AutoCloseable {
    public WithCallStack(CallFrame callFrame) {
        if (callFrame == null) {
            throw new IllegalArgumentException("A 'callFrame' must not be null");
        }
        ThreadLocalMap.getCallStack().push(callFrame);
    }

    @Override
    public void close() {
        ThreadLocalMap.getCallStack().pop();
    }

    public static <T> T call(CallFrame callFrame, Supplier<T> func) {
        try (WithCallStack cs = new WithCallStack(callFrame);){
            T t = func.get();
            return t;
        }
    }

    public static void run(CallFrame callFrame, Runnable func) {
        try (WithCallStack cs = new WithCallStack(callFrame);){
            func.run();
        }
    }
}

