/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.concurrent;

import com.github.jlangch.venice.impl.util.concurrent.ManagedExecutor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class ManagedCachedThreadPoolExecutor
extends ManagedExecutor {
    private int maximumThreadPoolSize;

    public ManagedCachedThreadPoolExecutor(String threadPoolName, int maxPoolSize) {
        super(threadPoolName);
        this.maximumThreadPoolSize = maxPoolSize;
    }

    @Override
    public ThreadPoolExecutor getExecutor() {
        return (ThreadPoolExecutor)super.getExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ThreadPoolExecutor createExecutorService() {
        ManagedCachedThreadPoolExecutor managedCachedThreadPoolExecutor = this;
        synchronized (managedCachedThreadPoolExecutor) {
            ThreadPoolExecutor es = (ThreadPoolExecutor)Executors.newCachedThreadPool(this.createThreadFactory());
            es.setMaximumPoolSize(this.maximumThreadPoolSize);
            return es;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumThreadPoolSize(int maximumPoolSize) {
        ManagedCachedThreadPoolExecutor managedCachedThreadPoolExecutor = this;
        synchronized (managedCachedThreadPoolExecutor) {
            if (super.exists()) {
                this.maximumThreadPoolSize = Math.max(1, maximumPoolSize);
                this.getExecutor().setMaximumPoolSize(this.maximumThreadPoolSize);
            }
        }
    }
}

