/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.json;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.nanojson.JsonLazyNumber;
import com.github.jlangch.venice.nanojson.JsonParserException;
import com.github.jlangch.venice.nanojson.JsonReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Function;

public class VncJsonReader {
    private final JsonReader reader;
    private final Function<VncVal, VncVal> key_fn;
    private final BiFunction<VncVal, VncVal, VncVal> value_fn;
    private final boolean toDecimal;

    public VncJsonReader(JsonReader reader) {
        this(reader, null, null, false);
    }

    public VncJsonReader(JsonReader reader, Function<VncVal, VncVal> key_fn, BiFunction<VncVal, VncVal, VncVal> value_fn, boolean toDecimal) {
        this.reader = reader;
        this.key_fn = key_fn;
        this.value_fn = value_fn;
        this.toDecimal = toDecimal;
    }

    public VncVal read() {
        try {
            return this.readAny();
        }
        catch (JsonParserException ex) {
            throw new VncException(String.format("JSON deserialization error at line %d column %d. %s", ex.getLinePosition(), ex.getCharPosition(), ex.getMessage()), ex);
        }
    }

    private VncVal readAny() throws JsonParserException {
        switch (this.reader.current()) {
            case OBJECT: {
                return this.readObject();
            }
            case ARRAY: {
                return this.readArray();
            }
            case STRING: {
                return new VncString(this.reader.string());
            }
            case NUMBER: {
                return this.readNumber();
            }
            case BOOLEAN: {
                return VncBoolean.of(this.reader.bool());
            }
            case NULL: {
                return Constants.Nil;
            }
        }
        throw new RuntimeException("Unexpected JSON type " + (Object)((Object)this.reader.current()));
    }

    private VncVal readObject() throws JsonParserException {
        this.reader.object();
        HashMap<VncString, VncVal> map = new HashMap<VncString, VncVal>();
        while (this.reader.next()) {
            VncString key = new VncString(this.reader.key());
            VncString mappedKey = this.key_fn == null ? key : this.key_fn.apply(key);
            VncVal val = this.readAny();
            VncVal mappedVal = this.value_fn == null ? val : this.value_fn.apply(mappedKey, val);
            map.put(mappedKey, mappedVal);
        }
        return new VncHashMap(map);
    }

    private VncVal readArray() throws JsonParserException {
        this.reader.array();
        ArrayList<VncVal> list = new ArrayList<VncVal>();
        while (this.reader.next()) {
            list.add(this.readAny());
        }
        return VncList.ofList(list);
    }

    private VncVal readNumber() throws JsonParserException {
        JsonLazyNumber n = (JsonLazyNumber)this.reader.number();
        return n.isDouble() ? (this.toDecimal ? new VncBigDecimal(n.bigDecimalValue()) : new VncDouble(n.doubleValue())) : new VncLong(n.longValue());
    }
}

