/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.org.jline.console;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.repackage.org.jline.builtins.ConsoleOptionGetter;
import org.repackage.org.jline.console.CmdDesc;
import org.repackage.org.jline.console.CmdLine;
import org.repackage.org.jline.console.CommandRegistry;
import org.repackage.org.jline.reader.Completer;
import org.repackage.org.jline.reader.ParsedLine;
import org.repackage.org.jline.terminal.Terminal;

public interface SystemRegistry
extends CommandRegistry,
ConsoleOptionGetter {
    public void setCommandRegistries(CommandRegistry ... var1);

    public void register(String var1, CommandRegistry var2);

    public void initialize(File var1);

    public Collection<String> getPipeNames();

    public Completer completer();

    public CmdDesc commandDescription(CmdLine var1);

    public Object execute(String var1) throws Exception;

    public void cleanUp();

    public void trace(Exception var1);

    public void trace(boolean var1, Exception var2);

    @Override
    public Object consoleOption(String var1);

    public Terminal terminal();

    public Object invoke(String var1, Object ... var2) throws Exception;

    public boolean isCommandOrScript(ParsedLine var1);

    public void close();

    public static SystemRegistry get() {
        return Registeries.getInstance().getSystemRegistry();
    }

    public static void add(SystemRegistry systemRegistry) {
        Registeries.getInstance().addRegistry(systemRegistry);
    }

    public static void remove() {
        Registeries.getInstance().removeRegistry();
    }

    public static class Registeries {
        private static final Registeries instance = new Registeries();
        private final Map<Long, SystemRegistry> systemRegisteries = new HashMap<Long, SystemRegistry>();

        private Registeries() {
        }

        protected static Registeries getInstance() {
            return instance;
        }

        protected void addRegistry(SystemRegistry systemRegistry) {
            this.systemRegisteries.put(Thread.currentThread().getId(), systemRegistry);
        }

        protected SystemRegistry getSystemRegistry() {
            return this.systemRegisteries.getOrDefault(Thread.currentThread().getId(), null);
        }

        protected void removeRegistry() {
            this.systemRegisteries.remove(Thread.currentThread().getId());
        }
    }
}

