/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.ArityException;
import com.github.jlangch.venice.AssertionException;
import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.NotInTailPositionException;
import com.github.jlangch.venice.Version;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Modules;
import com.github.jlangch.venice.impl.Namespace;
import com.github.jlangch.venice.impl.NamespaceRegistry;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.RecursionPoint;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.env.DynamicVar;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.ReservedSymbols;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.Functions;
import com.github.jlangch.venice.impl.functions.TransducerFunctions;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.reader.Reader;
import com.github.jlangch.venice.impl.specialforms.CatchBlock;
import com.github.jlangch.venice.impl.specialforms.DefTypeForm;
import com.github.jlangch.venice.impl.specialforms.DocForm;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.INamespaceAware;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncJust;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncMultiFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncMutableSet;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.custom.CustomWrappableTypes;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.Inspector;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.WithCallStack;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class VeniceInterpreter
implements Serializable {
    private static final long serialVersionUID = -8130740279914790685L;
    private static final VncKeyword PRE_CONDITION_KEY = new VncKeyword(":pre");
    private final IInterceptor interceptor;
    private final boolean checkSandbox;
    private final MeterRegistry meterRegistry;
    private final NamespaceRegistry nsRegistry = new NamespaceRegistry();
    private final CustomWrappableTypes wrappableTypes = new CustomWrappableTypes();
    private final AtomicBoolean sealedSystemNS = new AtomicBoolean(false);
    private final AtomicLong macroExpandAllCountEffective = new AtomicLong(0L);
    private final AtomicLong macroExpandAllCount = new AtomicLong(0L);
    private final AtomicLong macroExpandCount = new AtomicLong(0L);
    private volatile boolean macroexpand = false;

    public VeniceInterpreter(IInterceptor interceptor) {
        if (interceptor == null) {
            throw new SecurityException("VeniceInterpreter can not run without an interceptor");
        }
        this.interceptor = interceptor;
        this.meterRegistry = this.interceptor.getMeterRegistry();
        this.checkSandbox = !(interceptor instanceof AcceptAllInterceptor);
    }

    public void initNS() {
        this.nsRegistry.clear();
        Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent(Namespaces.NS_USER));
    }

    public void sealSystemNS() {
        this.sealedSystemNS.set(true);
    }

    public void setMacroexpandOnLoad(boolean macroexpandOnLoad, Env env) {
        env.setMacroexpandOnLoad(VncBoolean.of(macroexpandOnLoad));
        this.macroexpand = macroexpandOnLoad;
    }

    public boolean isMacroexpandOnLoad() {
        return this.macroexpand;
    }

    public VncVal READ(String script, String filename) {
        if (this.meterRegistry.enabled) {
            long nanos = System.nanoTime();
            VncVal val = Reader.read_str(script, filename);
            this.meterRegistry.record("venice.read", System.nanoTime() - nanos);
            return val;
        }
        return Reader.read_str(script, filename);
    }

    public VncVal EVAL(VncVal ast, Env env) {
        if (this.meterRegistry.enabled) {
            long nanos = System.nanoTime();
            VncVal val = this.evaluate(ast, env);
            this.meterRegistry.record("venice.eval", System.nanoTime() - nanos);
            return val;
        }
        return this.evaluate(ast, env);
    }

    public VncVal MACROEXPAND(VncVal ast, Env env) {
        return this.macroexpand_all(new CallFrame("macroexpand-all", ast.getMeta()), ast, env);
    }

    public VncVal RE(String script, String name, Env env) {
        VncVal ast = this.READ(script, name);
        if (this.macroexpand) {
            ast = this.MACROEXPAND(ast, env);
        }
        return this.EVAL(ast, env);
    }

    public String PRINT(VncVal exp) {
        return Printer.pr_str(exp, true);
    }

    public Env createEnv(boolean macroexpandOnLoad, boolean ansiTerminal, RunMode runMode) {
        return this.createEnv(null, macroexpandOnLoad, ansiTerminal, runMode);
    }

    public Env createEnv(List<String> preloadedExtensionModules, boolean macroexpandOnLoad, boolean ansiTerminal, RunMode runMode) {
        this.sealedSystemNS.set(false);
        Env env = new Env(null);
        VncMutableSet loadedModules = VncMutableSet.ofAll(Modules.PRELOADED_MODULES);
        for (Map.Entry<VncVal, VncVal> e : Functions.functions.entrySet()) {
            VncSymbol sym = (VncSymbol)e.getKey();
            VncFunction fn = (VncFunction)e.getValue();
            env.setGlobal(new Var(sym, fn, fn.isRedefinable()));
        }
        env.setGlobal(new Var(new VncSymbol("*version*"), new VncString(Version.VERSION), false));
        env.setGlobal(new Var(new VncSymbol("*newline*"), new VncString(System.lineSeparator()), false));
        env.setGlobal(new Var(new VncSymbol("*ansi-term*"), VncBoolean.of(ansiTerminal), false));
        env.setGlobal(new Var(new VncSymbol("*run-mode*"), runMode == null ? Constants.Nil : runMode.mode, false));
        env.setGlobal(new Var(new VncSymbol("*loaded-modules*"), loadedModules, true));
        env.setGlobal(new Var(new VncSymbol("*loaded-files*"), new VncMutableSet(), true));
        this.initNS();
        this.setMacroexpandOnLoad(macroexpandOnLoad, env);
        this.loadModule("core", env, loadedModules);
        this.sealedSystemNS.set(true);
        VeniceInterpreter.toEmpty(preloadedExtensionModules).forEach(m -> this.loadModule((String)m, env, loadedModules));
        return env;
    }

    public List<String> getAvailableModules() {
        ArrayList<String> modules = new ArrayList<String>(Modules.VALID_MODULES);
        modules.removeAll(Arrays.asList("core", "test", "http", "jackson"));
        Collections.sort(modules);
        return modules;
    }

    private void loadModule(String module, Env env, VncMutableSet loadedModules) {
        long nanos = System.nanoTime();
        this.RE("(eval " + ModuleLoader.loadModule(module) + ")", module, env);
        if (this.meterRegistry.enabled) {
            this.meterRegistry.record("venice.module." + module + ".load", System.nanoTime() - nanos);
        }
        loadedModules.add(new VncKeyword(module));
    }

    private VncVal evaluate(VncVal ast_, Env env_) {
        return this.evaluate(ast_, env_, false);
    }

    private VncVal evaluateInTailPosition(VncVal ast_, Env env_) {
        return this.evaluate(ast_, env_, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private VncVal evaluate(VncVal ast_, Env env_, boolean inTailPosition) {
        orig_ast = ast_;
        env = env_;
        recursionPoint = null;
        tailPosition = inTailPosition;
        block194: while (true) {
            if (!(orig_ast instanceof VncList)) {
                return this.evaluate_values(orig_ast, env);
            }
            ast = (VncList)orig_ast;
            if (ast.isEmpty()) {
                return ast;
            }
            a0 = ast.first();
            a0sym = a0 instanceof VncSymbol != false ? ((VncSymbol)a0).getName() : "__<*fn*>__";
            args = ast.rest();
            var12_12 = a0sym;
            var13_13 = -1;
            switch (var12_12.hashCode()) {
                case 3211: {
                    if (!var12_12.equals("do")) break;
                    var13_13 = 0;
                    break;
                }
                case 3357: {
                    if (!var12_12.equals("if")) break;
                    var13_13 = 1;
                    break;
                }
                case 107035: {
                    if (!var12_12.equals("let")) break;
                    var13_13 = 2;
                    break;
                }
                case 1896636553: {
                    if (!var12_12.equals("quasiquote")) break;
                    var13_13 = 3;
                    break;
                }
                case 107953788: {
                    if (!var12_12.equals("quote")) break;
                    var13_13 = 4;
                    break;
                }
                case 3327652: {
                    if (!var12_12.equals("loop")) break;
                    var13_13 = 5;
                    break;
                }
                case 108389165: {
                    if (!var12_12.equals("recur")) break;
                    var13_13 = 6;
                    break;
                }
                case 3272: {
                    if (!var12_12.equals("fn")) break;
                    var13_13 = 7;
                    break;
                }
                case 3125404: {
                    if (!var12_12.equals("eval")) break;
                    var13_13 = 8;
                    break;
                }
                case 99333: {
                    if (!var12_12.equals("def")) break;
                    var13_13 = 9;
                    break;
                }
                case 1545213958: {
                    if (!var12_12.equals("defonce")) break;
                    var13_13 = 10;
                    break;
                }
                case 1590555255: {
                    if (!var12_12.equals("def-dynamic")) break;
                    var13_13 = 11;
                    break;
                }
                case 654758631: {
                    if (!var12_12.equals("defmacro")) break;
                    var13_13 = 12;
                    break;
                }
                case 1545373887: {
                    if (!var12_12.equals("deftype")) break;
                    var13_13 = 13;
                    break;
                }
                case 661950304: {
                    if (!var12_12.equals("deftype?")) break;
                    var13_13 = 14;
                    break;
                }
                case 479068581: {
                    if (!var12_12.equals("deftype-of")) break;
                    var13_13 = 15;
                    break;
                }
                case 479068593: {
                    if (!var12_12.equals("deftype-or")) break;
                    var13_13 = 16;
                    break;
                }
                case 1484: {
                    if (!var12_12.equals(".:")) break;
                    var13_13 = 17;
                    break;
                }
                case 655363156: {
                    if (!var12_12.equals("defmulti")) break;
                    var13_13 = 18;
                    break;
                }
                case -1173127898: {
                    if (!var12_12.equals("defmethod")) break;
                    var13_13 = 19;
                    break;
                }
                case 3525: {
                    if (!var12_12.equals("ns")) break;
                    var13_13 = 20;
                    break;
                }
                case 1951546764: {
                    if (!var12_12.equals("ns-remove")) break;
                    var13_13 = 21;
                    break;
                }
                case -1180934629: {
                    if (!var12_12.equals("ns-unmap")) break;
                    var13_13 = 22;
                    break;
                }
                case -2116577370: {
                    if (!var12_12.equals("ns-list")) break;
                    var13_13 = 23;
                    break;
                }
                case -1184795739: {
                    if (!var12_12.equals("import")) break;
                    var13_13 = 24;
                    break;
                }
                case 1926037870: {
                    if (!var12_12.equals("imports")) break;
                    var13_13 = 25;
                    break;
                }
                case 1252218203: {
                    if (!var12_12.equals("namespace")) break;
                    var13_13 = 26;
                    break;
                }
                case 1097368044: {
                    if (!var12_12.equals("resolve")) break;
                    var13_13 = 27;
                    break;
                }
                case 235003824: {
                    if (!var12_12.equals("var-get")) break;
                    var13_13 = 28;
                    break;
                }
                case -823702997: {
                    if (!var12_12.equals("var-ns")) break;
                    var13_13 = 29;
                    break;
                }
                case -1304611471: {
                    if (!var12_12.equals("var-name")) break;
                    var13_13 = 30;
                    break;
                }
                case 354199450: {
                    if (!var12_12.equals("var-local?")) break;
                    var13_13 = 31;
                    break;
                }
                case 227578673: {
                    if (!var12_12.equals("var-thread-local?")) break;
                    var13_13 = 32;
                    break;
                }
                case -2122054570: {
                    if (!var12_12.equals("var-global?")) break;
                    var13_13 = 33;
                    break;
                }
                case 3526655: {
                    if (!var12_12.equals("set!")) break;
                    var13_13 = 34;
                    break;
                }
                case 1957454356: {
                    if (!var12_12.equals("inspect")) break;
                    var13_13 = 35;
                    break;
                }
                case 820867430: {
                    if (!var12_12.equals("macroexpand")) break;
                    var13_13 = 36;
                    break;
                }
                case -544777552: {
                    if (!var12_12.equals("macroexpand-all*")) break;
                    var13_13 = 37;
                    break;
                }
                case -544537419: {
                    if (!var12_12.equals("macroexpand-info")) break;
                    var13_13 = 38;
                    break;
                }
                case 99640: {
                    if (!var12_12.equals("doc")) break;
                    var13_13 = 39;
                    break;
                }
                case 1187278228: {
                    if (!var12_12.equals("print-highlight")) break;
                    var13_13 = 40;
                    break;
                }
                case 1227433863: {
                    if (!var12_12.equals("modules")) break;
                    var13_13 = 41;
                    break;
                }
                case -108220795: {
                    if (!var12_12.equals("binding")) break;
                    var13_13 = 42;
                    break;
                }
                case -1383205247: {
                    if (!var12_12.equals("bound?")) break;
                    var13_13 = 43;
                    break;
                }
                case -173865320: {
                    if (!var12_12.equals("global-vars-count")) break;
                    var13_13 = 44;
                    break;
                }
                case 115131: {
                    if (!var12_12.equals("try")) break;
                    var13_13 = 45;
                    break;
                }
                case 1908075928: {
                    if (!var12_12.equals("try-with")) break;
                    var13_13 = 46;
                    break;
                }
                case 338706135: {
                    if (!var12_12.equals("locking")) break;
                    var13_13 = 47;
                    break;
                }
                case 95772192: {
                    if (!var12_12.equals("dorun")) break;
                    var13_13 = 48;
                    break;
                }
                case 1827513477: {
                    if (!var12_12.equals("dobench")) break;
                    var13_13 = 49;
                    break;
                }
                case 3449689: {
                    if (!var12_12.equals("prof")) break;
                    var13_13 = 50;
                    break;
                }
                case -696667305: {
                    if (!var12_12.equals("tail-pos")) break;
                    var13_13 = 51;
                }
            }
            switch (var13_13) {
                case 0: {
                    expressions = args;
                    this.evaluate_sequence_values(expressions.butlast(), env);
                    orig_ast = expressions.last();
                    tailPosition = true;
                    break;
                }
                case 1: {
                    numArgs = args.size();
                    if (numArgs == 2 || numArgs == 3) {
                        cond = this.evaluate(args.first(), env);
                        orig_ast = VncBoolean.isFalse(cond) != false || cond == Constants.Nil ? args.third() : args.second();
                        tailPosition = true;
                        break;
                    }
                    cs = new WithCallStack(new CallFrame("if", a0.getMeta()));
                    var16_17 = null;
                    ArityExceptions.assertArity("if", ArityExceptions.FnType.SpecialForm, args, 2, 3);
                    if (cs == null) continue block194;
                    if (var16_17 == null) ** GOTO lbl251
                    try {
                        cs.close();
                    }
                    catch (Throwable var17_29) {
                        var16_17.addSuppressed(var17_29);
                    }
                    continue block194;
lbl251:
                    // 1 sources

                    cs.close();
                    break;
                    catch (Throwable var17_30) {
                        try {
                            var16_17 = var17_30;
                            throw var17_30;
                        }
                        catch (Throwable var18_33) {
                            if (cs != null) {
                                if (var16_17 != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var19_41) {
                                        var16_17.addSuppressed(var19_41);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var18_33;
                        }
                    }
                }
                case 2: {
                    if (args.isEmpty()) {
                        cs = new WithCallStack(new CallFrame("let", a0.getMeta()));
                        cs = null;
                        try {
                            ArityExceptions.assertMinArity("let", ArityExceptions.FnType.SpecialForm, args, 1);
                        }
                        catch (Throwable var16_19) {
                            cs = var16_19;
                            throw var16_19;
                        }
                        finally {
                            if (cs != null) {
                                if (cs != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var16_18) {
                                        cs.addSuppressed(var16_18);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                        }
                    }
                    env = new Env(env);
                    bindings = Coerce.toVncVector(args.first());
                    expressions = args.rest();
                    bindingsIter = bindings.iterator();
                    while (bindingsIter.hasNext()) {
                        sym = bindingsIter.next();
                        if (!bindingsIter.hasNext()) {
                            cs = new WithCallStack(new CallFrame("let", a0.getMeta()));
                            var19_40 = null;
                            try {
                                try {
                                    throw new VncException("let requires an even number of forms in the binding vector!");
                                }
                                catch (Throwable var20_44) {
                                    var19_40 = var20_44;
                                    throw var20_44;
                                }
                            }
                            catch (Throwable var22_49) {
                                if (cs != null) {
                                    if (var19_40 != null) {
                                        try {
                                            cs.close();
                                        }
                                        catch (Throwable var23_51) {
                                            var19_40.addSuppressed(var23_51);
                                        }
                                    } else {
                                        cs.close();
                                    }
                                }
                                throw var22_49;
                            }
                        }
                        val = this.evaluate(bindingsIter.next(), env);
                        env.addLocalVars(Destructuring.destructure((VncVal)sym, val));
                    }
                    if (expressions.size() == 1) {
                        orig_ast = expressions.first();
                    } else {
                        this.evaluate_sequence_values(expressions.butlast(), env);
                        orig_ast = expressions.last();
                    }
                    tailPosition = true;
                    break;
                }
                case 3: {
                    if (args.size() != 1) {
                        cs = new WithCallStack(new CallFrame("quasiquote", a0.getMeta()));
                        expressions = null;
                        try {
                            ArityExceptions.assertArity("quasiquote", ArityExceptions.FnType.SpecialForm, args, 1);
                        }
                        catch (Throwable bindingsIter) {
                            expressions = bindingsIter;
                            throw bindingsIter;
                        }
                        finally {
                            if (cs != null) {
                                if (expressions != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable bindingsIter) {
                                        expressions.addSuppressed(bindingsIter);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                        }
                    }
                    orig_ast = VeniceInterpreter.quasiquote(args.first());
                    break;
                }
                case 4: {
                    if (args.size() != 1) {
                        cs = new WithCallStack(new CallFrame("quote", a0.getMeta()));
                        expressions = null;
                        try {
                            ArityExceptions.assertArity("quote", ArityExceptions.FnType.SpecialForm, args, 1);
                        }
                        catch (Throwable bindingsIter) {
                            expressions = bindingsIter;
                            throw bindingsIter;
                        }
                        finally {
                            if (cs != null) {
                                if (expressions != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable bindingsIter) {
                                        expressions.addSuppressed(bindingsIter);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                        }
                    }
                    return args.first();
                }
                case 5: {
                    recursionPoint = null;
                    if (args.size() < 2) {
                        cs = new WithCallStack(new CallFrame("loop", a0.getMeta()));
                        expressions = null;
                        try {
                            ArityExceptions.assertMinArity("loop", ArityExceptions.FnType.SpecialForm, args, 2);
                        }
                        catch (Throwable bindingsIter) {
                            expressions = bindingsIter;
                            throw bindingsIter;
                        }
                        finally {
                            if (cs != null) {
                                if (expressions != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable bindingsIter) {
                                        expressions.addSuppressed(bindingsIter);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                        }
                    }
                    env = new Env(env);
                    bindings = Coerce.toVncVector(args.first());
                    expressions = args.rest();
                    if (bindings.size() % 2 != 0) {
                        cs = new WithCallStack(new CallFrame("loop", a0.getMeta()));
                        sym = null;
                        try {
                            try {
                                throw new VncException("loop requires an even number of forms in the binding vector!");
                            }
                            catch (Throwable val) {
                                sym = val;
                                throw val;
                            }
                        }
                        catch (Throwable var30_59) {
                            if (cs != null) {
                                if (sym != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var31_60) {
                                        sym.addSuppressed(var31_60);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var30_59;
                        }
                    }
                    bindingNames = new ArrayList<VncSymbol>(bindings.size() / 2);
                    bindingsIter = bindings.iterator();
                    while (bindingsIter.hasNext()) {
                        sym = Coerce.toVncSymbol(bindingsIter.next());
                        val = this.evaluate(bindingsIter.next(), env);
                        env.setLocal(new Var(sym, val));
                        bindingNames.add(sym);
                    }
                    recursionPoint = new RecursionPoint(bindingNames, (VncList)expressions, env);
                    if (expressions.size() == 1) {
                        orig_ast = expressions.first();
                    } else {
                        this.evaluate_sequence_values(expressions.butlast(), env);
                        orig_ast = expressions.last();
                    }
                    tailPosition = true;
                    break;
                }
                case 6: {
                    if (recursionPoint == null) {
                        cs = new WithCallStack(new CallFrame("recur", a0.getMeta()));
                        expressions = null;
                        try {
                            try {
                                throw new NotInTailPositionException("The recur expression is not in tail position!");
                            }
                            catch (Throwable bindingNames) {
                                expressions = bindingNames;
                                throw bindingNames;
                            }
                        }
                        catch (Throwable var32_61) {
                            if (cs != null) {
                                if (expressions != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var33_62) {
                                        expressions.addSuppressed(var33_62);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var32_61;
                        }
                    }
                    if (args.size() != recursionPoint.getLoopBindingNamesCount()) {
                        cs = new WithCallStack(new CallFrame("recur", a0.getMeta()));
                        expressions = null;
                        try {
                            try {
                                throw new VncException(String.format("The recur args (%d) do not match the loop args (%d) !", new Object[]{args.size(), recursionPoint.getLoopBindingNamesCount()}));
                            }
                            catch (Throwable bindingNames) {
                                expressions = bindingNames;
                                throw bindingNames;
                            }
                        }
                        catch (Throwable var34_63) {
                            if (cs != null) {
                                if (expressions != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var35_64) {
                                        expressions.addSuppressed(var35_64);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var34_63;
                        }
                    }
                    env = this.buildRecursionEnv(args, env, recursionPoint);
                    expressions = recursionPoint.getLoopExpressions();
                    if (expressions.size() == 1) {
                        orig_ast = expressions.first();
                    } else {
                        this.evaluate_sequence_values(expressions.butlast(), env);
                        orig_ast = expressions.last();
                    }
                    tailPosition = true;
                    break;
                }
                case 7: {
                    return this.fn_(new CallFrame("fn", a0.getMeta()), args, env);
                }
                case 8: {
                    return this.eval_(new CallFrame("eval", a0.getMeta()), args, env);
                }
                case 9: {
                    return this.def_(new CallFrame("def", a0.getMeta()), args, env);
                }
                case 10: {
                    return this.defonce_(new CallFrame("defonce", a0.getMeta()), args, env);
                }
                case 11: {
                    return this.def_dynamic_(new CallFrame("def-dynamic", a0.getMeta()), args, env);
                }
                case 12: {
                    return this.defmacro_(new CallFrame("defmacro", a0.getMeta()), args, env);
                }
                case 13: {
                    return this.deftype_(new CallFrame("deftype", a0.getMeta()), args, env);
                }
                case 14: {
                    return this.deftypeQ_(new CallFrame("deftype?", a0.getMeta()), args, env);
                }
                case 15: {
                    return this.deftype_of_(new CallFrame("deftype-of", a0.getMeta()), args, env);
                }
                case 16: {
                    return this.deftype_or_(new CallFrame("deftype-or", a0.getMeta()), args, env);
                }
                case 17: {
                    return this.deftype_create_(new CallFrame(".:", a0.getMeta()), args, env);
                }
                case 18: {
                    return this.defmulti_(new CallFrame("defmulti", a0.getMeta()), args, env);
                }
                case 19: {
                    return this.defmethod_(new CallFrame("defmethod", a0.getMeta()), args, env, a0.getMeta());
                }
                case 20: {
                    return this.ns_(new CallFrame("ns", a0.getMeta()), args, env);
                }
                case 21: {
                    return this.ns_remove_(new CallFrame("ns-remove", a0.getMeta()), args, env);
                }
                case 22: {
                    return this.ns_unmap_(new CallFrame("ns-unmap", a0.getMeta()), args, env);
                }
                case 23: {
                    return this.ns_list_(new CallFrame("ns-list", a0.getMeta()), args, env);
                }
                case 24: {
                    return this.import_(new CallFrame("import", a0.getMeta()), args, env);
                }
                case 25: {
                    return this.imports_(new CallFrame("imports", a0.getMeta()), args, env);
                }
                case 26: {
                    return this.namespace_(new CallFrame("namespace", a0.getMeta()), args, env);
                }
                case 27: {
                    return this.resolve_(new CallFrame("resolve", a0.getMeta()), args, env);
                }
                case 28: {
                    return this.var_get_(new CallFrame("var-get", a0.getMeta()), args, env);
                }
                case 29: {
                    return this.var_ns_(new CallFrame("var-ns", a0.getMeta()), args, env);
                }
                case 30: {
                    return this.var_name_(new CallFrame("var-name", a0.getMeta()), args, env);
                }
                case 31: {
                    return this.var_localQ_(new CallFrame("var-local?", a0.getMeta()), args, env);
                }
                case 32: {
                    return this.var_thread_localQ_(new CallFrame("var-thread-local?", a0.getMeta()), args, env);
                }
                case 33: {
                    return this.var_globalQ_(new CallFrame("var-global?", a0.getMeta()), args, env);
                }
                case 34: {
                    return this.setBANG_(new CallFrame("set!", a0.getMeta()), args, env);
                }
                case 35: {
                    return this.inspect_(new CallFrame("inspect", a0.getMeta()), args, env);
                }
                case 36: {
                    return this.macroexpand(new CallFrame("macroexpand", a0.getMeta()), args, env, null);
                }
                case 37: {
                    return this.macroexpand_all(new CallFrame("macroexpand-all*", a0.getMeta()), this.evaluate(args.first(), env), env);
                }
                case 38: {
                    return this.macroexpand_info_(new CallFrame("macroexpand-info", a0.getMeta()), args, env);
                }
                case 39: {
                    return this.doc_(new CallFrame("doc", a0.getMeta()), args, env);
                }
                case 40: {
                    return this.print_highlight_(new CallFrame("print-highlight", a0.getMeta()), args, env);
                }
                case 41: {
                    return this.modules_(new CallFrame("modules", a0.getMeta()), args, env);
                }
                case 42: {
                    return this.binding_(args, new Env(env), a0.getMeta());
                }
                case 43: {
                    return VncBoolean.of(env.isBound(Coerce.toVncSymbol(this.evaluate(args.first(), env))));
                }
                case 44: {
                    return new VncLong(env.globalsCount());
                }
                case 45: {
                    return this.try_(new CallFrame("try", a0.getMeta()), args, new Env(env));
                }
                case 46: {
                    return this.try_with_(new CallFrame("try-with", a0.getMeta()), args, new Env(env));
                }
                case 47: {
                    return this.locking_(new CallFrame("locking", a0.getMeta()), args, env);
                }
                case 48: {
                    this.specialFormCallValidation("dorun");
                    return this.dorun_(new CallFrame("dorun", a0.getMeta()), args, env);
                }
                case 49: {
                    this.specialFormCallValidation("dobench");
                    return this.dobench_(new CallFrame("dobench", a0.getMeta()), args, env);
                }
                case 50: {
                    this.specialFormCallValidation("prof");
                    return this.prof_(new CallFrame("prof", a0.getMeta()), args, env);
                }
                case 51: {
                    return this.tail_pos_check(tailPosition, new CallFrame("tail-pos", a0.getMeta()), args, env);
                }
                default: {
                    v0 = fn0 = a0 instanceof VncSymbol != false ? env.get((VncSymbol)a0) : this.evaluate(a0, env);
                    if (fn0 instanceof VncFunction) {
                        fn = (VncFunction)fn0;
                        if (fn.isMacro()) {
                            expandedAst = this.macroexpand(ast, env, null);
                            if (expandedAst instanceof VncList) {
                                orig_ast = expandedAst;
                                continue block194;
                            }
                            return this.evaluate_values(expandedAst, env);
                        }
                        fnArgs = (VncList)this.evaluate_sequence_values(args, env);
                        fnName = fn.getQualifiedName();
                        v1 = nanos = this.meterRegistry.enabled != false ? System.nanoTime() : 0L;
                        if (this.checkSandbox) {
                            this.interceptor.validateVeniceFunction(fnName);
                            this.interceptor.validateMaxExecutionTime();
                        }
                        this.checkInterrupted(fnName);
                        callStack = ThreadLocalMap.getCallStack();
                        if (tailPosition && !fn.isNative() && !callStack.isEmpty() && fnName.equals(callStack.peek().getFnName())) {
                            f = fn.getFunctionForArgs(fnArgs);
                            env.addLocalVars(Destructuring.destructure(f.getParams(), fnArgs));
                            body = (VncList)f.getBody();
                            this.evaluate_sequence_values(body.butlast(), env);
                            orig_ast = body.last();
                            break;
                        }
                        try {
                            callStack.push(new CallFrame(fn.getQualifiedName(), a0.getMeta()));
                            var21_46 = fn.apply(fnArgs);
                            return var21_46;
                        }
                        finally {
                            callStack.pop();
                            this.checkInterrupted(fnName);
                            if (this.checkSandbox) {
                                this.interceptor.validateMaxExecutionTime();
                            }
                            if (this.meterRegistry.enabled) {
                                elapsed = System.nanoTime() - nanos;
                                if (fn instanceof VncMultiArityFunction) {
                                    f = fn.getFunctionForArgs(fnArgs);
                                    this.meterRegistry.record(fn.getQualifiedName() + "[" + f.getParams().size() + "]", elapsed);
                                } else {
                                    this.meterRegistry.record(fn.getQualifiedName(), elapsed);
                                }
                            }
                        }
                    }
                    if (fn0 instanceof IVncFunction) {
                        cs = new WithCallStack(new CallFrame(fn0.getType().toString(), a0.getMeta()));
                        var16_17 = null;
                        try {
                            fn = (IVncFunction)fn0;
                            fnArgs = (VncList)this.evaluate_sequence_values(args, env);
                            var19_40 = fn.apply(fnArgs);
                            return var19_40;
                        }
                        catch (Throwable var17_31) {
                            var16_17 = var17_31;
                            throw var17_31;
                        }
                        finally {
                            if (cs != null) {
                                if (var16_17 != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var20_45) {
                                        var16_17.addSuppressed(var20_45);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                        }
                    }
                    cs = new WithCallStack(new CallFrame(a0sym, a0.getMeta()));
                    var16_17 = null;
                    try {
                        try {
                            throw new VncException(String.format("Expected a function or keyword/set/map/vector as s-expression symbol value but got a value of type '%s'!", new Object[]{Types.getType(fn0)}));
                        }
                        catch (Throwable var17_32) {
                            var16_17 = var17_32;
                            throw var17_32;
                        }
                    }
                    catch (Throwable var42_70) {
                        if (cs != null) {
                            if (var16_17 != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var43_71) {
                                    var16_17.addSuppressed(var43_71);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw var42_70;
                    }
                }
            }
        }
    }

    private VncVal evaluate_values(VncVal ast, Env env) {
        if (ast == Constants.Nil) {
            return Constants.Nil;
        }
        if (ast instanceof VncSymbol) {
            return env.get((VncSymbol)ast);
        }
        if (ast instanceof VncSequence) {
            return this.evaluate_sequence_values((VncSequence)ast, env);
        }
        if (ast instanceof VncMap) {
            VncMap map = (VncMap)ast;
            HashMap<VncVal, VncVal> vals = new HashMap<VncVal, VncVal>(map.size());
            for (Map.Entry<VncVal, VncVal> e : map.getJavaMap().entrySet()) {
                vals.put(this.evaluate(e.getKey(), env), this.evaluate(e.getValue(), env));
            }
            return map.withValues(vals);
        }
        if (ast instanceof VncSet) {
            VncSet set = (VncSet)ast;
            ArrayList<VncVal> vals = new ArrayList<VncVal>(set.size());
            for (VncVal v : set) {
                vals.add(this.evaluate(v, env));
            }
            return set.withValues(vals);
        }
        return ast;
    }

    private VncSequence evaluate_sequence_values(VncSequence seq, Env env) {
        switch (seq.size()) {
            case 0: {
                return seq;
            }
            case 1: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env));
            }
            case 2: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env));
            }
            case 3: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env), this.evaluate(seq.third(), env));
            }
            case 4: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env), this.evaluate(seq.third(), env), this.evaluate(seq.fourth(), env));
            }
        }
        return seq.map(v -> this.evaluate((VncVal)v, env));
    }

    private VncVal macroexpand(VncVal ast, Env env, AtomicInteger expandedMacrosCounter) {
        VncVal fn;
        VncVal a0;
        long nanos = this.meterRegistry.enabled ? System.nanoTime() : 0L;
        VncVal ast_ = ast;
        int expandedMacros = 0;
        while (ast_ instanceof VncList && (a0 = ((VncList)ast_).first()) instanceof VncSymbol && (fn = env.getGlobalOrNull((VncSymbol)a0)) != null && fn instanceof VncFunction && ((VncFunction)fn).isMacro()) {
            VncFunction macro = (VncFunction)fn;
            VncList macroArgs = ((VncList)ast_).rest();
            if (this.checkSandbox) {
                this.interceptor.validateVeniceFunction(macro.getQualifiedName());
            }
            ++expandedMacros;
            WithCallStack cs = new WithCallStack(new CallFrame(macro.getQualifiedName(), a0.getMeta()));
            Throwable throwable = null;
            try {
                if (this.meterRegistry.enabled) {
                    long nanosRun = System.nanoTime();
                    ast_ = macro.apply(macroArgs);
                    this.meterRegistry.record(macro.getQualifiedName() + "[m]", System.nanoTime() - nanosRun);
                    continue;
                }
                ast_ = macro.apply(macroArgs);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cs == null) continue;
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                cs.close();
            }
        }
        if (expandedMacros > 0) {
            this.macroExpandCount.addAndGet(expandedMacros);
            if (this.meterRegistry.enabled) {
                this.meterRegistry.record("macroexpand", System.nanoTime() - nanos);
            }
        }
        if (expandedMacrosCounter != null) {
            expandedMacrosCounter.addAndGet(expandedMacros);
        }
        return ast_;
    }

    private VncVal macroexpand(CallFrame callframe, VncList args, Env env, AtomicInteger expandedMacrosCounter) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("macroexpand", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal ast = this.evaluate(args.first(), env);
            VncVal vncVal = this.macroexpand(ast, env, expandedMacrosCounter);
            return vncVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal macroexpand_all(CallFrame callframe, VncVal form, final Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal vncVal;
            final AtomicInteger expandedMacroCounter = new AtomicInteger(0);
            VncFunction handler = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-handler")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncList list;
                    VncVal first;
                    VncVal form = args.first();
                    if (Types.isVncList(form) && Types.isVncSymbol(first = (list = (VncList)form).first())) {
                        VncVal second = list.second();
                        if (list.size() == 2 && "ns".equals(((VncSymbol)first).getName()) && second instanceof VncSymbol) {
                            Namespaces.setCurrentNamespace(VeniceInterpreter.this.nsRegistry.computeIfAbsent((VncSymbol)second));
                        } else {
                            return VeniceInterpreter.this.macroexpand(list, env, expandedMacroCounter);
                        }
                    }
                    return form;
                }
            };
            final VncFunction walk = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-walk")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncFunction inner = (VncFunction)args.first();
                    VncVal form = args.second();
                    if (Types.isVncList(form)) {
                        return TransducerFunctions.map.applyOf(inner, form);
                    }
                    if (Types.isVncMapEntry(form)) {
                        return CoreFunctions.new_map_entry.applyOf(inner.applyOf(((VncMapEntry)form).getKey()), inner.applyOf(((VncMapEntry)form).getValue()));
                    }
                    if (Types.isVncCollection(form)) {
                        return CoreFunctions.into.applyOf(CoreFunctions.empty.applyOf(form), TransducerFunctions.map.applyOf(inner, form));
                    }
                    return form;
                }
            };
            VncFunction prewalk = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-prewalk")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncFunction f = (VncFunction)args.first();
                    VncVal form = args.second();
                    return walk.applyOf(CoreFunctions.partial.applyOf(this, f), f.applyOf(form));
                }
            };
            Namespace original_ns = Namespaces.getCurrentNamespace();
            try {
                VncVal expanded = prewalk.applyOf(handler, form);
                int count = expandedMacroCounter.get();
                if (count == 0) {
                    this.macroExpandAllCount.incrementAndGet();
                } else {
                    this.macroExpandAllCount.incrementAndGet();
                    this.macroExpandAllCountEffective.incrementAndGet();
                }
                vncVal = expanded;
            }
            catch (Throwable throwable2) {
                try {
                    Namespaces.setCurrentNamespace(original_ns);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            Namespaces.setCurrentNamespace(original_ns);
            return vncVal;
        }
    }

    private static boolean isNonEmptySequence(VncVal x) {
        return Types.isVncSequence(x) && !((VncSequence)x).isEmpty();
    }

    private static VncVal quasiquote(VncVal ast) {
        if (VeniceInterpreter.isNonEmptySequence(ast)) {
            VncVal a00;
            VncVal a0 = Coerce.toVncSequence(ast).first();
            if (Types.isVncSymbol(a0) && ((VncSymbol)a0).getName().equals("unquote")) {
                return ((VncSequence)ast).second();
            }
            if (VeniceInterpreter.isNonEmptySequence(a0) && Types.isVncSymbol(a00 = Coerce.toVncSequence(a0).first()) && ((VncSymbol)a00).getName().equals("splice-unquote")) {
                return VncList.of(new VncSymbol("concat"), Coerce.toVncSequence(a0).second(), VeniceInterpreter.quasiquote(((VncSequence)ast).rest()));
            }
            return VncList.of(new VncSymbol("cons"), VeniceInterpreter.quasiquote(a0), VeniceInterpreter.quasiquote(((VncSequence)ast).rest()));
        }
        return VncList.of(new VncSymbol("quote"), ast);
    }

    private VncVal defmacro_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity("defmacro", ArityExceptions.FnType.SpecialForm, args, 2);
            VncFunction vncFunction = this.defmacro_(args, env);
            return vncFunction;
        }
    }

    private VncFunction defmacro_(VncList args, Env env) {
        VncSymbol macroName;
        VncVal meta;
        int argPos = 0;
        if (MetaUtil.isPrivate(meta = (macroName = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(args.nth(argPos++), env))).getMeta())) {
            throw new VncException(String.format("The macro '%s' must not be defined as private! Venice does not support private macros.", macroName.getName()));
        }
        VncSequence paramsOrSig = Coerce.toVncSequence(args.nth(argPos));
        String name = macroName.getName();
        String ns = macroName.getNamespace();
        if (ns == null && !Namespaces.isCoreNS(ns = Namespaces.getCurrentNS().getName())) {
            name = ns + "/" + name;
        }
        meta = MetaUtil.addMetaVal(meta, MetaUtil.NS, new VncString(ns), MetaUtil.MACRO, VncBoolean.True);
        VncSymbol macroName_ = new VncSymbol(name, meta);
        if (Types.isVncVector(paramsOrSig)) {
            VncVector params = (VncVector)paramsOrSig;
            VncList body = args.slice(++argPos);
            VncFunction macroFn = this.buildFunction(macroName_.getName(), params, body, null, true, env);
            env.setGlobal(new Var(macroName_, macroFn.withMeta(meta), false));
            return macroFn;
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        args.slice(argPos).forEach((Consumer<? super VncVal>)((Consumer<VncVal>)s -> {
            int pos = 0;
            VncList fnSig = Coerce.toVncList(s);
            VncVector fnParams = Coerce.toVncVector(fnSig.nth(pos++));
            VncList fnBody = fnSig.slice(pos);
            fns.add(this.buildFunction(macroName_.getName() + "-arity-" + fnParams.size(), fnParams, fnBody, null, true, env));
        }));
        VncMultiArityFunction macroFn = new VncMultiArityFunction(macroName_.getName(), fns, true).withMeta(meta);
        env.setGlobal(new Var(macroName_, macroFn, false));
        return macroFn;
    }

    private VncVal def_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("def", ArityExceptions.FnType.SpecialForm, args, 1, 2);
            VncSymbol name = this.validateSymbolWithCurrNS(this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(args.first(), env)), "def");
            VncVal val = args.second();
            VncVal res = this.evaluate(val, env).withMeta(name.getMeta());
            env.setGlobal(new Var(name, res, true));
            VncSymbol vncSymbol = name;
            return vncSymbol;
        }
    }

    private VncVal defonce_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("defonce", ArityExceptions.FnType.SpecialForm, args, 1, 2);
            VncSymbol name = this.validateSymbolWithCurrNS(this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(args.first(), env)), "defonce");
            VncVal val = args.second();
            VncVal res = this.evaluate(val, env).withMeta(name.getMeta());
            env.setGlobal(new Var(name, res, false));
            VncSymbol vncSymbol = name;
            return vncSymbol;
        }
    }

    private VncVal def_dynamic_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("def-dynamic", ArityExceptions.FnType.SpecialForm, args, 1, 2);
            VncSymbol name = this.validateSymbolWithCurrNS(this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(args.first(), env)), "def-dynamic");
            VncVal val = args.second();
            VncVal res = this.evaluate(val, env).withMeta(name.getMeta());
            env.setGlobalDynamic(name, res);
            VncSymbol vncSymbol = name;
            return vncSymbol;
        }
    }

    private VncVal deftype_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("deftype", ArityExceptions.FnType.SpecialForm, args, 2, 3);
            VncKeyword type = Coerce.toVncKeyword(this.evaluate(args.first(), env));
            VncVector fields = Coerce.toVncVector(args.second());
            VncFunction validationFn = args.size() == 3 ? Coerce.toVncFunction(this.evaluate(args.third(), env)) : null;
            VncVal vncVal = DefTypeForm.defineCustomType(type, fields, validationFn, this::RE, env);
            return vncVal;
        }
    }

    private VncVal deftypeQ_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("deftype?", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal type = this.evaluate(args.first(), env);
            VncBoolean vncBoolean = VncBoolean.of(DefTypeForm.isCustomType(type, env));
            return vncBoolean;
        }
    }

    private VncVal deftype_of_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity("deftype-of", ArityExceptions.FnType.SpecialForm, args, 2);
            VncKeyword type = Coerce.toVncKeyword(this.evaluate(args.first(), env));
            VncKeyword baseType = Coerce.toVncKeyword(this.evaluate(args.second(), env));
            VncFunction validationFn = args.size() == 3 ? Coerce.toVncFunction(this.evaluate(args.third(), env)) : null;
            VncVal vncVal = DefTypeForm.defineCustomWrapperType(type, baseType, validationFn, this::RE, env, this.wrappableTypes);
            return vncVal;
        }
    }

    private VncVal deftype_or_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity("deftype-or", ArityExceptions.FnType.SpecialForm, args, 2);
            VncKeyword type = Coerce.toVncKeyword(this.evaluate(args.first(), env));
            VncList choiceVals = args.rest();
            VncVal vncVal = DefTypeForm.defineCustomChoiceType(type, choiceVals, this::RE, env);
            return vncVal;
        }
    }

    private VncVal deftype_create_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity(".:", ArityExceptions.FnType.SpecialForm, args, 1);
            ArrayList<VncVal> evaluatedArgs = new ArrayList<VncVal>();
            for (VncVal v : args) {
                evaluatedArgs.add(this.evaluate(v, env));
            }
            VncVal vncVal = DefTypeForm.createType(evaluatedArgs, env);
            return vncVal;
        }
    }

    private VncVal defmulti_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal dispatchFn;
            ArityExceptions.assertArity("defmulti", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSymbol name = this.validateSymbolWithCurrNS(this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(args.first(), env)), "defmulti");
            if (Types.isVncKeyword(args.second())) {
                dispatchFn = (VncKeyword)args.second();
            } else if (Types.isVncSymbol(args.second())) {
                dispatchFn = Coerce.toVncFunction(env.get((VncSymbol)args.second()));
            } else {
                VncList fnAst = Coerce.toVncList(args.second());
                dispatchFn = this.fn_(callframe, fnAst.rest(), env);
            }
            VncMultiFunction multiFn = new VncMultiFunction(name.getName(), (IVncFunction)((Object)dispatchFn)).withMeta(name.getMeta());
            env.setGlobal(new Var(name, multiFn, true));
            VncMultiFunction vncMultiFunction = multiFn;
            return vncMultiFunction;
        }
    }

    private VncVal defmethod_(CallFrame callframe, VncList args, Env env, VncVal meta) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity("defmethod", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSymbol multiFnName = this.qualifySymbolWithCurrNS(Coerce.toVncSymbol(args.first()));
            VncVal multiFnVal = env.getGlobalOrNull(multiFnName);
            if (multiFnVal == null) {
                throw new VncException(String.format("No multifunction '%s' defined for the method definition", multiFnName.getName()));
            }
            VncMultiFunction multiFn = Coerce.toVncMultiFunction(multiFnVal);
            VncVal dispatchVal = args.second();
            VncVector params = Coerce.toVncVector(args.third());
            if (params.size() != multiFn.getParams().size()) {
                throw new VncException(String.format("A method definition for the multifunction '%s' must have %d parameters", multiFnName.getName(), multiFn.getParams().size()));
            }
            VncVector preConditions = this.getFnPreconditions(args.nth(3), env);
            VncList body = args.slice(preConditions == null ? 3 : 4);
            VncFunction fn = this.buildFunction(multiFnName.getName(), params, body, preConditions, false, env);
            VncMultiFunction vncMultiFunction = multiFn.addFn(dispatchVal, fn.withMeta(meta));
            return vncMultiFunction;
        }
    }

    private VncVal ns_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncSymbol ns;
            this.specialFormCallValidation("ns");
            ArityExceptions.assertArity("ns", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal name = args.first();
            VncSymbol vncSymbol = ns = Types.isVncSymbol(name) ? (VncSymbol)name : (VncSymbol)CoreFunctions.symbol.apply(VncList.of(this.evaluate(name, env)));
            if (ns.hasNamespace()) {
                throw new VncException(String.format("A namespace '%s' must not have itself a namespace! However you can use '%s'.", ns.getQualifiedName(), ns.getNamespace() + "." + ns.getSimpleName()));
            }
            if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                throw new VncException("Namespace '" + ns.getName() + "' cannot be reopened!");
            }
            Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent(ns));
            VncSymbol vncSymbol2 = ns;
            return vncSymbol2;
        }
    }

    private VncVal ns_remove_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("ns-remove");
            ArityExceptions.assertArity("ns-remove", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol ns = Namespaces.lookupNS(args.first(), env);
            if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                throw new VncException("Namespace '" + ns.getName() + "' cannot be removed!");
            }
            env.removeGlobalSymbolsByNS(ns);
            this.nsRegistry.remove(ns);
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    private VncVal ns_unmap_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("ns-unmap");
            ArityExceptions.assertArity("ns-unmap", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSymbol ns = Namespaces.lookupNS(args.first(), env);
            if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                throw new VncException("Cannot remove a symbol from namespace '" + ns.getName() + "'!");
            }
            VncSymbol sym = Coerce.toVncSymbol(args.second()).withNamespace(ns);
            env.removeGlobalSymbol(sym);
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    private VncVal ns_list_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("ns-list");
            ArityExceptions.assertArity("ns-list", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol ns = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluate(args.first(), env));
            String nsName = ns.getName();
            VncList vncList = VncList.ofList(env.getAllGlobalSymbols().keySet().stream().map(s -> {
                String n = env.getNamespace((VncSymbol)s);
                return new VncSymbol(n, s.getSimpleName(), Constants.Nil);
            }).filter(s -> nsName.equals(s.getNamespace())).sorted().collect(Collectors.toList()));
            return vncList;
        }
    }

    private VncVal import_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity("import", ArityExceptions.FnType.SpecialForm, args, 0);
            args.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)i -> Namespaces.getCurrentNamespace().getJavaImports().add(Coerce.toVncString(i).getValue())));
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    private VncVal imports_(CallFrame callframe, VncList args, Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            if (args.isEmpty()) {
                VncList vncList = Namespaces.getCurrentNamespace().getJavaImportsAsVncList();
                return vncList;
            }
            VncSymbol ns = Coerce.toVncSymbol(args.first());
            Namespace namespace = this.nsRegistry.get(ns);
            if (namespace != null) {
                VncList vncList = namespace.getJavaImportsAsVncList();
                return vncList;
            }
            try {
                throw new VncException(String.format("The namespace '%s' does not exist", ns.toString()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private VncVal namespace_(CallFrame callframe, VncList args, Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("namespace", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal val = this.evaluate(args.first(), env);
            if (val instanceof INamespaceAware) {
                VncString vncString = new VncString(((INamespaceAware)((Object)val)).getNamespace());
                return vncString;
            }
            try {
                throw new VncException(String.format("The type '%s' does not support namespaces!", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private VncVal resolve_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("resolve", ArityExceptions.FnType.SpecialForm, args, 1);
            this.specialFormCallValidation("resolve");
            VncVal vncVal = env.getOrNil(Coerce.toVncSymbol(this.evaluate(args.first(), env)));
            return vncVal;
        }
    }

    private VncVal var_get_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("var-get", ArityExceptions.FnType.SpecialForm, args, 1);
            this.specialFormCallValidation("var-get");
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluate(args.first(), env));
            VncVal vncVal = env.getOrNil(sym);
            return vncVal;
        }
    }

    private VncVal var_ns_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("var-ns", ArityExceptions.FnType.SpecialForm, args, 1);
            this.specialFormCallValidation("var-ns");
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluate(args.first(), env));
            String ns = env.getNamespace(sym);
            VncVal vncVal = ns == null ? Constants.Nil : new VncString(ns);
            return vncVal;
        }
    }

    private VncVal var_name_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("var-name", ArityExceptions.FnType.SpecialForm, args, 1);
            this.specialFormCallValidation("var-name");
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluate(args.first(), env));
            VncString vncString = new VncString(sym.getSimpleName());
            return vncString;
        }
    }

    private VncVal var_localQ_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("var-local?", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluate(args.first(), env));
            VncBoolean vncBoolean = VncBoolean.of(env.isLocal(sym));
            return vncBoolean;
        }
    }

    private VncVal var_thread_localQ_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("var-thread-local?", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluate(args.first(), env));
            VncBoolean vncBoolean = VncBoolean.of(env.isThreadLocal(sym));
            return vncBoolean;
        }
    }

    private VncVal var_globalQ_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("var-global?", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluate(args.first(), env));
            VncBoolean vncBoolean = VncBoolean.of(env.isGlobal(sym));
            return vncBoolean;
        }
    }

    private VncVal setBANG_(CallFrame callframe, VncList args, Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("set!", ArityExceptions.FnType.SpecialForm, args, 2);
            this.specialFormCallValidation("set!");
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluate(args.first(), env));
            Var globVar = env.getGlobalVarOrNull(sym);
            if (globVar != null) {
                VncVal expr = args.second();
                VncVal val = this.evaluate(expr, env);
                if (globVar instanceof DynamicVar) {
                    env.popGlobalDynamic(globVar.getName());
                    env.pushGlobalDynamic(globVar.getName(), val);
                } else {
                    env.setGlobal(new Var(globVar.getName(), val, globVar.isOverwritable()));
                }
                VncVal vncVal = val;
                return vncVal;
            }
            try {
                throw new VncException(String.format("The global or thread-local var '%s' does not exist!", sym.getName()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private VncVal inspect_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("inspect", ArityExceptions.FnType.SpecialForm, args, 1);
            this.specialFormCallValidation("inspect");
            VncSymbol sym = Coerce.toVncSymbol(this.evaluate(args.first(), env));
            VncVal vncVal = Inspector.inspect(env.get(sym));
            return vncVal;
        }
    }

    private VncVal macroexpand_info_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncHashMap vncHashMap = VncHashMap.of(new VncKeyword("macroexpand-count"), new VncLong(this.macroExpandCount.get()), new VncKeyword("macroexpand-all-count"), new VncLong(this.macroExpandAllCount.get()), new VncKeyword("macroexpand-all-count-effective"), new VncLong(this.macroExpandAllCountEffective.get()));
            return vncHashMap;
        }
    }

    private VncVal doc_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("doc", ArityExceptions.FnType.SpecialForm, args, 1);
            VncString doc = DocForm.doc(args.first(), env);
            this.evaluate(VncList.of(new VncSymbol("println"), doc), env);
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    private VncVal print_highlight_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("print-highlight", ArityExceptions.FnType.SpecialForm, args, 1);
            VncString form = DocForm.highlight(Coerce.toVncString(args.first()), env);
            this.evaluate(VncList.of(new VncSymbol("println"), form), env);
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    private VncVal modules_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncList vncList = VncList.ofList(Modules.VALID_MODULES.stream().filter(s -> !s.equals("core")).sorted().map(s -> new VncKeyword((String)s)).collect(Collectors.toList()));
            return vncList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal eval_(CallFrame callframe, VncList args, Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal vncVal;
            ArityExceptions.assertMinArity("eval", ArityExceptions.FnType.SpecialForm, args, 0);
            this.specialFormCallValidation("eval");
            Namespace ns = Namespaces.getCurrentNamespace();
            try {
                vncVal = this.evaluate(Coerce.toVncSequence(this.evaluate_sequence_values(args, env)).last(), env);
            }
            catch (Throwable throwable2) {
                try {
                    Namespaces.setCurrentNamespace(ns);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            Namespaces.setCurrentNamespace(ns);
            return vncVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal dorun_(CallFrame callframe, VncList args, Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal vncVal;
            ArityExceptions.assertArity("dorun", ArityExceptions.FnType.SpecialForm, args, 2);
            long count = Coerce.toVncLong(args.first()).getValue();
            if (count <= 0L) {
                VncConstant vncConstant = Constants.Nil;
                return vncConstant;
            }
            VncVal expr = args.second();
            try {
                VncVal first = this.evaluate(expr, env);
                int ii = 1;
                while ((long)ii < count) {
                    VncVal result = this.evaluate(expr, env);
                    this.checkInterrupted("dorun");
                    ThreadLocalMap.set(new VncKeyword("*benchmark-val*"), new VncJust(result));
                    ++ii;
                }
                vncVal = first;
            }
            catch (Throwable throwable2) {
                try {
                    ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
            return vncVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal dobench_(CallFrame callframe, VncList args, Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncList vncList;
            ArityExceptions.assertArity("dobench", ArityExceptions.FnType.SpecialForm, args, 2);
            try {
                long count = Coerce.toVncLong(args.first()).getValue();
                VncVal expr = args.second();
                ArrayList<VncLong> elapsed = new ArrayList<VncLong>();
                int ii = 0;
                while ((long)ii < count) {
                    long start = System.nanoTime();
                    VncVal result = this.evaluate(expr, env);
                    long end = System.nanoTime();
                    elapsed.add(new VncLong(end - start));
                    this.checkInterrupted("dobench");
                    ThreadLocalMap.set(new VncKeyword("*benchmark-val*"), new VncJust(result));
                    ++ii;
                }
                vncList = VncList.ofList(elapsed);
            }
            catch (Throwable throwable2) {
                try {
                    ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
            return vncList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal locking_(CallFrame callframe, VncList args, Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal mutex;
            ArityExceptions.assertMinArity("locking", ArityExceptions.FnType.SpecialForm, args, 2);
            VncVal vncVal = mutex = this.evaluate(args.first(), env);
            synchronized (vncVal) {
                try {
                    VncVal vncVal2 = this.evaluateBody(args.rest(), env, true);
                    return vncVal2;
                }
                catch (Throwable throwable2) {
                    try {
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
            }
        }
    }

    private VncVal tail_pos_check(boolean inTailPosition, CallFrame callframe, VncList args, Env env) {
        if (!inTailPosition) {
            VncString name = Coerce.toVncString(args.nthOrDefault(0, VncString.empty()));
            WithCallStack cs = new WithCallStack(callframe);
            Throwable throwable = null;
            try {
                try {
                    throw new NotInTailPositionException(name.isEmpty() ? "Not in tail position" : String.format("Not '%s' in tail position", name.getValue()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        return Constants.Nil;
    }

    private VncFunction fn_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncSymbol name;
            int argPos;
            ArityExceptions.assertMinArity("fn", ArityExceptions.FnType.SpecialForm, args, 1);
            if (Types.isVncSymbol(args.first())) {
                argPos = 1;
                name = (VncSymbol)args.first();
            } else {
                argPos = 0;
                name = new VncSymbol(VncFunction.createAnonymousFuncName());
            }
            VncSymbol fnName = this.qualifySymbolWithCurrNS(name);
            ReservedSymbols.validateNotReservedSymbol(fnName);
            VncSequence paramsOrSig = Coerce.toVncSequence(args.nth(argPos));
            if (Types.isVncVector(paramsOrSig)) {
                VncVector preCon;
                VncVector params = (VncVector)paramsOrSig;
                if ((preCon = this.getFnPreconditions(args.nthOrDefault(++argPos, null), env)) != null) {
                    ++argPos;
                }
                VncList body = args.slice(argPos);
                VncFunction vncFunction = this.buildFunction(fnName.getName(), params, body, preCon, false, env);
                return vncFunction;
            }
            ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
            args.slice(argPos).forEach((Consumer<? super VncVal>)((Consumer<VncVal>)s -> {
                int pos = 0;
                VncList sig = Coerce.toVncList(s);
                VncVector params = Coerce.toVncVector(sig.nth(pos++));
                VncVector preCon = this.getFnPreconditions(sig.nth(pos), env);
                if (preCon != null) {
                    ++pos;
                }
                VncList body = sig.slice(pos);
                fns.add(this.buildFunction(fnName.getName(), params, body, preCon, false, env));
            }));
            VncMultiArityFunction vncMultiArityFunction = new VncMultiArityFunction(fnName.getName(), fns, false);
            return vncMultiArityFunction;
        }
    }

    private VncVal prof_(CallFrame callframe, VncList args, Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("prof", ArityExceptions.FnType.SpecialForm, args, 1, 2, 3);
            if (Types.isVncKeyword(args.first())) {
                VncKeyword cmd = (VncKeyword)args.first();
                switch (cmd.getValue()) {
                    case "on": 
                    case "enable": {
                        this.meterRegistry.enable();
                        VncKeyword vncKeyword = new VncKeyword("on");
                        return vncKeyword;
                    }
                    case "off": 
                    case "disable": {
                        this.meterRegistry.disable();
                        VncKeyword vncKeyword = new VncKeyword("off");
                        return vncKeyword;
                    }
                    case "status": {
                        VncKeyword vncKeyword = new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                        return vncKeyword;
                    }
                    case "clear": {
                        this.meterRegistry.reset();
                        VncKeyword vncKeyword = new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                        return vncKeyword;
                    }
                    case "clear-all-but": {
                        this.meterRegistry.resetAllBut(Coerce.toVncSequence(args.second()));
                        VncKeyword vncKeyword = new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                        return vncKeyword;
                    }
                    case "data": {
                        VncList vncList = this.meterRegistry.getVncTimerData();
                        return vncList;
                    }
                    case "data-formatted": {
                        VncVal opt1 = args.second();
                        VncVal opt2 = args.third();
                        String title = "Metrics";
                        if (Types.isVncString(opt1) && !Types.isVncKeyword(opt1)) {
                            title = ((VncString)opt1).getValue();
                        }
                        if (Types.isVncString(opt2) && !Types.isVncKeyword(opt2)) {
                            title = ((VncString)opt2).getValue();
                        }
                        boolean anonFn = false;
                        if (Types.isVncKeyword(opt1)) {
                            boolean bl = anonFn = anonFn || ((VncKeyword)opt1).hasValue("anon-fn");
                        }
                        if (Types.isVncKeyword(opt2)) {
                            anonFn = anonFn || ((VncKeyword)opt2).hasValue("anon-fn");
                        }
                        VncString vncString = new VncString(this.meterRegistry.getTimerDataFormatted(title, anonFn));
                        return vncString;
                    }
                }
            }
            try {
                throw new VncException("Function 'prof' expects a single keyword argument: :on, :off, :status, :clear, :clear-all-but, :data, or :data-formatted");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal binding_(VncList args, Env env, VncVal meta) {
        VncSequence bindings = Coerce.toVncSequence(args.first());
        VncList expressions = args.rest();
        if (bindings.size() % 2 != 0) {
            WithCallStack cs = new WithCallStack(new CallFrame("bindings", meta));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("bindings requires an even number of forms in the binding vector!");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        ArrayList<Var> vars = new ArrayList<Var>();
        for (int i = 0; i < bindings.size(); i += 2) {
            VncVal sym = bindings.nth(i);
            VncVal val = this.evaluate(bindings.nth(i + 1), env);
            vars.addAll(Destructuring.destructure(sym, val));
        }
        try {
            vars.forEach(v -> env.pushGlobalDynamic(v.getName(), v.getVal()));
            this.evaluate_sequence_values(expressions.butlast(), env);
            VncVal vncVal = this.evaluate(expressions.last(), env);
            return vncVal;
        }
        finally {
            vars.forEach(v -> env.popGlobalDynamic(v.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private VncVal try_(CallFrame callframe, VncList args, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal result;
            block22: {
                result = Constants.Nil;
                try {
                    result = this.evaluateBody(this.getTryBody(args), env, true);
                    VncList finallyBlock = this.findFirstFinallyBlock(args);
                    if (finallyBlock == null) break block22;
                    this.evaluateBody(finallyBlock, env, false);
                }
                catch (Throwable th) {
                    VncVal vncVal;
                    block23: {
                        block24: {
                            CatchBlock catchBlock = this.findCatchBlockMatchingThrowable(args, th);
                            if (catchBlock == null) {
                                throw th;
                            }
                            env.setLocal(new Var(catchBlock.getExSym(), new VncJavaObject(th)));
                            vncVal = this.evaluateBody(catchBlock.getBody(), env, false);
                            if (cs == null) break block23;
                            if (var5_5 == null) break block24;
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                            break block23;
                        }
                        cs.close();
                    }
                    return vncVal;
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        VncList finallyBlock = this.findFirstFinallyBlock(args);
                        if (finallyBlock != null) {
                            this.evaluateBody(finallyBlock, env, false);
                        }
                    }
                }
            }
            VncVal vncVal = result;
            return vncVal;
        }
    }

    /*
     * Exception decompiling
     */
    private VncVal try_with_(CallFrame callframe, VncList args, Env env) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private VncList getTryBody(VncList args) {
        String symName;
        VncVal first;
        VncVal e;
        ArrayList<VncVal> body = new ArrayList<VncVal>();
        Iterator<VncVal> iterator = args.iterator();
        while (!(!iterator.hasNext() || Types.isVncList(e = iterator.next()) && Types.isVncSymbol(first = ((VncList)e).first()) && ((symName = ((VncSymbol)first).getName()).equals("catch") || symName.equals("finally")))) {
            body.add(e);
        }
        return VncList.ofList(body);
    }

    private CatchBlock findCatchBlockMatchingThrowable(VncList blocks, Throwable th) {
        for (VncVal b : blocks) {
            VncList block;
            VncVal first;
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("catch") || !this.isCatchBlockMatchingThrowable(block, th)) continue;
            return new CatchBlock(Coerce.toVncSymbol(block.nth(2)), block.slice(3));
        }
        return null;
    }

    private boolean isCatchBlockMatchingThrowable(VncList block, Throwable th) {
        String className = this.resolveClassName(((VncString)block.second()).getValue());
        Class<?> targetClass = ReflectionAccessor.classForName(className);
        return targetClass.isAssignableFrom(th.getClass());
    }

    private VncList findFirstFinallyBlock(VncList blocks) {
        for (VncVal b : blocks) {
            VncList block;
            VncVal first;
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("finally")) continue;
            return block.rest();
        }
        return null;
    }

    private VncFunction buildFunction(final String name, final VncVector params, final VncList body, final VncVector preConditions, final boolean macro, final Env env) {
        final Namespace ns = Namespaces.getCurrentNamespace();
        final boolean switchToFunctionNamespaceAtRuntime = !macro && !name.equals("macroexpand-all");
        final boolean plainSymbolParams = Destructuring.isFnParamsWithoutDestructuring(params);
        final boolean hasPreConditions = preConditions != null && !preConditions.isEmpty();
        return new VncFunction(name, params, macro, preConditions, Constants.Nil){
            private static final long serialVersionUID = -1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VncVal apply(VncList args) {
                if (this.hasVariadicArgs()) {
                    if (args.size() < this.getFixedArgsCount()) {
                        throw new ArityException(ArityExceptions.formatVariadicArityExMsg(this.getQualifiedName(), macro ? ArityExceptions.FnType.Macro : ArityExceptions.FnType.Function, args.size(), this.getFixedArgsCount(), this.getArgLists()));
                    }
                } else if (args.size() != this.getFixedArgsCount()) {
                    throw new ArityException(ArityExceptions.formatArityExMsg(this.getQualifiedName(), macro ? ArityExceptions.FnType.Macro : ArityExceptions.FnType.Function, args.size(), this.getFixedArgsCount(), this.getArgLists()));
                }
                Env localEnv = new Env(env);
                this.addFnArgsToEnv(args, localEnv);
                if (switchToFunctionNamespaceAtRuntime) {
                    ThreadLocalMap threadLocalMap = ThreadLocalMap.get();
                    Namespace curr_ns = threadLocalMap.getCurrentNS();
                    try {
                        threadLocalMap.setCurrentNS(ns);
                        if (hasPreConditions) {
                            this.validateFnPreconditions(localEnv);
                        }
                        VncVal vncVal = VeniceInterpreter.this.evaluateBody(body, localEnv, true);
                        return vncVal;
                    }
                    finally {
                        threadLocalMap.setCurrentNS(curr_ns);
                    }
                }
                if (hasPreConditions) {
                    this.validateFnPreconditions(localEnv);
                }
                return VeniceInterpreter.this.evaluateBody(body, localEnv, false);
            }

            @Override
            public boolean isNative() {
                return false;
            }

            @Override
            public VncVal getBody() {
                return body;
            }

            private void addFnArgsToEnv(VncList args, Env env2) {
                if (plainSymbolParams) {
                    for (int ii = 0; ii < params.size(); ++ii) {
                        env2.setLocal(new Var((VncSymbol)params.nth(ii), args.nthOrDefault(ii, Constants.Nil)));
                    }
                } else {
                    env2.addLocalVars(Destructuring.destructure(params, args));
                }
            }

            private void validateFnPreconditions(Env env2) {
                if (preConditions != null && !preConditions.isEmpty()) {
                    Env local = new Env(env2);
                    for (VncVal v : preConditions) {
                        if (VeniceInterpreter.this.isFnConditionTrue(VeniceInterpreter.this.evaluate(v, local))) continue;
                        WithCallStack cs = new WithCallStack(new CallFrame(name, v.getMeta()));
                        Throwable throwable = null;
                        try {
                            try {
                                throw new AssertionException(String.format("pre-condition assert failed: %s", ((VncString)CoreFunctions.str.apply(VncList.of(v))).getValue()));
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable3) {
                            if (cs != null) {
                                if (throwable != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                }
            }
        };
    }

    private Env buildRecursionEnv(VncList args, Env env, RecursionPoint recursionPoint) {
        Env recur_env = recursionPoint.getLoopEnv();
        int argCount = args.size();
        switch (argCount) {
            case 0: {
                break;
            }
            case 1: {
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(0), this.evaluate(args.first(), env, false)));
                break;
            }
            case 2: {
                VncVal v1 = this.evaluate(args.first(), env, false);
                VncVal v2 = this.evaluate(args.second(), env, false);
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(0), v1));
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(1), v2));
                break;
            }
            default: {
                int ii;
                VncVal[] newValues = new VncVal[argCount];
                for (ii = 0; ii < argCount; ++ii) {
                    newValues[ii] = this.evaluate(args.nth(ii), env, false);
                }
                for (ii = 0; ii < argCount; ++ii) {
                    recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(ii), newValues[ii]));
                }
            }
        }
        return recur_env;
    }

    private VncVector getFnPreconditions(VncVal prePostConditions, Env env) {
        VncVal val;
        if (Types.isVncMap(prePostConditions) && Types.isVncVector(val = ((VncMap)prePostConditions).get(PRE_CONDITION_KEY))) {
            return (VncVector)val;
        }
        return null;
    }

    private boolean isFnConditionTrue(VncVal result) {
        return Types.isVncSequence(result) ? VncBoolean.isTrue(((VncSequence)result).first()) : VncBoolean.isTrue(result);
    }

    private VncVal evaluateBody(VncList body, Env env, boolean withTailPosition) {
        this.evaluate_values(body.butlast(), env);
        if (withTailPosition) {
            return this.evaluateInTailPosition(body.last(), env);
        }
        return this.evaluate(body.last(), env);
    }

    private String resolveClassName(String className) {
        return Namespaces.getCurrentNamespace().getJavaImports().resolveClassName(className);
    }

    private void checkInterrupted(String fnName) {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted while processing function " + fnName);
        }
    }

    private VncSymbol evaluateSymbolMetaData(VncVal symVal, Env env) {
        VncSymbol sym = Coerce.toVncSymbol(symVal);
        ReservedSymbols.validateNotReservedSymbol(sym);
        return sym.withMeta(this.evaluate(sym.getMeta(), env));
    }

    private static <T> List<T> toEmpty(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    private VncSymbol qualifySymbolWithCurrNS(VncSymbol sym) {
        if (sym == null) {
            return null;
        }
        if (sym.hasNamespace()) {
            return new VncSymbol(sym.getName(), MetaUtil.setNamespace(sym.getMeta(), sym.getNamespace()));
        }
        VncSymbol ns = Namespaces.getCurrentNS();
        VncVal newMeta = MetaUtil.setNamespace(sym.getMeta(), ns.getName());
        return Namespaces.isCoreNS(ns) ? new VncSymbol(sym.getName(), newMeta) : new VncSymbol(ns.getName(), sym.getName(), newMeta);
    }

    private VncSymbol validateSymbolWithCurrNS(VncSymbol sym, String specialFormName) {
        String ns;
        if (sym != null && (ns = sym.getNamespace()) != null && !ns.equals(Namespaces.getCurrentNS().getName())) {
            WithCallStack cs = new WithCallStack(new CallFrame(specialFormName, sym.getMeta()));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("Special form '%s': Invalid use of namespace. The symbol '%s' can only be defined for the current namespace '%s'.", specialFormName, sym.getSimpleName(), Namespaces.getCurrentNS().toString()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        return sym;
    }

    private void specialFormCallValidation(String name) {
        JavaInterop.getInterceptor().validateVeniceFunction(name);
    }

    private static /* synthetic */ void lambda$try_with_$11(Var b) {
        VncVal resource = b.getVal();
        if (Types.isVncJavaObject(resource)) {
            Object r = ((VncJavaObject)resource).getDelegate();
            if (r instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)r).close();
                }
                catch (Exception ex) {
                    throw new VncException(String.format("'try-with' failed to close resource %s.", b.getName()));
                }
            }
            if (r instanceof Closeable) {
                try {
                    ((Closeable)r).close();
                }
                catch (Exception ex) {
                    throw new VncException(String.format("'try-with' failed to close resource %s.", b.getName()));
                }
            }
        }
    }
}

