/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen;

import com.github.jlangch.venice.impl.docgen.DocColorTheme;
import com.github.jlangch.venice.impl.reader.HighlightClass;
import com.github.jlangch.venice.impl.reader.HighlightParser;
import com.github.jlangch.venice.impl.util.StringEscapeUtil;
import java.util.stream.Collectors;

public class DocHighlighter {
    private final DocColorTheme theme;
    private static final String TEMPLATE = "<span style=\"color: %s\">%s</span>";

    public DocHighlighter(DocColorTheme theme) {
        this.theme = theme;
    }

    public String highlight(String form) {
        return HighlightParser.parse(form).stream().map(it -> this.style(it.getForm(), it.getClazz())).collect(Collectors.joining());
    }

    public static String style(String text, String htmlColor) {
        return htmlColor == null ? StringEscapeUtil.escapeXml(text) : String.format(TEMPLATE, htmlColor, StringEscapeUtil.escapeXml(text));
    }

    private String style(String text, HighlightClass clazz) {
        return DocHighlighter.style(text, this.theme.getColor(clazz));
    }
}

