/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.IOFunctions;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.csv.CSVReader;
import com.github.jlangch.venice.impl.util.csv.CSVWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CsvFunctions {
    public static VncFunction read = new VncFunction("csv/read", (VncVal)VncFunction.meta().arglists("(csv/read source & options)").doc("Reads CSV-data from a source. The source may be a a string, a bytebuf, a file, a Java InputStream, or a Java Reader.\n\nOptions:\n   :encoding enc - used when reading from a binary data source\n                   e.g :encoding :utf-8, defaults to :utf-8\n   :separator val - e.g. \",\", defaults to a comma\n\t:quote val - e.g. \"'\", defaults to a double quote").examples("(csv/read \"1,\\\"ab\\\",false\")", "(csv/read \"1:::'ab':false\" :separator \":\" :quote \"'\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            try {
                VncVal source = args.first();
                VncHashMap options = VncHashMap.ofAll(args.rest());
                char separator = CsvFunctions.toChar(options.get(new VncKeyword("separator")), ',');
                char quote = CsvFunctions.toChar(options.get(new VncKeyword("quote")), '\"');
                CSVReader parser = new CSVReader(separator, quote);
                if (Types.isVncString(source)) {
                    return CsvFunctions.map(parser.parse(((VncString)source).getValue()));
                }
                if (Types.isVncJavaObject(source, File.class)) {
                    File file = Types.isVncString(source) ? new File(((VncString)source).getValue()) : (File)Coerce.toVncJavaObject(args.first()).getDelegate();
                    IOFunctions.validateReadableFile(file);
                    VncVal encVal = options.get(new VncKeyword("encoding"));
                    try (FileInputStream is = new FileInputStream(file);){
                        VncList vncList = CsvFunctions.map(parser.parse(is, IOFunctions.encoding(encVal)));
                        return vncList;
                    }
                }
                if (Types.isVncJavaObject(source, InputStream.class)) {
                    InputStream is = (InputStream)Coerce.toVncJavaObject(args.first()).getDelegate();
                    VncVal encVal = options.get(new VncKeyword("encoding"));
                    return CsvFunctions.map(parser.parse(is, IOFunctions.encoding(encVal)));
                }
                if (Types.isVncJavaObject(source, Reader.class)) {
                    Reader rd = (Reader)Coerce.toVncJavaObject(args.first()).getDelegate();
                    return CsvFunctions.map(parser.parse(rd));
                }
                throw new VncException(String.format("Function 'csv/read' does not allow %s as f", Types.getType(args.first())));
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction write = new VncFunction("csv/write", (VncVal)VncFunction.meta().arglists("(csv/write writer records & options)").doc("Writes data to a writer in CSV format. The writer is a\nJava java.io.Writer\n\nOptions:\n  :separator val - e.g. \",\", defaults to a comma\n  :quote val - e.g. \"'\", defaults to a double quote\n  :newline val (:lf (default) or :cr+lf)\n").examples("(let [file (io/file \"test.csv\")                                       \n      fs (. :java.io.FileOutputStream :new file)]                       \n  (try-with [writer (. :java.io.OutputStreamWriter :new fs \"utf-8\")]  \n    (csv/write writer [[1 \"AC\" false] [2 \"WS\" true]])))               ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            try {
                VncVal vWriter = args.first();
                VncHashMap options = VncHashMap.ofAll(args.rest().rest());
                char separator = CsvFunctions.toChar(options.get(new VncKeyword("separator")), ',');
                char quote = CsvFunctions.toChar(options.get(new VncKeyword("quote")), '\"');
                String newline = CsvFunctions.toNewLine(options.get(new VncKeyword("newline")));
                CSVWriter csvWriter = new CSVWriter(separator, quote, newline);
                if (Types.isVncJavaObject(vWriter, Writer.class)) {
                    Writer writer = (Writer)Coerce.toVncJavaObject(vWriter).getDelegate();
                    csvWriter.write(writer, Coerce.toVncSequence(args.second()));
                    return Constants.Nil;
                }
                throw new VncException(String.format("Function 'csv/write' does not allow %s as writer", Types.getType(args.first())));
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction write_str = new VncFunction("csv/write-str", (VncVal)VncFunction.meta().arglists("(csv/write-str records & options)").doc("Writes data to a string in CSV format.\n\nOptions:\n  :separator val - e.g. \",\", defaults to a comma\n  :quote val - e.g. \"'\", defaults to a double quote\n  :newline val (:lf (default) or :cr+lf)\n").examples("(csv/write-str [[1 \"AC\" false] [2 \"WS\" true]])", "(csv/write-str [[1 \"AC\" false] [2 \"WS, '-1'\" true]]\n               :quote \"'\"\n               :separator \",\"\n               :newline :cr+lf)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            try {
                VncHashMap options = VncHashMap.ofAll(args.rest());
                char separator = CsvFunctions.toChar(options.get(new VncKeyword("separator")), ',');
                char quote = CsvFunctions.toChar(options.get(new VncKeyword("quote")), '\"');
                String newline = CsvFunctions.toNewLine(options.get(new VncKeyword("newline")));
                CSVWriter csvWriter = new CSVWriter(separator, quote, newline);
                StringWriter sw = new StringWriter();
                csvWriter.write((Writer)sw, Coerce.toVncSequence(args.first()));
                return new VncString(sw.toString());
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(read).add(write).add(write_str).toMap();

    private static VncList map(List<List<String>> data) {
        ArrayList<VncList> vncRecords = new ArrayList<VncList>();
        for (List<String> record : data) {
            ArrayList<VncConstant> vncRecord = new ArrayList<VncConstant>();
            for (String s : record) {
                vncRecord.add((VncConstant)(s == null ? Constants.Nil : new VncString(s)));
            }
            vncRecords.add(VncList.ofList(vncRecord));
        }
        return VncList.ofList(vncRecords);
    }

    private static char toChar(VncVal v, char defaultChar) {
        if (v == Constants.Nil) {
            return defaultChar;
        }
        if (Types.isVncChar(v)) {
            return ((VncChar)v).getValue().charValue();
        }
        if (Types.isVncString(v)) {
            String s = ((VncString)v).getValue();
            return s.isEmpty() ? defaultChar : s.charAt(0);
        }
        return defaultChar;
    }

    private static String toNewLine(VncVal v) {
        if (Types.isVncKeyword(v)) {
            String s = ((VncKeyword)v).getValue();
            if (s.equals("lf")) {
                return "\n";
            }
            if (s.equals("cr+lf")) {
                return "\r\n";
            }
            return "\n";
        }
        if (Types.isVncString(v)) {
            return ((VncString)v).getValue();
        }
        return "\n";
    }
}

