/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBigInteger;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class Numeric {
    public static VncVal add(VncVal op1, VncVal op2) {
        try {
            if (Types.isVncLong(op1)) {
                if (Types.isVncLong(op2)) {
                    return new VncLong(((VncLong)op1).toJavaLong() + ((VncLong)op2).toJavaLong());
                }
                if (Types.isVncInteger(op2)) {
                    return new VncLong(((VncLong)op1).toJavaLong() + ((VncInteger)op2).toJavaLong());
                }
                if (Types.isVncDouble(op2)) {
                    return new VncDouble(((VncLong)op1).toJavaDouble() + ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncLong)op1).toJavaBigDecimal().add(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigInteger(((VncLong)op1).toJavaBigInteger().add(((VncBigInteger)op2).toJavaBigInteger()));
                }
            } else if (Types.isVncDouble(op1)) {
                if (Types.isVncDouble(op2)) {
                    return new VncDouble(((VncDouble)op1).toJavaDouble() + ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncLong(op2)) {
                    return new VncDouble(((VncDouble)op1).toJavaDouble() + ((VncLong)op2).toJavaDouble());
                }
                if (Types.isVncInteger(op2)) {
                    return new VncDouble(((VncDouble)op1).toJavaDouble() + ((VncInteger)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncDouble)op1).toJavaBigDecimal().add(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigDecimal(((VncDouble)op1).toJavaBigDecimal().add(((VncBigInteger)op2).toJavaBigDecimal()));
                }
            } else if (Types.isVncBigDecimal(op1)) {
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().add(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
                if (Types.isVncLong(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().add(((VncLong)op2).toJavaBigDecimal()));
                }
                if (Types.isVncInteger(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().add(((VncInteger)op2).toJavaBigDecimal()));
                }
                if (Types.isVncDouble(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().add(((VncDouble)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().add(((VncBigInteger)op2).toJavaBigDecimal()));
                }
            } else if (Types.isVncBigInteger(op1)) {
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigInteger(((VncBigInteger)op1).toJavaBigInteger().add(((VncBigInteger)op2).toJavaBigInteger()));
                }
                if (Types.isVncLong(op2)) {
                    return new VncBigInteger(((VncBigInteger)op1).toJavaBigInteger().add(((VncLong)op2).toJavaBigInteger()));
                }
                if (Types.isVncInteger(op2)) {
                    return new VncBigInteger(((VncBigInteger)op1).toJavaBigInteger().add(((VncInteger)op2).toJavaBigInteger()));
                }
                if (Types.isVncDouble(op2)) {
                    return new VncBigDecimal(((VncBigInteger)op1).toJavaBigDecimal().add(((VncDouble)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncBigInteger)op1).toJavaBigDecimal().add(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
            } else if (Types.isVncInteger(op1)) {
                if (Types.isVncInteger(op2)) {
                    return new VncInteger(((VncInteger)op1).toJavaInteger() + ((VncInteger)op2).toJavaInteger());
                }
                if (Types.isVncLong(op2)) {
                    return new VncLong(((VncInteger)op1).toJavaLong() + ((VncLong)op2).toJavaLong());
                }
                if (Types.isVncDouble(op2)) {
                    return new VncDouble(((VncInteger)op1).toJavaDouble() + ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncInteger)op1).toJavaBigDecimal().add(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigInteger(((VncInteger)op1).toJavaBigInteger().add(((VncBigInteger)op2).toJavaBigInteger()));
                }
            }
            Numeric.validateNumericTypes("+", op1, op2);
        }
        catch (ArithmeticException ex) {
            throw new VncException(ex.getMessage());
        }
        throw new RuntimeException("Unexpected outcome");
    }

    public static VncVal sub(VncVal op1, VncVal op2) {
        try {
            if (Types.isVncLong(op1)) {
                if (Types.isVncLong(op2)) {
                    return new VncLong(((VncLong)op1).toJavaLong() - ((VncLong)op2).toJavaLong());
                }
                if (Types.isVncInteger(op2)) {
                    return new VncLong(((VncLong)op1).toJavaLong() - ((VncInteger)op2).toJavaLong());
                }
                if (Types.isVncDouble(op2)) {
                    return new VncDouble(((VncLong)op1).toJavaDouble() - ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncLong)op1).toJavaBigDecimal().subtract(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigInteger(((VncLong)op1).toJavaBigInteger().subtract(((VncBigInteger)op2).toJavaBigInteger()));
                }
            } else if (Types.isVncDouble(op1)) {
                if (Types.isVncDouble(op2)) {
                    return new VncDouble(((VncDouble)op1).toJavaDouble() - ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncLong(op2)) {
                    return new VncDouble(((VncDouble)op1).toJavaDouble() - ((VncLong)op2).toJavaDouble());
                }
                if (Types.isVncInteger(op2)) {
                    return new VncDouble(((VncDouble)op1).toJavaDouble() - ((VncInteger)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncDouble)op1).toJavaBigDecimal().subtract(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigDecimal(((VncDouble)op1).toJavaBigDecimal().subtract(((VncBigInteger)op2).toJavaBigDecimal()));
                }
            } else if (Types.isVncBigDecimal(op1)) {
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().subtract(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
                if (Types.isVncLong(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().subtract(((VncLong)op2).toJavaBigDecimal()));
                }
                if (Types.isVncInteger(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().subtract(((VncInteger)op2).toJavaBigDecimal()));
                }
                if (Types.isVncDouble(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().subtract(((VncDouble)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().subtract(((VncBigInteger)op2).toJavaBigDecimal()));
                }
            } else if (Types.isVncBigInteger(op1)) {
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigInteger(((VncBigInteger)op1).toJavaBigInteger().subtract(((VncBigInteger)op2).toJavaBigInteger()));
                }
                if (Types.isVncLong(op2)) {
                    return new VncBigInteger(((VncBigInteger)op1).toJavaBigInteger().subtract(((VncLong)op2).toJavaBigInteger()));
                }
                if (Types.isVncInteger(op2)) {
                    return new VncBigInteger(((VncBigInteger)op1).toJavaBigInteger().subtract(((VncInteger)op2).toJavaBigInteger()));
                }
                if (Types.isVncDouble(op2)) {
                    return new VncBigDecimal(((VncBigInteger)op1).toJavaBigDecimal().subtract(((VncDouble)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncBigInteger)op1).toJavaBigDecimal().subtract(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
            } else if (Types.isVncInteger(op1)) {
                if (Types.isVncInteger(op2)) {
                    return new VncInteger(((VncInteger)op1).toJavaInteger() - ((VncInteger)op2).toJavaInteger());
                }
                if (Types.isVncLong(op2)) {
                    return new VncLong(((VncInteger)op1).toJavaLong() - ((VncLong)op2).toJavaLong());
                }
                if (Types.isVncDouble(op2)) {
                    return new VncDouble(((VncInteger)op1).toJavaDouble() - ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncInteger)op1).toJavaBigDecimal().subtract(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigInteger(((VncInteger)op1).toJavaBigInteger().subtract(((VncBigInteger)op2).toJavaBigInteger()));
                }
            }
            Numeric.validateNumericTypes("-", op1, op2);
        }
        catch (ArithmeticException ex) {
            throw new VncException(ex.getMessage());
        }
        throw new RuntimeException("Unexpected outcome");
    }

    public static VncVal mul(VncVal op1, VncVal op2) {
        try {
            if (Types.isVncLong(op1)) {
                if (Types.isVncLong(op2)) {
                    return new VncLong(((VncLong)op1).toJavaLong() * ((VncLong)op2).toJavaLong());
                }
                if (Types.isVncInteger(op2)) {
                    return new VncLong(((VncLong)op1).toJavaLong() * ((VncInteger)op2).toJavaLong());
                }
                if (Types.isVncDouble(op2)) {
                    return new VncDouble(((VncLong)op1).toJavaDouble() * ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncLong)op1).toJavaBigDecimal().multiply(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigInteger(((VncLong)op1).toJavaBigInteger().multiply(((VncBigInteger)op2).toJavaBigInteger()));
                }
            } else if (Types.isVncDouble(op1)) {
                if (Types.isVncDouble(op2)) {
                    return new VncDouble(((VncDouble)op1).toJavaDouble() * ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncLong(op2)) {
                    return new VncDouble(((VncDouble)op1).toJavaDouble() * ((VncLong)op2).toJavaDouble());
                }
                if (Types.isVncInteger(op2)) {
                    return new VncDouble(((VncDouble)op1).toJavaDouble() * ((VncInteger)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncDouble)op1).toJavaBigDecimal().multiply(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigDecimal(((VncDouble)op1).toJavaBigDecimal().multiply(((VncBigInteger)op2).toJavaBigDecimal()));
                }
            } else if (Types.isVncBigDecimal(op1)) {
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().multiply(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
                if (Types.isVncLong(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().multiply(((VncLong)op2).toJavaBigDecimal()));
                }
                if (Types.isVncInteger(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().multiply(((VncInteger)op2).toJavaBigDecimal()));
                }
                if (Types.isVncDouble(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().multiply(((VncDouble)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigDecimal(((VncBigDecimal)op1).toJavaBigDecimal().multiply(((VncBigInteger)op2).toJavaBigDecimal()));
                }
            } else if (Types.isVncBigInteger(op1)) {
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigInteger(((VncBigInteger)op1).toJavaBigInteger().multiply(((VncBigInteger)op2).toJavaBigInteger()));
                }
                if (Types.isVncLong(op2)) {
                    return new VncBigInteger(((VncBigInteger)op1).toJavaBigInteger().multiply(((VncLong)op2).toJavaBigInteger()));
                }
                if (Types.isVncInteger(op2)) {
                    return new VncBigInteger(((VncBigInteger)op1).toJavaBigInteger().multiply(((VncInteger)op2).toJavaBigInteger()));
                }
                if (Types.isVncDouble(op2)) {
                    return new VncBigDecimal(((VncBigInteger)op1).toJavaBigDecimal().multiply(((VncDouble)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncBigInteger)op1).toJavaBigDecimal().multiply(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
            } else if (Types.isVncInteger(op1)) {
                if (Types.isVncInteger(op2)) {
                    return new VncInteger(((VncInteger)op1).toJavaInteger() * ((VncInteger)op2).toJavaInteger());
                }
                if (Types.isVncLong(op2)) {
                    return new VncLong(((VncInteger)op1).toJavaLong() * ((VncLong)op2).toJavaLong());
                }
                if (Types.isVncDouble(op2)) {
                    return new VncDouble(((VncInteger)op1).toJavaDouble() * ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return new VncBigDecimal(((VncInteger)op1).toJavaBigDecimal().multiply(((VncBigDecimal)op2).toJavaBigDecimal()));
                }
                if (Types.isVncBigInteger(op2)) {
                    return new VncBigInteger(((VncInteger)op1).toJavaBigInteger().multiply(((VncBigInteger)op2).toJavaBigInteger()));
                }
            }
            Numeric.validateNumericTypes("*", op1, op2);
        }
        catch (ArithmeticException ex) {
            throw new VncException(ex.getMessage());
        }
        throw new RuntimeException("Unexpected outcome");
    }

    public static VncVal div(VncVal op1, VncVal op2) {
        try {
            if (Types.isVncLong(op1)) {
                if (Types.isVncLong(op2)) {
                    return Numeric.div(((VncLong)op1).toJavaLong(), ((VncLong)op2).toJavaLong());
                }
                if (Types.isVncInteger(op2)) {
                    return Numeric.div(((VncLong)op1).toJavaLong(), ((VncInteger)op2).toJavaLong());
                }
                if (Types.isVncDouble(op2)) {
                    return Numeric.div(((VncLong)op1).toJavaDouble(), ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return Numeric.div(((VncLong)op1).toJavaBigDecimal(), ((VncBigDecimal)op2).toJavaBigDecimal());
                }
                if (Types.isVncBigInteger(op2)) {
                    return Numeric.div(((VncLong)op1).toJavaBigInteger(), ((VncBigInteger)op2).toJavaBigInteger());
                }
            } else if (Types.isVncDouble(op1)) {
                if (Types.isVncDouble(op2)) {
                    return Numeric.div(((VncDouble)op1).toJavaDouble(), ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncLong(op2)) {
                    return Numeric.div(((VncDouble)op1).toJavaDouble(), ((VncLong)op2).toJavaDouble());
                }
                if (Types.isVncInteger(op2)) {
                    return Numeric.div(((VncDouble)op1).toJavaDouble(), ((VncInteger)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return Numeric.div(((VncDouble)op1).toJavaBigDecimal(), ((VncBigDecimal)op2).toJavaBigDecimal());
                }
                if (Types.isVncBigInteger(op2)) {
                    return Numeric.div(((VncDouble)op1).toJavaBigDecimal(), ((VncBigInteger)op2).toJavaBigDecimal());
                }
            } else if (Types.isVncBigDecimal(op1)) {
                if (Types.isVncBigDecimal(op2)) {
                    return Numeric.div(((VncBigDecimal)op1).toJavaBigDecimal(), ((VncBigDecimal)op2).toJavaBigDecimal());
                }
                if (Types.isVncLong(op2)) {
                    return Numeric.div(((VncBigDecimal)op1).toJavaBigDecimal(), ((VncLong)op2).toJavaBigDecimal());
                }
                if (Types.isVncInteger(op2)) {
                    return Numeric.div(((VncBigDecimal)op1).toJavaBigDecimal(), ((VncInteger)op2).toJavaBigDecimal());
                }
                if (Types.isVncDouble(op2)) {
                    return Numeric.div(((VncBigDecimal)op1).toJavaBigDecimal(), ((VncDouble)op2).toJavaBigDecimal());
                }
                if (Types.isVncBigInteger(op2)) {
                    return Numeric.div(((VncBigDecimal)op1).toJavaBigDecimal(), ((VncBigInteger)op2).toJavaBigDecimal());
                }
            } else if (Types.isVncBigInteger(op1)) {
                if (Types.isVncBigInteger(op2)) {
                    return Numeric.div(((VncBigInteger)op1).toJavaBigInteger(), ((VncBigInteger)op2).toJavaBigInteger());
                }
                if (Types.isVncLong(op2)) {
                    return Numeric.div(((VncBigInteger)op1).toJavaBigInteger(), ((VncLong)op2).toJavaBigInteger());
                }
                if (Types.isVncInteger(op2)) {
                    return Numeric.div(((VncBigInteger)op1).toJavaBigInteger(), ((VncInteger)op2).toJavaBigInteger());
                }
                if (Types.isVncDouble(op2)) {
                    return Numeric.div(((VncBigInteger)op1).toJavaBigDecimal(), ((VncDouble)op2).toJavaBigDecimal());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return Numeric.div(((VncBigInteger)op1).toJavaBigDecimal(), ((VncBigDecimal)op2).toJavaBigDecimal());
                }
            } else if (Types.isVncInteger(op1)) {
                if (Types.isVncInteger(op2)) {
                    return Numeric.div(((VncInteger)op1).toJavaInteger(), ((VncInteger)op2).toJavaInteger());
                }
                if (Types.isVncLong(op2)) {
                    return Numeric.div(((VncInteger)op1).toJavaLong(), ((VncLong)op2).toJavaLong());
                }
                if (Types.isVncDouble(op2)) {
                    return Numeric.div(((VncInteger)op1).toJavaDouble(), ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return Numeric.div(((VncInteger)op1).toJavaBigDecimal(), ((VncBigDecimal)op2).toJavaBigDecimal());
                }
                if (Types.isVncBigInteger(op2)) {
                    return Numeric.div(((VncInteger)op1).toJavaBigInteger(), ((VncBigInteger)op2).toJavaBigInteger());
                }
            }
            Numeric.validateNumericTypes("/", op1, op2);
        }
        catch (ArithmeticException ex) {
            throw new VncException(ex.getMessage());
        }
        throw new RuntimeException("Unexpected outcome");
    }

    public static VncBoolean equ(VncVal op1, VncVal op2) {
        try {
            if (Types.isVncLong(op1)) {
                if (Types.isVncLong(op2)) {
                    return Numeric.equ(((VncLong)op1).toJavaLong(), ((VncLong)op2).toJavaLong());
                }
                if (Types.isVncInteger(op2)) {
                    return Numeric.equ(((VncLong)op1).toJavaLong(), ((VncInteger)op2).toJavaLong());
                }
                if (Types.isVncDouble(op2)) {
                    return Numeric.equ(((VncLong)op1).toJavaDouble(), ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return Numeric.equ(((VncLong)op1).toJavaBigDecimal(), ((VncBigDecimal)op2).toJavaBigDecimal());
                }
                if (Types.isVncBigInteger(op2)) {
                    return Numeric.equ(((VncLong)op1).toJavaBigInteger(), ((VncBigInteger)op2).toJavaBigInteger());
                }
            } else if (Types.isVncDouble(op1)) {
                if (Types.isVncDouble(op2)) {
                    return Numeric.equ(((VncDouble)op1).toJavaDouble(), ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncLong(op2)) {
                    return Numeric.equ(((VncDouble)op1).toJavaDouble(), ((VncLong)op2).toJavaDouble());
                }
                if (Types.isVncInteger(op2)) {
                    return Numeric.equ(((VncDouble)op1).toJavaDouble(), ((VncInteger)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return Numeric.equ(((VncDouble)op1).toJavaBigDecimal(), ((VncBigDecimal)op2).toJavaBigDecimal());
                }
                if (Types.isVncBigInteger(op2)) {
                    return Numeric.equ(((VncDouble)op1).toJavaBigDecimal(), ((VncBigInteger)op2).toJavaBigDecimal());
                }
            } else if (Types.isVncBigDecimal(op1)) {
                if (Types.isVncBigDecimal(op2)) {
                    return Numeric.equ(((VncBigDecimal)op1).toJavaBigDecimal(), ((VncBigDecimal)op2).toJavaBigDecimal());
                }
                if (Types.isVncLong(op2)) {
                    return Numeric.equ(((VncBigDecimal)op1).toJavaBigDecimal(), ((VncLong)op2).toJavaBigDecimal());
                }
                if (Types.isVncInteger(op2)) {
                    return Numeric.equ(((VncBigDecimal)op1).toJavaBigDecimal(), ((VncInteger)op2).toJavaBigDecimal());
                }
                if (Types.isVncDouble(op2)) {
                    return Numeric.equ(((VncBigDecimal)op1).toJavaBigDecimal(), ((VncDouble)op2).toJavaBigDecimal());
                }
                if (Types.isVncBigInteger(op2)) {
                    return Numeric.equ(((VncBigDecimal)op1).toJavaBigDecimal(), ((VncBigInteger)op2).toJavaBigDecimal());
                }
            } else if (Types.isVncBigInteger(op1)) {
                if (Types.isVncBigInteger(op2)) {
                    return Numeric.equ(((VncBigInteger)op1).toJavaBigInteger(), ((VncBigInteger)op2).toJavaBigInteger());
                }
                if (Types.isVncLong(op2)) {
                    return Numeric.equ(((VncBigInteger)op1).toJavaBigInteger(), ((VncLong)op2).toJavaBigInteger());
                }
                if (Types.isVncInteger(op2)) {
                    return Numeric.equ(((VncBigInteger)op1).toJavaBigInteger(), ((VncInteger)op2).toJavaBigInteger());
                }
                if (Types.isVncDouble(op2)) {
                    return Numeric.equ(((VncBigInteger)op1).toJavaBigDecimal(), ((VncDouble)op2).toJavaBigDecimal());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return Numeric.equ(((VncBigInteger)op1).toJavaBigDecimal(), ((VncBigDecimal)op2).toJavaBigDecimal());
                }
            } else if (Types.isVncInteger(op1)) {
                if (Types.isVncInteger(op2)) {
                    return Numeric.equ(((VncInteger)op1).toJavaInteger(), ((VncInteger)op2).toJavaInteger());
                }
                if (Types.isVncLong(op2)) {
                    return Numeric.equ(((VncInteger)op1).toJavaLong(), ((VncLong)op2).toJavaLong());
                }
                if (Types.isVncDouble(op2)) {
                    return Numeric.equ(((VncInteger)op1).toJavaDouble(), ((VncDouble)op2).toJavaDouble());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return Numeric.equ(((VncInteger)op1).toJavaBigDecimal(), ((VncBigDecimal)op2).toJavaBigDecimal());
                }
                if (Types.isVncBigInteger(op2)) {
                    return Numeric.equ(((VncInteger)op1).toJavaBigInteger(), ((VncBigInteger)op2).toJavaBigInteger());
                }
            }
            Numeric.validateNumericTypes("==", op1, op2);
        }
        catch (ArithmeticException ex) {
            throw new VncException(ex.getMessage());
        }
        throw new RuntimeException("Unexpected outcome");
    }

    public static VncVal square(VncVal val) {
        return Numeric.mul(val, val);
    }

    public static VncVal sqrt(VncVal val) {
        if (Types.isVncLong(val)) {
            return new VncDouble(Math.sqrt(((VncLong)val).toJavaDouble()));
        }
        if (Types.isVncInteger(val)) {
            return new VncDouble(Math.sqrt(((VncInteger)val).toJavaDouble()));
        }
        if (Types.isVncDouble(val)) {
            return new VncDouble(Math.sqrt(((VncDouble)val).toJavaDouble()));
        }
        if (Types.isVncBigDecimal(val)) {
            return new VncBigDecimal(new BigDecimal(Math.sqrt(Coerce.toVncBigDecimal(val).toJavaDouble())));
        }
        if (Types.isVncBigInteger(val)) {
            return new VncBigDecimal(new BigDecimal(Math.sqrt(Coerce.toVncBigInteger(val).toJavaDouble())));
        }
        throw new VncException(String.format("Invalid argument type %s while calling function 'sqrt'", Types.getType(val)));
    }

    private static VncVal div(Integer op1, Integer op2) {
        return new VncInteger(op1 / op2);
    }

    private static VncVal div(Long op1, Long op2) {
        return new VncLong(op1 / op2);
    }

    private static VncVal div(Double op1, Double op2) {
        return new VncDouble(op1 / op2);
    }

    private static VncVal div(BigDecimal op1, BigDecimal op2) {
        return new VncBigDecimal(op1.divide(op2, 16, RoundingMode.HALF_UP));
    }

    private static VncVal div(BigInteger op1, BigInteger op2) {
        return new VncBigInteger(op1.divide(op2));
    }

    private static VncBoolean equ(Integer op1, Integer op2) {
        return VncBoolean.of(op1.equals(op2));
    }

    private static VncBoolean equ(Long op1, Long op2) {
        return VncBoolean.of(op1.equals(op2));
    }

    private static VncBoolean equ(Double op1, Double op2) {
        return VncBoolean.of(op1.equals(op2));
    }

    private static VncBoolean equ(BigDecimal op1, BigDecimal op2) {
        return VncBoolean.of(op1.compareTo(op2) == 0);
    }

    private static VncBoolean equ(BigInteger op1, BigInteger op2) {
        return VncBoolean.of(op1.compareTo(op2) == 0);
    }

    private static void validateNumericTypes(String op, VncVal op1, VncVal op2) {
        if (!Types.isVncNumber(op1)) {
            throw new VncException(String.format("Function '%s' operand 1 (%s) is not a numeric type", op, Types.getType(op1)));
        }
        if (!Types.isVncNumber(op2)) {
            throw new VncException(String.format("Function '%s' operand 2 (%s) is not a numeric type", op, Types.getType(op2)));
        }
    }
}

