/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexFunctions {
    public static VncFunction pattern = new VncFunction("regex/pattern", (VncVal)VncFunction.meta().arglists("(regex/pattern s)").doc("Returns an instance of java.util.regex.Pattern.").examples("(regex/pattern \"[0-9]+\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return new VncJavaObject(Pattern.compile(Coerce.toVncString(args.first()).getValue()));
        }
    };
    public static VncFunction matcher = new VncFunction("regex/matcher", (VncVal)VncFunction.meta().arglists("(regex/matcher pattern str)").doc("Returns an instance of java.util.regex.Matcher. The pattern can be either a string or a pattern created by (regex/pattern s)").examples("(regex/matcher \"[0-9]+\" \"100\")", "(let [p (regex/pattern \"[0-9]+\")] \n   (regex/matcher p \"100\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal pattern = args.first();
            Pattern p = Types.isVncString(pattern) ? Pattern.compile(((VncString)pattern).getValue()) : (Pattern)Coerce.toVncJavaObject(args.first()).getDelegate();
            String s = Coerce.toVncString(args.second()).getValue();
            return new VncJavaObject(p.matcher(s));
        }
    };
    public static VncFunction find_Q = new VncFunction("regex/find?", (VncVal)VncFunction.meta().arglists("(regex/find? matcher)").doc("Attempts to find the next subsequence that matches the pattern. If the match succeeds then more information can be obtained via the regex/group function").examples("(let [p (regex/pattern \"[0-9]+\")  \n      m (regex/matcher p \"100\")]  \n   (regex/find? m))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            return VncBoolean.of(m.find());
        }
    };
    public static VncFunction matches = new VncFunction("regex/matches", (VncVal)VncFunction.meta().arglists("(regex/matches pattern str)").doc("Returns the match, if any, of string to pattern, using java.util.regex.Matcher.matches(). Returns a list with the groups. \n\nReturns matching details as meta data and groups list and items: \nGroup: \n   :start       start pos of the group\n   :end         end pos of the group\n   :group-count the number of elements in the group\nGroup element: \n   :start       start pos of the element\n   :end         end pos of the element\n").examples("(regex/matches \"hello, (.*)\" \"hello, world\")", "(regex/matches \"([0-9]+)-([0-9]+)-([0-9]+)-([0-9]+)\" \"672-345-456-212\")", "(let [p (regex/pattern \"([0-9]+)-([0-9]+)\")]\n  (regex/matches p \"672-345\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal pattern = args.first();
            Pattern p = Types.isVncString(pattern) ? Pattern.compile(((VncString)pattern).getValue()) : (Pattern)Coerce.toVncJavaObject(args.first()).getDelegate();
            String s = Coerce.toVncString(args.second()).getValue();
            Matcher m = p.matcher(s);
            if (m.matches()) {
                ArrayList<VncConstant> groups = new ArrayList<VncConstant>();
                VncHashMap metaGroup = VncHashMap.of(new VncKeyword("start"), new VncLong(m.start()), new VncKeyword("end"), new VncLong(m.end()), new VncKeyword("group-count"), new VncLong(m.groupCount()));
                for (int ii = 0; ii <= m.groupCount(); ++ii) {
                    VncHashMap metaItem = VncHashMap.of(new VncKeyword("start"), new VncLong(m.start(ii)), new VncKeyword("end"), new VncLong(m.end(ii)));
                    String group = m.group(ii);
                    groups.add((VncConstant)(group == null ? Constants.Nil : new VncString(group, (VncVal)metaItem)));
                }
                return VncList.ofList(groups, metaGroup);
            }
            return VncList.empty();
        }
    };
    public static VncFunction matches_Q = new VncFunction("regex/matches?", (VncVal)VncFunction.meta().arglists("(regex/matches? matcher)").doc("Attempts to match the entire region against the pattern. If the match succeeds then more information can be obtained via the regex/group function").examples("(let [p (regex/pattern \"[0-9]+\")  \n      m (regex/matcher p \"100\")]  \n   (regex/matches? m))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            return VncBoolean.of(m.matches());
        }
    };
    public static VncFunction find = new VncFunction("regex/find", (VncVal)VncFunction.meta().arglists("(regex/find matcher)").doc("Returns the next regex match").examples("(let [m (regex/matcher \"[0-9]+\" \"672-345-456-3212\")]  \n   (println (regex/find m))                               \n   (println (regex/find m))                               \n   (println (regex/find m))                               \n   (println (regex/find m))                               \n   (println (regex/find m)))                              \n").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            if (m.find()) {
                return new VncString(m.group());
            }
            return Constants.Nil;
        }
    };
    public static VncFunction find_all = new VncFunction("regex/find-all", (VncVal)VncFunction.meta().arglists("(regex/find-all matcher)").doc("Returns all regex matches").examples("(->> (regex/matcher \"\\\\d+\" \"672-345-456-3212\") \n     (regex/find-all))                                 ", "(->> (regex/matcher \"([^\\\"]\\\\S*|\\\".+?\\\")\\\\s*\" \"1 2 \\\"3 4\\\" 5\") \n     (regex/find-all))                                 ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            ArrayList<VncString> matches = new ArrayList<VncString>();
            while (m.find()) {
                matches.add(new VncString(m.group()));
            }
            return VncList.ofList(matches);
        }
    };
    public static VncFunction find_group = new VncFunction("regex/find-group", (VncVal)VncFunction.meta().arglists("(regex/find-group matcher)").doc("Returns the next regex match and returns the group").examples("(let [m (regex/matcher \"[0-9]+\" \"672-345-456-3212\")]  \n   (println (regex/find-group m))                         \n   (println (regex/find-group m))                         \n   (println (regex/find-group m))                         \n   (println (regex/find-group m))                         \n   (println (regex/find-group m)))                        \n").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            if (m.find()) {
                return VncHashMap.of(new VncKeyword("start"), new VncLong(m.start()), new VncKeyword("end"), new VncLong(m.end()), new VncKeyword("group"), new VncString(m.group()));
            }
            return Constants.Nil;
        }
    };
    public static VncFunction find_all_groups = new VncFunction("regex/find-all-groups", (VncVal)VncFunction.meta().arglists("(regex/find-all-groups matcher)").doc("Returns the all regex matches and returns the groups").examples("(let [m (regex/matcher \"[0-9]+\" \"672-345-456-3212\")]  \n  (regex/find-all-groups m))                              \n").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            ArrayList<VncHashMap> groups = new ArrayList<VncHashMap>();
            while (m.find()) {
                groups.add(VncHashMap.of(new VncKeyword("start"), new VncLong(m.start()), new VncKeyword("end"), new VncLong(m.end()), new VncKeyword("group"), new VncString(m.group())));
            }
            return VncList.ofList(groups);
        }
    };
    public static VncFunction reset = new VncFunction("regex/reset", (VncVal)VncFunction.meta().arglists("(regex/reset matcher str)").doc("Resets the matcher with a new string").examples("(let [p (regex/pattern \"[0-9]+\")  \n      m1 (regex/matcher p \"100\")  \n      m2 (regex/reset m1 \"200\")]  \n   (regex/find? m2))                  ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            String s = Coerce.toVncString(args.second()).getValue();
            return new VncJavaObject(m.reset(s));
        }
    };
    public static VncFunction group = new VncFunction("regex/group", (VncVal)VncFunction.meta().arglists("(regex/group matcher group)").doc("Returns the input subsequence captured by the given group during theprevious match operation.").examples("(let [p (regex/pattern \"([0-9]+)(.*)\")      \n      m (regex/matcher p \"100abc\")]         \n   (if (regex/matches? m)                     \n      [(regex/group m 1) (regex/group m 2)]   \n      []))                                      ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            int g = Coerce.toVncLong(args.second()).getValue().intValue();
            if (g >= 0 && g <= m.groupCount()) {
                String group = m.group(g);
                return group == null ? Constants.Nil : new VncString(group);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction groupcount = new VncFunction("regex/groupcount", (VncVal)VncFunction.meta().arglists("(regex/groupcount matcher)").doc("Returns the matcher's group count.").examples("(let [p (regex/pattern \"([0-9]+)(.*)\")  \n      m (regex/matcher p \"100abc\")]     \n   (regex/groupcount m))                    ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            return new VncLong(m.groupCount());
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(pattern).add(matcher).add(find).add(find_all).add(find_group).add(find_all_groups).add(reset).add(find_Q).add(matches).add(matches_Q).add(group).add(groupcount).toMap();
}

