/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.reader;

import com.github.jlangch.venice.impl.reader.ReaderPos;
import com.github.jlangch.venice.impl.reader.TokenType;

public class Token {
    private final TokenType type;
    private final String token;
    private final String file;
    private final int filePos;
    private final int line;
    private final int col;

    public Token(TokenType type, String token, String file, ReaderPos pos) {
        this.type = type;
        this.token = token;
        this.file = file == null || file.isEmpty() ? "unknown" : file;
        this.filePos = pos.getFilePos();
        this.line = pos.getLineNr();
        this.col = pos.getColumnNr();
    }

    public TokenType getType() {
        return this.type;
    }

    public String getToken() {
        return this.token;
    }

    public String getFile() {
        return this.file;
    }

    public int getFileStartPos() {
        return this.filePos;
    }

    public int getFileEndPos() {
        return this.filePos + this.token.length() - 1;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.col;
    }

    public char charAt(int index) {
        return this.token.charAt(index);
    }

    public boolean equals(String str) {
        return this.token.equals(str);
    }

    public boolean isWhitespaces() {
        return this.type == TokenType.WHITESPACES;
    }

    public boolean isComment() {
        return this.type == TokenType.COMMENT;
    }

    public boolean isWhitespacesOrComment() {
        return this.isWhitespaces() || this.isComment();
    }

    public boolean isString() {
        return this.type == TokenType.STRING;
    }

    public boolean isStringBlock() {
        return this.type == TokenType.STRING_BLOCK;
    }

    public String toString() {
        return String.format("%s (file: %s, line %d, column %d)", this.token, this.file, this.line, this.col);
    }
}

