/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Modules;
import com.github.jlangch.venice.impl.ansi.AnsiColorTheme;
import com.github.jlangch.venice.impl.ansi.AnsiColorThemes;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.reader.HighlightItem;
import com.github.jlangch.venice.impl.reader.HighlightParser;
import com.github.jlangch.venice.impl.specialforms.SpecialFormsDoc;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.custom.VncChoiceTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncCustomTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.Doc;
import java.util.List;
import java.util.stream.Collectors;

public class DocForm {
    public static VncString doc(VncVal ref, Env env) {
        if (Types.isVncSymbol(ref)) {
            return DocForm.docForSymbol((VncSymbol)ref, env);
        }
        if (Types.isVncKeyword(ref)) {
            return DocForm.docForKeyword((VncKeyword)ref, env);
        }
        if (Types.isVncString(ref)) {
            return DocForm.docForSymbol(((VncString)ref).toSymbol(), env);
        }
        VncString name = (VncString)CoreFunctions.name.apply(VncList.of(ref));
        return DocForm.docForSymbol(name.toSymbol(), env);
    }

    public static VncString highlight(VncString form, Env env) {
        AnsiColorTheme theme = AnsiColorThemes.getTheme(DocForm.getColorTheme(env));
        if (theme == null) {
            return form;
        }
        List<HighlightItem> items = HighlightParser.parse(form.getValue());
        return new VncString(AnsiColorTheme.ANSI_RESET + items.stream().map(it -> theme.style(it.getForm(), it.getClazz())).collect(Collectors.joining()));
    }

    private static VncString docForSymbol(VncSymbol sym, Env env) {
        VncVal docVal = SpecialFormsDoc.ns.get(sym);
        if (docVal != null) {
            return Doc.getDoc(docVal);
        }
        try {
            docVal = env.get(sym);
            return Doc.getDoc(docVal);
        }
        catch (VncException ex) {
            String simpleName = sym.getSimpleName();
            List candidates = env.getAllGlobalFunctionSymbols().stream().filter(s -> s.getSimpleName().equals(simpleName)).limit(5L).map(s -> "   " + s.getQualifiedName()).collect(Collectors.toList());
            if (candidates.isEmpty()) {
                throw ex;
            }
            return new VncString(String.format("Symbol '%s' not found.\n\n", sym.getQualifiedName()) + "Did you mean?\n" + String.join((CharSequence)"\n", candidates) + "\n");
        }
    }

    private static VncString docForKeyword(VncKeyword keyword, Env env) {
        if (Modules.isValidModule(keyword)) {
            return DocForm.docForModule(keyword, env);
        }
        return DocForm.docForCustomType(keyword, env);
    }

    private static VncString docForModule(VncKeyword module, Env env) {
        String form = ModuleLoader.loadModule(module.getValue());
        AnsiColorTheme theme = AnsiColorThemes.getTheme(DocForm.getColorTheme(env));
        if (theme == null) {
            return new VncString(form);
        }
        List<HighlightItem> items = HighlightParser.parse("(do " + form + ")");
        return new VncString(AnsiColorTheme.ANSI_RESET + items.subList(3, items.size() - 1).stream().map(it -> theme.style(it.getForm(), it.getClazz())).collect(Collectors.joining()));
    }

    private static VncString docForCustomType(VncKeyword type, Env env) {
        VncVal tdef = env.getGlobalOrNull(type.toSymbol());
        if (tdef == null) {
            if (type.hasNamespace()) {
                throw new VncException(String.format(":%s is not a custom type. No documentation available!", type.getValue()));
            }
            throw new VncException(String.format(":%s is not a custom type. Please qualify the type with its namespace!", type.getValue()));
        }
        if (tdef instanceof VncCustomTypeDef) {
            VncCustomTypeDef typeDef = (VncCustomTypeDef)tdef;
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Custom type :%s\n", type.getValue()));
            sb.append("Fields: \n");
            typeDef.getFieldDefs().forEach(f -> sb.append(String.format("   %s :%s\n", f.getName().getValue(), f.getType().getValue())));
            if (typeDef.getValidationFn() != null) {
                sb.append(String.format("Validation function: :%s\n", typeDef.getValidationFn().getQualifiedName()));
            }
            return new VncString(sb.toString());
        }
        if (tdef instanceof VncWrappingTypeDef) {
            VncWrappingTypeDef typeDef = (VncWrappingTypeDef)tdef;
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Custom wrapped type :%s\n", type.getValue()));
            sb.append(String.format("Base type :%s\n", typeDef.getBaseType().getValue()));
            if (typeDef.getValidationFn() != null) {
                sb.append(String.format("Validation function: :%s\n", typeDef.getValidationFn().getQualifiedName()));
            }
            return new VncString(sb.toString());
        }
        if (tdef instanceof VncChoiceTypeDef) {
            VncChoiceTypeDef typeDef = (VncChoiceTypeDef)tdef;
            VncSet types = typeDef.typesOnly();
            VncSet values = typeDef.valuesOnly();
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Custom choice type :%s\n", type.getValue()));
            if (!types.isEmpty()) {
                sb.append("Types: \n");
                typeDef.typesOnly().forEach(v -> sb.append(String.format("   %s\n", v.toString())));
            }
            if (!values.isEmpty()) {
                sb.append("Values: \n");
                typeDef.valuesOnly().forEach(v -> sb.append(String.format("   %s\n", v.toString())));
            }
            return new VncString(sb.toString());
        }
        throw new VncException(String.format(":%s is not a custom type. Please qualify the type with its namespace!", type.getValue()));
    }

    private static String getColorTheme(Env env) {
        VncVal theme;
        String sRunMode;
        VncVal runMode = env.get(new VncSymbol("*run-mode*"));
        if (Types.isVncKeyword(runMode) && "repl".equals(sRunMode = ((VncKeyword)runMode).getValue()) && Types.isVncKeyword(theme = env.get(new VncSymbol("*repl-color-theme*")))) {
            String sTheme = ((VncKeyword)theme).getValue();
            return "none".equals(sTheme) ? null : sTheme;
        }
        return null;
    }
}

