/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBigInteger;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncNumber;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;

public class VncBigDecimal
extends VncNumber {
    public static final VncKeyword TYPE = new VncKeyword(":core/decimal");
    private static final long serialVersionUID = -1848883965231344442L;
    private final BigDecimal value;

    public VncBigDecimal(BigDecimal v) {
        this(v, null, Constants.Nil);
    }

    public VncBigDecimal(double v) {
        this(BigDecimal.valueOf(v), null, Constants.Nil);
    }

    public VncBigDecimal(long v) {
        this(BigDecimal.valueOf(v), null, Constants.Nil);
    }

    public VncBigDecimal(BigDecimal v, VncVal meta) {
        this(v, null, meta);
    }

    public VncBigDecimal(BigDecimal v, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = v;
    }

    public static VncBigDecimal of(VncVal v) {
        if (Types.isVncNumber(v)) {
            return new VncBigDecimal(((VncNumber)v).toJavaBigDecimal());
        }
        throw new VncException(String.format("Cannot convert value of type %s to decimal", Types.getType(v)));
    }

    @Override
    public VncBigDecimal withMeta(VncVal meta) {
        return new VncBigDecimal(this.value, this.getWrappingTypeDef(), meta);
    }

    @Override
    public VncBigDecimal wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncBigDecimal(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? this.getWrappingTypeDef().getType() : TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return this.isWrapped() ? TYPE : VncVal.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return this.isWrapped() ? Arrays.asList(TYPE, VncVal.TYPE) : Arrays.asList(VncVal.TYPE);
    }

    public VncBigDecimal negate() {
        return new VncBigDecimal(this.value.negate());
    }

    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.BIGDECIMAL;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public Integer toJavaInteger() {
        return this.value.intValue();
    }

    @Override
    public Long toJavaLong() {
        return this.value.longValue();
    }

    @Override
    public Double toJavaDouble() {
        return this.value.doubleValue();
    }

    @Override
    public BigInteger toJavaBigInteger() {
        return this.value.toBigInteger();
    }

    @Override
    public BigDecimal toJavaBigDecimal() {
        return this.value;
    }

    @Override
    public BigDecimal toJavaBigDecimal(int scale) {
        return this.value.setScale(scale);
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncBigDecimal(o)) {
            return this.value.compareTo(((VncBigDecimal)o).getValue());
        }
        if (Types.isVncInteger(o)) {
            return this.value.compareTo(((VncInteger)o).toJavaBigDecimal());
        }
        if (Types.isVncDouble(o)) {
            return this.value.compareTo(((VncDouble)o).toJavaBigDecimal());
        }
        if (Types.isVncLong(o)) {
            return this.value.compareTo(((VncLong)o).toJavaBigDecimal());
        }
        if (Types.isVncBigInteger(o)) {
            return this.value.compareTo(((VncBigInteger)o).toJavaBigDecimal());
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((VncBigDecimal)obj).value);
    }

    public String toString() {
        return this.value.toString() + "M";
    }

    public static RoundingMode toRoundingMode(VncString val) {
        return RoundingMode.valueOf(RoundingMode.class, val.getValue());
    }
}

