/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBigInteger;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncNumber;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class VncLong
extends VncNumber {
    public static final VncKeyword TYPE = new VncKeyword(":core/long");
    private static final long serialVersionUID = -1848883965231344442L;
    private final Long value;

    public VncLong(Long v) {
        super(null, Constants.Nil);
        this.value = v;
    }

    public VncLong(Integer v) {
        super(null, Constants.Nil);
        this.value = v.longValue();
    }

    public VncLong(Long v, VncVal meta) {
        super(null, meta);
        this.value = v;
    }

    public VncLong(Long v, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = v;
    }

    public static VncLong of(VncVal v) {
        if (Types.isVncNumber(v)) {
            return new VncLong(((VncNumber)v).toJavaLong());
        }
        throw new VncException(String.format("Cannot convert value of type %s to long", Types.getType(v)));
    }

    @Override
    public VncLong withMeta(VncVal meta) {
        return new VncLong(this.value, this.getWrappingTypeDef(), meta);
    }

    @Override
    public VncLong wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncLong(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? this.getWrappingTypeDef().getType() : TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return this.isWrapped() ? TYPE : VncVal.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return this.isWrapped() ? Arrays.asList(TYPE, VncVal.TYPE) : Arrays.asList(VncVal.TYPE);
    }

    public VncLong negate() {
        return new VncLong(this.value * -1L);
    }

    public Long getValue() {
        return this.value;
    }

    public Integer getIntValue() {
        return this.value.intValue();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.LONG;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public Integer toJavaInteger() {
        return this.value.intValue();
    }

    @Override
    public Long toJavaLong() {
        return this.value;
    }

    @Override
    public Double toJavaDouble() {
        return this.value.doubleValue();
    }

    @Override
    public BigInteger toJavaBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public BigDecimal toJavaBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public BigDecimal toJavaBigDecimal(int scale) {
        return new BigDecimal(this.value).setScale(scale);
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncLong(o)) {
            return this.value.compareTo(((VncLong)o).getValue());
        }
        if (Types.isVncInteger(o)) {
            return this.value.compareTo(((VncInteger)o).getLongValue());
        }
        if (Types.isVncDouble(o)) {
            return this.value.compareTo(((VncDouble)o).getValue().longValue());
        }
        if (Types.isVncBigDecimal(o)) {
            return this.value.compareTo(((VncBigDecimal)o).toJavaLong());
        }
        if (Types.isVncBigInteger(o)) {
            return this.value.compareTo(((VncBigInteger)o).toJavaLong());
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((VncLong)obj).value);
    }

    public String toString() {
        return this.value.toString();
    }
}

