/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VncString
extends VncVal {
    public static final VncString EMPTY = new VncString("");
    public static final VncKeyword TYPE = new VncKeyword(":core/string");
    private static final long serialVersionUID = -1848883965231344442L;
    private final String value;

    public VncString(String v) {
        super(null, Constants.Nil);
        this.value = v == null ? "" : v;
    }

    public VncString(String v, VncVal meta) {
        super(null, meta);
        this.value = v == null ? "" : v;
    }

    public VncString(String v, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = v == null ? "" : v;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public VncString withMeta(VncVal meta) {
        return new VncString(this.value, this.getWrappingTypeDef(), meta);
    }

    @Override
    public VncString wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncString(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? this.getWrappingTypeDef().getType() : TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return this.isWrapped() ? TYPE : VncVal.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return this.isWrapped() ? Arrays.asList(TYPE, VncVal.TYPE) : Arrays.asList(VncVal.TYPE);
    }

    public int size() {
        return this.value.length();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.value.length()) {
            throw new VncException(String.format("nth: index %d out of range for a string of length %d", idx, this.value.length()));
        }
        return new VncString(String.valueOf(this.value.charAt(idx)));
    }

    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        return idx < 0 || idx >= this.value.length() ? defaultVal : this.nth(idx);
    }

    public VncVal first() {
        return this.isEmpty() ? Constants.Nil : this.nth(0);
    }

    public VncVal second() {
        return this.size() < 2 ? Constants.Nil : this.nth(1);
    }

    public VncVal last() {
        return this.isEmpty() ? Constants.Nil : this.nth(this.value.length() - 1);
    }

    public VncList toVncList() {
        ArrayList<VncString> list = new ArrayList<VncString>();
        for (char c : this.value.toCharArray()) {
            list.add(new VncString(String.valueOf(c)));
        }
        return VncList.ofList(list);
    }

    public VncList toVncCharList() {
        ArrayList<VncChar> list = new ArrayList<VncChar>();
        for (char c : this.value.toCharArray()) {
            list.add(new VncChar(c));
        }
        return VncList.ofList(list);
    }

    public VncSymbol toSymbol() {
        return new VncSymbol(this.getValue());
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.STRING;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncString(o)) {
            return this.getValue().compareTo(((VncString)o).getValue());
        }
        if (Types.isVncChar(o)) {
            return this.getValue().compareTo(((VncChar)o).getValue().toString());
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((VncString)obj).value);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public String toString(boolean print_readably) {
        if (print_readably) {
            return "\"" + StringUtil.escape(this.value) + "\"";
        }
        return this.value;
    }

    public static VncString empty() {
        return EMPTY;
    }
}

