/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.EmptyIterator;
import com.github.jlangch.venice.impl.util.StreamUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VncJavaList
extends VncSequence
implements IVncJavaObject {
    private static final long serialVersionUID = -1848883965231344442L;
    private final List<Object> value;

    public VncJavaList() {
        this((List<Object>)null, (VncVal)null);
    }

    public VncJavaList(VncVal meta) {
        this((List<Object>)null, meta);
    }

    public VncJavaList(List<Object> val) {
        this(val, null);
    }

    private VncJavaList(List<Object> val, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = val;
    }

    public static VncJavaList of(Object ... vals) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : vals) {
            list.add(o);
        }
        return new VncJavaList(list, (VncVal)Constants.Nil);
    }

    public static VncJavaList ofAll(Iterable<Object> iter) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : iter) {
            list.add(o);
        }
        return new VncJavaList(list, null);
    }

    public static VncJavaList ofAll(Iterable<Object> iter, VncVal meta) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : iter) {
            list.add(o);
        }
        return new VncJavaList(list, meta);
    }

    @Override
    public Object getDelegate() {
        return this.value;
    }

    @Override
    public VncList emptyWithMeta() {
        return new VncList(this.getMeta());
    }

    @Override
    public VncList withVariadicValues(VncVal ... replaceVals) {
        return VncList.of(replaceVals).withMeta(this.getMeta());
    }

    @Override
    public VncList withValues(List<? extends VncVal> vals) {
        return VncList.ofAll(this.stream(), this.getMeta());
    }

    @Override
    public VncList withValues(List<? extends VncVal> vals, VncVal meta) {
        return VncList.ofAll(this.stream(), meta);
    }

    @Override
    public VncJavaList withMeta(VncVal meta) {
        return new VncJavaList(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(this.value.getClass().getName());
    }

    @Override
    public VncKeyword getSupertype() {
        return new VncKeyword(this.value.getClass().getSuperclass().getName());
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(this.getSupertype());
    }

    @Override
    public Iterator<VncVal> iterator() {
        return this.isEmpty() ? EmptyIterator.empty() : new MappingIterator(this.value.iterator());
    }

    @Override
    public Stream<VncVal> stream() {
        return StreamUtil.stream(this.iterator());
    }

    @Override
    public void forEach(Consumer<? super VncVal> action) {
        this.value.forEach((? super T v) -> action.accept(JavaInteropUtil.convertToVncVal(v)));
    }

    @Override
    public VncJavaList filter(Predicate<? super VncVal> predicate) {
        return new VncJavaList(this.stream().filter((? super T v) -> predicate.test((VncVal)v)).collect(Collectors.toList()), this.getMeta());
    }

    @Override
    public VncJavaList map(Function<? super VncVal, ? extends VncVal> mapper) {
        return new VncJavaList(this.stream().map((? super T v) -> ((VncVal)mapper.apply((VncVal)v)).convertToJavaObject()).collect(Collectors.toList()), this.getMeta());
    }

    @Override
    public List<VncVal> getJavaList() {
        return this.stream().collect(Collectors.toList());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.value.size()) {
            throw new VncException("nth: index out of range");
        }
        return JavaInteropUtil.convertToVncVal(this.value.get(idx));
    }

    @Override
    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        return idx >= 0 && idx < this.value.size() ? this.nth(idx) : defaultVal;
    }

    @Override
    public VncVal last() {
        return this.nthOrDefault(this.value.size() - 1, Constants.Nil);
    }

    @Override
    public VncList rest() {
        return this.value.size() <= 1 ? VncList.empty() : this.slice(1);
    }

    @Override
    public VncList butlast() {
        return this.value.size() <= 1 ? VncList.empty() : this.slice(0, this.value.size() - 1);
    }

    @Override
    public VncList drop(int n) {
        return this.slice(n);
    }

    @Override
    public VncList dropWhile(Predicate<? super VncVal> predicate) {
        for (int i = 0; i < this.value.size(); ++i) {
            boolean drop = predicate.test(JavaInteropUtil.convertToVncVal(this.value.get(i)));
            if (drop) continue;
            return this.slice(i);
        }
        return VncList.empty();
    }

    @Override
    public VncList take(int n) {
        return this.slice(0, n);
    }

    @Override
    public VncList takeWhile(Predicate<? super VncVal> predicate) {
        for (int i = 0; i < this.value.size(); ++i) {
            boolean take = predicate.test(JavaInteropUtil.convertToVncVal(this.value.get(i)));
            if (take) continue;
            return this.slice(0, i);
        }
        return this.toVncList();
    }

    @Override
    public VncJavaList reverse() {
        ArrayList<Object> seq = new ArrayList<Object>(this.value);
        Collections.reverse(seq);
        return new VncJavaList(seq, this.getMeta());
    }

    @Override
    public VncJavaList shuffle() {
        ArrayList<Object> seq = new ArrayList<Object>(this.value);
        Collections.shuffle(seq);
        return new VncJavaList(seq, this.getMeta());
    }

    @Override
    public VncList slice(int start, int end) {
        if (start >= this.value.size()) {
            return VncList.empty();
        }
        return VncList.ofList(this.value.subList(start, Math.min(end, this.value.size())).stream().map((? super T v) -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList()));
    }

    @Override
    public VncList slice(int start) {
        return this.slice(start, this.value.size());
    }

    @Override
    public VncJavaList setAt(int idx, VncVal val) {
        this.value.set(idx, val.convertToJavaObject());
        return this;
    }

    @Override
    public VncJavaList removeAt(int idx) {
        this.value.remove(idx);
        return this;
    }

    @Override
    public VncList toVncList() {
        return VncList.ofAll(this.stream(), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return VncVector.ofAll(this.stream(), this.getMeta());
    }

    @Override
    public VncJavaList addAtStart(VncVal val) {
        this.value.add(0, val.convertToJavaObject());
        return this;
    }

    @Override
    public VncJavaList addAllAtStart(VncSequence list, boolean reverseAdd) {
        List items = list.stream().map((? super T v) -> v.convertToJavaObject()).collect(Collectors.toList());
        if (reverseAdd) {
            Collections.reverse(items);
        }
        this.value.addAll(0, items);
        return this;
    }

    @Override
    public VncJavaList addAtEnd(VncVal val) {
        this.value.add(val.convertToJavaObject());
        return this;
    }

    @Override
    public VncJavaList addAllAtEnd(VncSequence list) {
        for (VncVal v : list) {
            this.value.add(v.convertToJavaObject());
        }
        return this;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.JAVALIST;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncJavaList(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncJavaList)o).size()));
            if (c != 0) {
                return c;
            }
            for (int ii = 0; ii < sizeThis; ++ii) {
                c = this.nth(ii).compareTo(((VncJavaList)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncJavaList other = (VncJavaList)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return "(" + Printer.join(this.stream(), " ", true) + ")";
    }

    @Override
    public String toString(boolean print_readably) {
        return "(" + Printer.join(this.stream(), " ", print_readably) + ")";
    }

    private static class MappingIterator
    implements Iterator<VncVal> {
        private final Iterator<Object> iter;

        public MappingIterator(Iterator<Object> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public VncVal next() {
            return JavaInteropUtil.convertToVncVal(this.iter.next());
        }

        public String toString() {
            return "MappingIterator()";
        }
    }
}

