/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.repackage.io.vavr.collection.LinkedHashMap;
import org.repackage.io.vavr.collection.Map;

public class VncOrderedMap
extends VncMap {
    public static final VncKeyword TYPE = new VncKeyword(":core/ordered-map");
    private static final long serialVersionUID = -1848883965231344442L;
    private final LinkedHashMap<VncVal, VncVal> value;

    public VncOrderedMap() {
        this((Map<VncVal, VncVal>)null, null);
    }

    public VncOrderedMap(VncVal meta) {
        this((Map<VncVal, VncVal>)null, meta);
    }

    public VncOrderedMap(java.util.Map<? extends VncVal, ? extends VncVal> vals) {
        this(vals, null);
    }

    public VncOrderedMap(java.util.Map<? extends VncVal, ? extends VncVal> vals, VncVal meta) {
        this(vals == null ? null : LinkedHashMap.ofAll(vals), meta);
    }

    public VncOrderedMap(Map<VncVal, VncVal> val, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = val == null ? LinkedHashMap.empty() : (val instanceof LinkedHashMap ? (LinkedHashMap)val : LinkedHashMap.ofEntries(val));
    }

    public static VncOrderedMap ofAll(VncSequence lst) {
        if (lst != null && lst.size() % 2 != 0) {
            throw new VncException(String.format("ordered-map: create requires an even number of list items. Got %d items. %s", lst.size(), ErrorMessage.buildErrLocation(lst)));
        }
        return new VncOrderedMap().assoc(lst);
    }

    public static VncOrderedMap ofAll(VncVector vec) {
        if (vec != null && vec.size() % 2 != 0) {
            throw new VncException(String.format("ordered-map: create requires an even number of vector items. Got %d items. %s", vec.size(), ErrorMessage.buildErrLocation(vec)));
        }
        return new VncOrderedMap().assoc(vec);
    }

    public static VncOrderedMap of(VncVal ... mvs) {
        if (mvs != null && mvs.length % 2 != 0) {
            throw new VncException(String.format("ordered-map: create requires an even number of items. Got %d items. %s", mvs.length, ErrorMessage.buildErrLocation(mvs[0])));
        }
        return new VncOrderedMap().assoc(mvs);
    }

    @Override
    public VncOrderedMap emptyWithMeta() {
        return new VncOrderedMap(this.getMeta());
    }

    @Override
    public VncOrderedMap withValues(java.util.Map<VncVal, VncVal> replaceVals) {
        return new VncOrderedMap(replaceVals, this.getMeta());
    }

    @Override
    public VncOrderedMap withValues(java.util.Map<VncVal, VncVal> replaceVals, VncVal meta) {
        return new VncOrderedMap(replaceVals, meta);
    }

    @Override
    public VncOrderedMap withMeta(VncVal meta) {
        return new VncOrderedMap(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncMap.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncMap.TYPE, VncCollection.TYPE, VncVal.TYPE);
    }

    @Override
    public java.util.Map<VncVal, VncVal> getJavaMap() {
        return Collections.unmodifiableMap(this.value.toJavaMap());
    }

    @Override
    public VncVal get(VncVal key) {
        return this.value.get(key).getOrElse(Constants.Nil);
    }

    @Override
    public VncVal containsKey(VncVal key) {
        return VncBoolean.of(this.value.containsKey(key));
    }

    @Override
    public VncList keys() {
        return VncList.ofList(new ArrayList(this.value.keySet().toJavaList()));
    }

    @Override
    public List<VncMapEntry> entries() {
        return Collections.unmodifiableList(this.value.map(e -> new VncMapEntry((VncVal)e._1, (VncVal)e._2)).collect(Collectors.toList()));
    }

    @Override
    public VncOrderedMap putAll(VncMap map) {
        if (map instanceof VncOrderedMap) {
            return new VncOrderedMap(this.value.merge(((VncOrderedMap)map).value), this.getMeta());
        }
        return new VncOrderedMap(this.value.merge(LinkedHashMap.ofAll(map.getJavaMap())), this.getMeta());
    }

    @Override
    public VncOrderedMap assoc(VncVal ... mvs) {
        if (mvs.length % 2 != 0) {
            throw new VncException(String.format("ordered-map: assoc requires an even number of items. %s", ErrorMessage.buildErrLocation(mvs[0])));
        }
        Map<VncVal, VncVal> tmp = this.value;
        for (int i = 0; i < mvs.length; i += 2) {
            tmp = tmp.put((Object)mvs[i], (Object)mvs[i + 1]);
        }
        return new VncOrderedMap(tmp, this.getMeta());
    }

    @Override
    public VncOrderedMap assoc(VncSequence mvs) {
        if (mvs.size() % 2 != 0) {
            throw new VncException(String.format("ordered-map: assoc requires an even number of items. %s", ErrorMessage.buildErrLocation(mvs)));
        }
        Map<VncVal, VncVal> map = this.value;
        VncSequence kv = mvs;
        while (!kv.isEmpty()) {
            map = map.put((Object)kv.first(), (Object)kv.second());
            kv = kv.drop(2);
        }
        return new VncOrderedMap(map, this.getMeta());
    }

    @Override
    public VncOrderedMap dissoc(VncVal ... keys) {
        return new VncOrderedMap(this.value.removeAll(Arrays.asList(keys)), this.getMeta());
    }

    @Override
    public VncOrderedMap dissoc(VncSequence keys) {
        return new VncOrderedMap(this.value.removeAll((Iterable)keys), this.getMeta());
    }

    @Override
    public VncList toVncList() {
        return VncList.ofAll(this.value.map(e -> VncVector.of((VncVal)e._1, (VncVal)e._2)), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return VncVector.ofAll(this.value.map(e -> VncVector.of((VncVal)e._1, (VncVal)e._2)), this.getMeta());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.ORDEREDMAP;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncOrderedMap(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncOrderedMap)o).size()));
            if (c != 0) {
                return c;
            }
            return this.equals(o) ? 0 : -1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncOrderedMap other = (VncOrderedMap)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        Stream<VncVal> stream = this.value.map(e -> Arrays.asList((VncVal)e._1, (VncVal)e._2)).collect(Collectors.toList()).stream().flatMap(l -> l.stream());
        return "{" + Printer.join(stream, " ", print_readably) + "}";
    }
}

