/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.org.jline.terminal.impl.jna;

import com.sun.jna.Platform;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import org.repackage.org.jline.terminal.Attributes;
import org.repackage.org.jline.terminal.Size;
import org.repackage.org.jline.terminal.impl.AbstractPty;
import org.repackage.org.jline.terminal.impl.jna.freebsd.FreeBsdNativePty;
import org.repackage.org.jline.terminal.impl.jna.linux.LinuxNativePty;
import org.repackage.org.jline.terminal.impl.jna.osx.OsXNativePty;
import org.repackage.org.jline.terminal.impl.jna.solaris.SolarisNativePty;
import org.repackage.org.jline.terminal.spi.Pty;

public abstract class JnaNativePty
extends AbstractPty
implements Pty {
    private final int master;
    private final int slave;
    private final int slaveOut;
    private final String name;
    private final FileDescriptor masterFD;
    private final FileDescriptor slaveFD;
    private final FileDescriptor slaveOutFD;

    public static JnaNativePty current() throws IOException {
        if (Platform.isMac()) {
            return OsXNativePty.current();
        }
        if (Platform.isLinux()) {
            return LinuxNativePty.current();
        }
        if (Platform.isSolaris()) {
            return SolarisNativePty.current();
        }
        if (Platform.isFreeBSD()) {
            return FreeBsdNativePty.current();
        }
        throw new UnsupportedOperationException();
    }

    public static JnaNativePty open(Attributes attr, Size size) throws IOException {
        if (Platform.isMac()) {
            return OsXNativePty.open(attr, size);
        }
        if (Platform.isLinux()) {
            return LinuxNativePty.open(attr, size);
        }
        if (Platform.isSolaris()) {
            return SolarisNativePty.open(attr, size);
        }
        if (Platform.isFreeBSD()) {
            return FreeBsdNativePty.open(attr, size);
        }
        throw new UnsupportedOperationException();
    }

    protected JnaNativePty(int master, FileDescriptor masterFD, int slave, FileDescriptor slaveFD, String name) {
        this(master, masterFD, slave, slaveFD, slave, slaveFD, name);
    }

    protected JnaNativePty(int master, FileDescriptor masterFD, int slave, FileDescriptor slaveFD, int slaveOut, FileDescriptor slaveOutFD, String name) {
        this.master = master;
        this.slave = slave;
        this.slaveOut = slaveOut;
        this.name = name;
        this.masterFD = masterFD;
        this.slaveFD = slaveFD;
        this.slaveOutFD = slaveOutFD;
    }

    @Override
    public void close() throws IOException {
        if (this.master > 0) {
            this.getMasterInput().close();
        }
        if (this.slave > 0) {
            this.getSlaveInput().close();
        }
    }

    public int getMaster() {
        return this.master;
    }

    public int getSlave() {
        return this.slave;
    }

    public int getSlaveOut() {
        return this.slaveOut;
    }

    public String getName() {
        return this.name;
    }

    public FileDescriptor getMasterFD() {
        return this.masterFD;
    }

    public FileDescriptor getSlaveFD() {
        return this.slaveFD;
    }

    public FileDescriptor getSlaveOutFD() {
        return this.slaveOutFD;
    }

    @Override
    public InputStream getMasterInput() {
        return new FileInputStream(this.getMasterFD());
    }

    @Override
    public OutputStream getMasterOutput() {
        return new FileOutputStream(this.getMasterFD());
    }

    @Override
    protected InputStream doGetSlaveInput() {
        return new FileInputStream(this.getSlaveFD());
    }

    @Override
    public OutputStream getSlaveOutput() {
        return new FileOutputStream(this.getSlaveOutFD());
    }

    protected static FileDescriptor newDescriptor(int fd) {
        try {
            Constructor cns = FileDescriptor.class.getDeclaredConstructor(Integer.TYPE);
            cns.setAccessible(true);
            return (FileDescriptor)cns.newInstance(fd);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to create FileDescriptor", e);
        }
    }

    public String toString() {
        return "JnaNativePty[" + this.getName() + "]";
    }

    public static boolean isConsoleOutput() {
        if (Platform.isMac()) {
            return OsXNativePty.isatty(1) == 1;
        }
        if (Platform.isLinux()) {
            return LinuxNativePty.isatty(1) == 1;
        }
        if (Platform.isSolaris()) {
            return SolarisNativePty.isatty(1) == 1;
        }
        if (Platform.isFreeBSD()) {
            return FreeBsdNativePty.isatty(1) == 1;
        }
        return false;
    }
}

