/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.ArrayFlags;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import jnr.ffi.Address;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.byref.ByReference;
import jnr.ffi.provider.AbstractArrayMemoryIO;
import jnr.ffi.provider.AbstractBufferMemoryIO;
import jnr.ffi.provider.DelegatingMemoryIO;
import jnr.ffi.provider.InvocationSession;
import jnr.ffi.provider.ParameterFlags;
import jnr.ffi.provider.jffi.AllocatedDirectMemoryIO;
import jnr.ffi.provider.jffi.ArrayMemoryIO;
import jnr.ffi.provider.jffi.DirectMemoryIO;
import jnr.ffi.provider.jffi.MemoryUtil;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.util.BufferUtil;
import jnr.ffi.util.EnumMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsmRuntime {
    public static final MemoryIO IO = MemoryIO.getInstance();

    private AsmRuntime() {
    }

    public static final void marshal(InvocationBuffer buffer, byte[] array, int flags) {
        if (array == null) {
            buffer.putAddress(0L);
        } else {
            buffer.putArray(array, 0, array.length, flags);
        }
    }

    public static final void marshal(InvocationBuffer buffer, short[] array, int flags) {
        if (array == null) {
            buffer.putAddress(0L);
        } else {
            buffer.putArray(array, 0, array.length, flags);
        }
    }

    public static final void marshal(InvocationBuffer buffer, int[] array, int flags) {
        if (array == null) {
            buffer.putAddress(0L);
        } else {
            buffer.putArray(array, 0, array.length, flags);
        }
    }

    public static final void marshal(InvocationBuffer buffer, long[] array, int nativeArrayFlags) {
        if (array == null) {
            buffer.putAddress(0L);
        } else {
            buffer.putArray(array, 0, array.length, nativeArrayFlags);
        }
    }

    public static final void marshal32(InvocationBuffer buffer, InvocationSession session, final long[] array, int nativeArrayFlags) {
        if (array == null) {
            buffer.putAddress(0L);
        } else {
            final int[] nativeArray = new int[array.length];
            if (ArrayFlags.isIn((int)nativeArrayFlags)) {
                for (int i = 0; i < array.length; ++i) {
                    nativeArray[i] = (int)array[i];
                }
            }
            buffer.putArray(nativeArray, 0, nativeArray.length, nativeArrayFlags);
            if (ArrayFlags.isOut((int)nativeArrayFlags)) {
                session.addPostInvoke(new InvocationSession.PostInvoke(){

                    public void postInvoke() {
                        for (int i = 0; i < nativeArray.length; ++i) {
                            array[i] = nativeArray[i];
                        }
                    }
                });
            }
        }
    }

    public static final void marshal(InvocationBuffer buffer, float[] array, int flags) {
        if (array == null) {
            buffer.putAddress(0L);
        } else {
            buffer.putArray(array, 0, array.length, flags);
        }
    }

    public static final void marshal(InvocationBuffer buffer, double[] array, int flags) {
        if (array == null) {
            buffer.putAddress(0L);
        } else {
            buffer.putArray(array, 0, array.length, flags);
        }
    }

    public static final void marshal(InvocationBuffer buffer, Pointer ptr, int nativeArrayFlags) {
        if (ptr == null) {
            buffer.putAddress(0L);
        } else if (ptr.isDirect()) {
            buffer.putAddress(ptr.address());
        } else if (ptr instanceof AbstractArrayMemoryIO) {
            AbstractArrayMemoryIO aio = (AbstractArrayMemoryIO)ptr;
            buffer.putArray(aio.array(), aio.offset(), aio.length(), nativeArrayFlags);
        } else if (ptr instanceof AbstractBufferMemoryIO) {
            AbstractBufferMemoryIO bio = (AbstractBufferMemoryIO)ptr;
            AsmRuntime.marshal(buffer, bio.getByteBuffer(), nativeArrayFlags);
        } else {
            throw new IllegalArgumentException("unsupported argument type " + ptr.getClass());
        }
    }

    public static final void marshal(InvocationBuffer buffer, Address ptr) {
        if (ptr == null) {
            buffer.putAddress(0L);
        } else {
            buffer.putAddress(ptr.nativeAddress());
        }
    }

    public static final void marshal(InvocationBuffer buffer, ByteBuffer buf, int flags) {
        if (buf == null) {
            buffer.putAddress(0L);
        } else if (buf.hasArray()) {
            buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), flags);
        } else if (buf.isDirect()) {
            buffer.putDirectBuffer((Buffer)buf, buf.position(), buf.remaining());
        } else {
            throw new IllegalArgumentException("cannot marshal non-direct, non-array ByteBuffer");
        }
    }

    public static final void marshal(InvocationBuffer buffer, ShortBuffer buf, int flags) {
        if (buf == null) {
            buffer.putAddress(0L);
        } else if (buf.hasArray()) {
            buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), flags);
        } else if (buf.isDirect()) {
            buffer.putDirectBuffer((Buffer)buf, buf.position() << 1, buf.remaining() << 1);
        } else {
            throw new IllegalArgumentException("cannot marshal non-direct, non-array ShortBuffer");
        }
    }

    public static final void marshal(InvocationBuffer buffer, IntBuffer buf, int flags) {
        if (buf == null) {
            buffer.putAddress(0L);
        } else if (buf.hasArray()) {
            buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), flags);
        } else if (buf.isDirect()) {
            buffer.putDirectBuffer((Buffer)buf, buf.position() << 2, buf.remaining() << 2);
        } else {
            throw new IllegalArgumentException("cannot marshal non-direct, non-array IntBuffer");
        }
    }

    public static final void marshal(InvocationBuffer buffer, LongBuffer buf, int flags) {
        if (buf == null) {
            buffer.putAddress(0L);
        } else if (buf.hasArray()) {
            buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), flags);
        } else if (buf.isDirect()) {
            buffer.putDirectBuffer((Buffer)buf, buf.position() << 3, buf.remaining() << 3);
        } else {
            throw new IllegalArgumentException("cannot marshal non-direct, non-array LongBuffer");
        }
    }

    public static final void marshal(InvocationBuffer buffer, FloatBuffer buf, int flags) {
        if (buf == null) {
            buffer.putAddress(0L);
        } else if (buf.hasArray()) {
            buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), flags);
        } else if (buf.isDirect()) {
            buffer.putDirectBuffer((Buffer)buf, buf.position() << 2, buf.remaining() << 2);
        } else {
            throw new IllegalArgumentException("cannot marshal non-direct, non-array FloatBuffer");
        }
    }

    public static final void marshal(InvocationBuffer buffer, DoubleBuffer buf, int flags) {
        if (buf == null) {
            buffer.putAddress(0L);
        } else if (buf.hasArray()) {
            buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), flags);
        } else if (buf.isDirect()) {
            buffer.putDirectBuffer((Buffer)buf, buf.position() << 3, buf.remaining() << 3);
        } else {
            throw new IllegalArgumentException("cannot marshal non-direct, non-array DoubleBuffer");
        }
    }

    public static final void marshal(InvocationBuffer buffer, CharSequence cs) {
        if (cs == null) {
            buffer.putAddress(0L);
        } else {
            ByteBuffer buf = Charset.defaultCharset().encode(CharBuffer.wrap(cs));
            buffer.putArray(buf.array(), buf.arrayOffset(), buf.remaining(), 5);
        }
    }

    public static final void marshal(InvocationBuffer buffer, Struct parameter, int parameterFlags, int nativeArrayFlags) {
        if (parameter == null) {
            buffer.putAddress(0L);
        } else {
            Struct s = parameter;
            Pointer memory = Struct.getMemory(s, parameterFlags);
            if (memory instanceof AbstractArrayMemoryIO) {
                AbstractArrayMemoryIO aio = (AbstractArrayMemoryIO)memory;
                buffer.putArray(aio.array(), aio.offset(), aio.length(), nativeArrayFlags);
            } else if (memory.isDirect()) {
                buffer.putAddress(memory.address());
            }
        }
    }

    public static final void marshal(InvocationBuffer buffer, Struct[] parameter, int parameterFlags, int nativeArrayFlags) {
        if (parameter == null) {
            buffer.putAddress(0L);
        } else {
            Struct[] array = parameter;
            Pointer memory = Struct.getMemory(array[0], parameterFlags);
            if (!(memory instanceof DelegatingMemoryIO)) {
                throw new RuntimeException("Struct array must be backed by contiguous array");
            }
            if ((memory = ((DelegatingMemoryIO)((Object)memory)).getDelegatedMemoryIO()) instanceof AbstractArrayMemoryIO) {
                AbstractArrayMemoryIO aio = (AbstractArrayMemoryIO)memory;
                buffer.putArray(aio.array(), aio.offset(), aio.length(), nativeArrayFlags);
            } else if (memory.isDirect()) {
                buffer.putAddress(memory.address());
            }
        }
    }

    public static final void marshal(InvocationBuffer buffer, InvocationSession session, ByReference parameter, int flags) {
        if (parameter == null) {
            buffer.putAddress(0L);
        } else {
            final ByReference ref = parameter;
            int size = ref.nativeSize(NativeRuntime.getInstance());
            final ArrayMemoryIO memory = new ArrayMemoryIO(size);
            if (ArrayFlags.isIn((int)flags)) {
                ref.marshal(memory, 0L);
            }
            buffer.putArray(memory.array(), memory.offset(), size, flags);
            if (ArrayFlags.isOut((int)flags)) {
                session.addPostInvoke(new InvocationSession.PostInvoke(){

                    public void postInvoke() {
                        ref.unmarshal(memory, 0L);
                    }
                });
            }
        }
    }

    public static final void marshal(InvocationBuffer buffer, InvocationSession session, StringBuilder parameter, int inout, int nflags) {
        if (parameter == null) {
            buffer.putAddress(0L);
        } else {
            ByteBuffer tmp;
            ByteBuffer buf;
            final StringBuilder sb = parameter;
            ByteBuffer byteBuffer = buf = ParameterFlags.isIn(inout) ? Charset.defaultCharset().encode(CharBuffer.wrap(parameter)) : ByteBuffer.allocate(sb.capacity() + 1);
            if (ParameterFlags.isOut(inout) && buf.capacity() < sb.capacity() + 1) {
                tmp = ByteBuffer.allocate(sb.capacity() + 1);
                tmp.put(buf);
                tmp.flip();
                buf = tmp;
            }
            buffer.putArray(buf.array(), buf.arrayOffset(), buf.capacity(), nflags);
            if (ParameterFlags.isOut(inout)) {
                tmp = buf;
                session.addPostInvoke(new InvocationSession.PostInvoke(){

                    public void postInvoke() {
                        tmp.limit(tmp.capacity());
                        tmp.position(0);
                        sb.delete(0, sb.length()).append(BufferUtil.getCharSequence(tmp, Charset.defaultCharset()));
                    }
                });
            }
        }
    }

    public static final void marshal(InvocationBuffer buffer, InvocationSession session, StringBuffer parameter, int inout, int nflags) {
        if (parameter == null) {
            buffer.putAddress(0L);
        } else {
            ByteBuffer tmp;
            ByteBuffer buf;
            final StringBuffer sb = parameter;
            ByteBuffer byteBuffer = buf = ParameterFlags.isIn(inout) ? Charset.defaultCharset().encode(CharBuffer.wrap(parameter)) : ByteBuffer.allocate(sb.capacity() + 1);
            if (ParameterFlags.isOut(inout) && buf.capacity() < sb.capacity() + 1) {
                tmp = ByteBuffer.allocate(sb.capacity() + 1);
                tmp.put(buf);
                tmp.flip();
                buf = tmp;
            }
            buffer.putArray(buf.array(), buf.arrayOffset(), buf.capacity(), nflags);
            if (ParameterFlags.isOut(inout)) {
                tmp = buf;
                session.addPostInvoke(new InvocationSession.PostInvoke(){

                    public void postInvoke() {
                        tmp.limit(tmp.capacity());
                        tmp.position(0);
                        sb.delete(0, sb.length()).append(BufferUtil.getCharSequence(tmp, Charset.defaultCharset()));
                    }
                });
            }
        }
    }

    public static final void marshal(InvocationBuffer buffer, InvocationSession session, final CharSequence[] strings, final int inout, int nativeArrayFlags) {
        if (strings == null) {
            buffer.putAddress(0L);
        } else {
            final AllocatedDirectMemoryIO[] pointers = new AllocatedDirectMemoryIO[strings.length];
            Charset charset = Charset.defaultCharset();
            if (ParameterFlags.isIn(inout)) {
                for (int i = 0; i < strings.length; ++i) {
                    if (strings[i] != null) {
                        ByteBuffer buf = charset.encode(CharBuffer.wrap(strings[i]));
                        AllocatedDirectMemoryIO ptr = new AllocatedDirectMemoryIO(buf.remaining() + 1, false);
                        ptr.putZeroTerminatedByteArray(0L, buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
                        pointers[i] = ptr;
                        continue;
                    }
                    pointers[i] = null;
                }
            }
            final Pointer[] tmp = new Pointer[pointers.length];
            System.arraycopy(pointers, 0, tmp, 0, tmp.length);
            AsmRuntime.marshal(buffer, session, tmp, inout, nativeArrayFlags);
            session.addPostInvoke(new InvocationSession.PostInvoke(){

                public void postInvoke() {
                    int i;
                    if (ParameterFlags.isOut(inout)) {
                        for (i = 0; i < pointers.length; ++i) {
                            if (tmp[i] == null) continue;
                            strings[i] = tmp[i].getString(0L);
                        }
                    }
                    for (i = 0; i < pointers.length; ++i) {
                        if (pointers[i] == null) continue;
                        pointers[i].dispose();
                    }
                }
            });
        }
    }

    public static final void marshal(InvocationBuffer buffer, Enum parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("enum value cannot be null");
        }
        buffer.putInt(EnumMapper.getInstance(parameter.getClass()).intValue(parameter));
    }

    public static final void marshal(InvocationBuffer buffer, Boolean parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Boolean value cannot be null");
        }
        buffer.putInt(parameter != false ? 1 : 0);
    }

    public static final void marshal(InvocationBuffer buffer, boolean parameter) {
        buffer.putInt(parameter ? 1 : 0);
    }

    public static final void marshal(InvocationBuffer buffer, InvocationSession session, final Pointer[] pointers, int inout, int nativeArrayFlags) {
        if (pointers == null) {
            buffer.putAddress(0L);
        } else if (Platform.getPlatform().addressSize() == 32) {
            final int[] raw = new int[pointers.length + 1];
            for (int i = 0; i < pointers.length; ++i) {
                if (pointers[i] != null && !pointers[i].isDirect()) {
                    throw new IllegalArgumentException("invalid pointer in array at index " + i);
                }
                raw[i] = pointers[i] != null ? (int)pointers[i].address() : 0;
            }
            buffer.putArray(raw, 0, raw.length, nativeArrayFlags);
            if (ParameterFlags.isOut(inout)) {
                session.addPostInvoke(new InvocationSession.PostInvoke(){

                    public void postInvoke() {
                        for (int i = 0; i < pointers.length; ++i) {
                            pointers[i] = MemoryUtil.newPointer(raw[i]);
                        }
                    }
                });
            }
        } else {
            final long[] raw = new long[pointers.length + 1];
            for (int i = 0; i < pointers.length; ++i) {
                if (pointers[i] != null && !pointers[i].isDirect()) {
                    throw new IllegalArgumentException("invalid pointer in array at index " + i);
                }
                raw[i] = pointers[i] != null ? pointers[i].address() : 0L;
            }
            buffer.putArray(raw, 0, raw.length, nativeArrayFlags);
            if (ParameterFlags.isOut(inout)) {
                session.addPostInvoke(new InvocationSession.PostInvoke(){

                    public void postInvoke() {
                        for (int i = 0; i < pointers.length; ++i) {
                            pointers[i] = MemoryUtil.newPointer(raw[i]);
                        }
                    }
                });
            }
        }
    }

    public static final UnsatisfiedLinkError newUnsatisifiedLinkError(String msg) {
        return new UnsatisfiedLinkError(msg);
    }

    public static final HeapInvocationBuffer newHeapInvocationBuffer(Function function) {
        return new HeapInvocationBuffer(function);
    }

    public static final String stringValue(long ptr) {
        if (ptr == 0L) {
            return null;
        }
        return Charset.defaultCharset().decode(ByteBuffer.wrap(IO.getZeroTerminatedByteArray(ptr))).toString();
    }

    public static final String stringValue(int ptr) {
        return AsmRuntime.stringValue((long)ptr);
    }

    public static final Pointer pointerValue(long ptr) {
        return ptr != 0L ? new DirectMemoryIO(ptr) : null;
    }

    public static final Pointer pointerValue(int ptr) {
        return ptr != 0 ? new DirectMemoryIO(ptr) : null;
    }

    public static final void useMemory(long ptr, Struct s) {
        s.useMemory(ptr != 0L ? new DirectMemoryIO(ptr) : MemoryUtil.NULL);
    }

    public static final void useMemory(int ptr, Struct s) {
        s.useMemory(ptr != 0 ? new DirectMemoryIO(ptr) : MemoryUtil.NULL);
    }

    public static final boolean isDirect(Pointer ptr) {
        return ptr == null || ptr.isDirect();
    }

    public static final int intValue(Pointer ptr) {
        return ptr != null ? (int)ptr.address() : 0;
    }

    public static final long longValue(Pointer ptr) {
        return ptr != null ? ptr.address() : 0L;
    }

    public static final boolean isDirect5(Buffer buffer) {
        if (buffer == null) {
            return true;
        }
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).isDirect();
        }
        if (buffer instanceof ShortBuffer) {
            return ((ShortBuffer)buffer).isDirect();
        }
        if (buffer instanceof CharBuffer) {
            return ((CharBuffer)buffer).isDirect();
        }
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).isDirect();
        }
        if (buffer instanceof LongBuffer) {
            return ((LongBuffer)buffer).isDirect();
        }
        if (buffer instanceof FloatBuffer) {
            return ((FloatBuffer)buffer).isDirect();
        }
        if (buffer instanceof DoubleBuffer) {
            return ((DoubleBuffer)buffer).isDirect();
        }
        throw new UnsupportedOperationException("unsupported java.nio.Buffer subclass " + buffer.getClass());
    }

    public static final boolean isDirect(Buffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static final boolean isDirect(ByteBuffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static final boolean isDirect(CharBuffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static final boolean isDirect(ShortBuffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static final boolean isDirect(IntBuffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static final boolean isDirect(LongBuffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static final boolean isDirect(FloatBuffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static final boolean isDirect(DoubleBuffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static long longValue(Buffer buffer) {
        if (buffer == null) {
            return 0L;
        }
        long address = MemoryIO.getInstance().getDirectBufferAddress(buffer);
        long pos = buffer.position();
        if (!(buffer instanceof ByteBuffer)) {
            if (buffer instanceof ShortBuffer || buffer instanceof CharBuffer) {
                pos <<= 1;
            } else if (buffer instanceof IntBuffer || buffer instanceof FloatBuffer) {
                pos <<= 2;
            } else if (buffer instanceof LongBuffer || buffer instanceof DoubleBuffer) {
                pos <<= 3;
            } else {
                throw new UnsupportedOperationException("unsupported java.nio.Buffer subclass " + buffer.getClass());
            }
        }
        return address + pos;
    }

    public static final long longValue(ByteBuffer buffer) {
        return buffer != null ? MemoryIO.getInstance().getDirectBufferAddress((Buffer)buffer) + (long)buffer.position() : 0L;
    }

    public static final long longValue(ShortBuffer buffer) {
        return buffer != null ? MemoryIO.getInstance().getDirectBufferAddress((Buffer)buffer) + (long)(buffer.position() << 1) : 0L;
    }

    public static final long longValue(CharBuffer buffer) {
        return buffer != null ? MemoryIO.getInstance().getDirectBufferAddress((Buffer)buffer) + (long)(buffer.position() << 1) : 0L;
    }

    public static final long longValue(IntBuffer buffer) {
        return buffer != null ? MemoryIO.getInstance().getDirectBufferAddress((Buffer)buffer) + (long)(buffer.position() << 2) : 0L;
    }

    public static final long longValue(LongBuffer buffer) {
        return buffer != null ? MemoryIO.getInstance().getDirectBufferAddress((Buffer)buffer) + (long)(buffer.position() << 3) : 0L;
    }

    public static final long longValue(FloatBuffer buffer) {
        return buffer != null ? MemoryIO.getInstance().getDirectBufferAddress((Buffer)buffer) + (long)(buffer.position() << 2) : 0L;
    }

    public static final long longValue(DoubleBuffer buffer) {
        return buffer != null ? MemoryIO.getInstance().getDirectBufferAddress((Buffer)buffer) + (long)(buffer.position() << 3) : 0L;
    }

    public static final boolean isDirect(Struct s) {
        return s == null || Struct.isDirect(s);
    }

    public static final boolean isDirect(Struct s, int flags) {
        return s == null || Struct.getMemory(s, flags).isDirect();
    }

    public static final int intValue(Struct s) {
        return s != null ? (int)Struct.getMemory(s).address() : 0;
    }

    public static final long longValue(Struct s) {
        return s != null ? Struct.getMemory(s).address() : 0L;
    }

    public static final Enum enumValue(int value, Class<? extends Enum> enumClass) {
        return EnumMapper.getInstance(enumClass).valueOf(value);
    }

    public static final int intValue(Enum e) {
        return EnumMapper.getInstance(e.getClass()).intValue(e);
    }

    public static final long longValue(Enum e) {
        return EnumMapper.getInstance(e.getClass()).intValue(e);
    }
}

