/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import java.lang.annotation.Annotation;
import java.nio.Buffer;
import jnr.ffi.Address;
import jnr.ffi.NativeLong;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.provider.jffi.AbstractFastNumericMethodGenerator;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.BufferMethodGenerator;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.Signature;

public class FastLongMethodGenerator
extends AbstractFastNumericMethodGenerator {
    private static final int MAX_PARAMETERS = FastLongMethodGenerator.getMaximumFastLongParameters();
    private static final String[] signatures;
    private static final String[] methodNames;

    public FastLongMethodGenerator(BufferMethodGenerator bufgen) {
        super(bufgen);
    }

    String getInvokerMethodName(Class returnType, Annotation[] resultAnnotations, Class[] parameterTypes, Annotation[][] parameterAnnotations, boolean ignoreErrno) {
        int parameterCount = parameterTypes.length;
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    String getInvokerSignature(int parameterCount, Class nativeIntType) {
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    Class getInvokerType() {
        return Long.TYPE;
    }

    public boolean isSupported(Signature signature) {
        int parameterCount = signature.parameterTypes.length;
        if (signature.callingConvention != CallingConvention.DEFAULT || parameterCount > MAX_PARAMETERS) {
            return false;
        }
        Platform platform = Platform.getPlatform();
        if (platform.getCPU() != Platform.CPU.X86_64) {
            return false;
        }
        if (platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        for (int i = 0; i < parameterCount; ++i) {
            if (FastLongMethodGenerator.isFastLongParameter(platform, signature.parameterTypes[i], signature.parameterAnnotations[i])) continue;
            return false;
        }
        return FastLongMethodGenerator.isFastLongResult(platform, signature.resultType, signature.resultAnnotations);
    }

    static final int getMaximumFastLongParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeLLLLLLrL", Function.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            return 6;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private static boolean isLongType(Platform platform, Class type, Annotation[] annotations) {
        return Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type || Byte.class.isAssignableFrom(type) || Byte.TYPE == type || Short.class.isAssignableFrom(type) || Short.TYPE == type || Integer.class.isAssignableFrom(type) || Integer.TYPE == type || Long.class == type || Long.TYPE == type || NativeLong.class == type || Pointer.class.isAssignableFrom(type) || Struct.class.isAssignableFrom(type) || Address.class == type;
    }

    static boolean isFastLongResult(Platform platform, Class type, Annotation[] annotations) {
        return FastLongMethodGenerator.isLongType(platform, type, annotations) || Void.class.isAssignableFrom(type) || Void.TYPE == type || String.class == type;
    }

    static boolean isFastLongParameter(Platform platform, Class type, Annotation[] annotations) {
        return FastLongMethodGenerator.isLongType(platform, type, annotations) || Buffer.class.isAssignableFrom(type) && platform.addressSize() == 64 || AsmUtil.isDelegate(type) && platform.addressSize() == 64;
    }

    static {
        methodNames = new String[]{"invokeVrL", "invokeLrL", "invokeLLrL", "invokeLLLrL", "invokeLLLLrL", "invokeLLLLLrL", "invokeLLLLLLrL"};
        signatures = new String[MAX_PARAMETERS + 1];
        for (int i = 0; i <= MAX_PARAMETERS; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append('(').append(CodegenUtils.ci(Function.class));
            for (int n = 0; n < i; ++n) {
                sb.append('J');
            }
            FastLongMethodGenerator.signatures[i] = sb.append(")J").toString();
        }
    }
}

