/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.Platform;
import java.lang.annotation.Annotation;
import java.nio.Buffer;
import java.util.concurrent.atomic.AtomicLong;
import jnr.ffi.NativeLong;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.provider.jffi.AsmBuilder;
import jnr.ffi.provider.jffi.AsmLibraryLoader;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.BufferMethodGenerator;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.MethodGenerator;
import jnr.ffi.provider.jffi.Signature;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;
import jnr.ffi.provider.jffi.StubCompiler;
import org.objectweb.asm.Label;

class X86MethodGenerator
implements MethodGenerator {
    private final AtomicLong nextMethodID = new AtomicLong(0L);
    private final StubCompiler compiler;
    private final BufferMethodGenerator bufgen;

    X86MethodGenerator(StubCompiler compiler, BufferMethodGenerator bufgen) {
        this.compiler = compiler;
        this.bufgen = bufgen;
    }

    public boolean isSupported(Signature signature) {
        if (!Boolean.valueOf(System.getProperty("jnr.ffi.compile.x86asm", "true")).booleanValue()) {
            return false;
        }
        Platform platform = Platform.getPlatform();
        if (platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        if (!platform.getCPU().equals((Object)Platform.CPU.I386) && !platform.getCPU().equals((Object)Platform.CPU.X86_64)) {
            return false;
        }
        if (!signature.callingConvention.equals((Object)CallingConvention.DEFAULT)) {
            return false;
        }
        Class[] nativeParameterTypes = new Class[signature.parameterTypes.length];
        for (int i = 0; i < nativeParameterTypes.length; ++i) {
            if (!X86MethodGenerator.isSupportedParameter(platform, signature.parameterTypes[i], signature.parameterAnnotations[i])) {
                return false;
            }
            nativeParameterTypes[i] = Buffer.class.isAssignableFrom(signature.parameterTypes[i]) ? AsmUtil.unboxedType(Pointer.class) : AsmUtil.unboxedType(signature.parameterTypes[i]);
        }
        return X86MethodGenerator.isSupportedResult(platform, signature.resultType, signature.resultAnnotations) && this.compiler.canCompile(AsmUtil.unboxedReturnType(signature.resultType), nativeParameterTypes, signature.callingConvention);
    }

    public void generate(AsmBuilder builder, String functionName, Function function, Signature signature) {
        Class nativeReturnType;
        Class[] nativeParameterTypes = new Class[signature.parameterTypes.length];
        boolean unboxing = false;
        boolean ptrCheck = false;
        for (int i = 0; i < signature.parameterTypes.length; ++i) {
            Class parameterType = signature.parameterTypes[i];
            nativeParameterTypes[i] = Buffer.class.isAssignableFrom(parameterType) ? AsmUtil.unboxedType(Pointer.class) : AsmUtil.unboxedType(parameterType);
            unboxing |= nativeParameterTypes[i] != parameterType;
            ptrCheck |= Pointer.class.isAssignableFrom(parameterType) || Struct.class.isAssignableFrom(parameterType) || Buffer.class.isAssignableFrom(parameterType);
        }
        String stubName = functionName + ((unboxing |= (nativeReturnType = AsmUtil.unboxedReturnType(signature.resultType)) != signature.resultType) || ptrCheck ? "$jni$" + this.nextMethodID.incrementAndGet() : "");
        if (unboxing || ptrCheck) {
            SkinnyMethodAdapter mv = new SkinnyMethodAdapter(builder.getClassVisitor().visitMethod(17, functionName, CodegenUtils.sig(signature.resultType, signature.parameterTypes), null, null));
            mv.start();
            mv.aload(0);
            Label bufferInvocationLabel = AsmLibraryLoader.emitDirectCheck(mv, signature.parameterTypes);
            int lvar = 1;
            for (int i = 0; i < signature.parameterTypes.length; ++i) {
                Class parameterType = signature.parameterTypes[i];
                lvar = AsmLibraryLoader.loadParameter(mv, parameterType, lvar);
                if (parameterType == nativeParameterTypes[i]) continue;
                if (Number.class.isAssignableFrom(parameterType)) {
                    AsmUtil.unboxNumber(mv, parameterType, nativeParameterTypes[i]);
                    continue;
                }
                if (Boolean.class.isAssignableFrom(parameterType)) {
                    AsmUtil.unboxBoolean(mv, parameterType, nativeParameterTypes[i]);
                    continue;
                }
                if (Pointer.class.isAssignableFrom(parameterType)) {
                    AsmUtil.unboxPointer(mv, nativeParameterTypes[i]);
                    continue;
                }
                if (Struct.class.isAssignableFrom(parameterType)) {
                    AsmUtil.unboxStruct(mv, nativeParameterTypes[i]);
                    continue;
                }
                if (Buffer.class.isAssignableFrom(parameterType)) {
                    AsmUtil.unboxBuffer(mv, parameterType, nativeParameterTypes[i]);
                    continue;
                }
                if (!Enum.class.isAssignableFrom(parameterType)) continue;
                AsmUtil.unboxEnum(mv, nativeParameterTypes[i]);
            }
            mv.invokevirtual(builder.getClassNamePath(), stubName, CodegenUtils.sig(nativeReturnType, nativeParameterTypes));
            AsmLibraryLoader.emitReturn(mv, signature.resultType, nativeReturnType);
            if (bufferInvocationLabel != null) {
                mv.label(bufferInvocationLabel);
                String bufferFunctionName = functionName + "$buf$" + this.nextMethodID.incrementAndGet();
                int lvar2 = 1;
                for (int i = 0; i < signature.parameterTypes.length; ++i) {
                    lvar2 = AsmLibraryLoader.loadParameter(mv, signature.parameterTypes[i], lvar2);
                }
                mv.invokevirtual(builder.getClassNamePath(), bufferFunctionName, CodegenUtils.sig(signature.resultType, signature.parameterTypes));
                AsmUtil.emitReturnOp(mv, signature.resultType);
                this.bufgen.generate(builder, bufferFunctionName, function, signature);
            }
            mv.visitMaxs(100, AsmUtil.calculateLocalVariableSpace(signature.parameterTypes) + 10);
            mv.visitEnd();
        }
        builder.getClassVisitor().visitMethod(273, stubName, CodegenUtils.sig(nativeReturnType, nativeParameterTypes), null, null);
        this.compiler.compile(function, stubName, nativeReturnType, nativeParameterTypes, signature.callingConvention, !signature.ignoreError);
    }

    void attach(Class clazz) {
        this.compiler.attach(clazz);
    }

    private static boolean isSupportedType(Platform platform, Class type, Annotation[] annotations) {
        return Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type || Byte.class.isAssignableFrom(type) || Byte.TYPE == type || Short.class.isAssignableFrom(type) || Short.TYPE == type || Integer.class.isAssignableFrom(type) || Integer.TYPE == type || Long.class == type || Long.TYPE == type || NativeLong.class == type || Pointer.class.isAssignableFrom(type) || Struct.class.isAssignableFrom(type) || Float.TYPE == type || Float.class == type || Double.TYPE == type || Double.class == type;
    }

    static final boolean isSupportedResult(Platform platform, Class type, Annotation[] annotations) {
        return X86MethodGenerator.isSupportedType(platform, type, annotations) || String.class == type;
    }

    static final boolean isSupportedParameter(Platform platform, Class type, Annotation[] annotations) {
        return X86MethodGenerator.isSupportedType(platform, type, annotations) || Buffer.class.isAssignableFrom(type) || AsmUtil.isDelegate(type);
    }
}

