/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.MemoryIO;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jnr.ffi.Pointer;
import jnr.ffi.provider.AbstractBufferMemoryIO;
import jnr.ffi.provider.jffi.MemoryUtil;
import jnr.ffi.provider.jffi.NativeRuntime;

public class ByteBufferMemoryIO
extends AbstractBufferMemoryIO {
    public ByteBufferMemoryIO(NativeRuntime runtime, ByteBuffer buffer) {
        super(runtime, buffer);
    }

    public Pointer getPointer(long offset) {
        return MemoryUtil.newPointer(this.getAddress(offset));
    }

    public Pointer getPointer(long offset, long size) {
        return MemoryUtil.newPointer(this.getAddress(offset), size);
    }

    public void putPointer(long offset, Pointer value) {
        this.putAddress(offset, value.address());
    }

    public long address() {
        if (this.buffer.isDirect()) {
            long address = MemoryIO.getInstance().getDirectBufferAddress((Buffer)this.buffer);
            return address != 0L ? address + (long)this.buffer.position() : 0L;
        }
        return 0L;
    }
}

