/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.util.List;
import jnr.ffi.Pointer;
import jnr.posix.FileStat;
import jnr.posix.Group;
import jnr.posix.LibC;
import jnr.posix.Passwd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface POSIX {
    public FileStat allocateStat();

    public int chmod(String var1, int var2);

    public int chown(String var1, int var2, int var3);

    public int exec(String var1, String ... var2);

    public int exec(String var1, String[] var2, String[] var3);

    public int execv(String var1, String[] var2);

    public int execve(String var1, String[] var2, String[] var3);

    public int fork();

    public FileStat fstat(FileDescriptor var1);

    public String getenv(String var1);

    public int getegid();

    public int geteuid();

    public int seteuid(int var1);

    public int getgid();

    public String getlogin();

    public int getpgid();

    public int getpgid(int var1);

    public int getpgrp();

    public int getpid();

    public int getppid();

    public int getpriority(int var1, int var2);

    public Passwd getpwent();

    public Passwd getpwuid(int var1);

    public Passwd getpwnam(String var1);

    public Group getgrgid(int var1);

    public Group getgrnam(String var1);

    public Group getgrent();

    public int endgrent();

    public int setgrent();

    public int endpwent();

    public int setpwent();

    public int getuid();

    public boolean isatty(FileDescriptor var1);

    public int kill(int var1, int var2);

    public int lchmod(String var1, int var2);

    public int lchown(String var1, int var2, int var3);

    public int link(String var1, String var2);

    public FileStat lstat(String var1);

    public int mkdir(String var1, int var2);

    public String readlink(String var1) throws IOException;

    public int setenv(String var1, String var2, int var3);

    public int setsid();

    public int setgid(int var1);

    public int setegid(int var1);

    public int setpgid(int var1, int var2);

    public int setpgrp(int var1, int var2);

    public int setpriority(int var1, int var2, int var3);

    public int setuid(int var1);

    public FileStat stat(String var1);

    public int symlink(String var1, String var2);

    public int umask(int var1);

    public int unsetenv(String var1);

    public int utimes(String var1, long[] var2, long[] var3);

    public int waitpid(int var1, int[] var2, int var3);

    public int wait(int[] var1);

    public int errno();

    public void errno(int var1);

    public boolean isNative();

    public LibC libc();

    public int posix_spawnp(String var1, List<? extends SpawnFileAction> var2, List<? extends CharSequence> var3, List<? extends CharSequence> var4);

    public static final class SpawnCloseFileAction
    extends SpawnFileAction {
        final int fd;

        public SpawnCloseFileAction(int fd) {
            this.fd = fd;
        }

        public final boolean act(POSIX posix, Pointer nativeFileActions) {
            return posix.libc().posix_spawn_file_actions_addclose(nativeFileActions, this.fd) == 0;
        }
    }

    public static final class SpawnOpenFileAction
    extends SpawnFileAction {
        final String path;
        final int fd;
        final int flags;
        final int mode;

        public SpawnOpenFileAction(String path, int fd, int flags, int mode) {
            this.path = path;
            this.fd = fd;
            this.flags = flags;
            this.mode = mode;
        }

        public final boolean act(POSIX posix, Pointer nativeFileActions) {
            return posix.libc().posix_spawn_file_actions_addopen(nativeFileActions, this.fd, this.path, this.flags, this.mode) == 0;
        }
    }

    public static final class SpawnDupFileAction
    extends SpawnFileAction {
        final int fd;
        final int newfd;

        public SpawnDupFileAction(int fd, int newfd) {
            this.fd = fd;
            this.newfd = newfd;
        }

        public final boolean act(POSIX posix, Pointer nativeFileActions) {
            return posix.libc().posix_spawn_file_actions_adddup2(nativeFileActions, this.fd, this.newfd) == 0;
        }
    }

    public static abstract class SpawnFileAction {
        abstract boolean act(POSIX var1, Pointer var2);
    }
}

