/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import jnr.posix.JavaFileStat;
import jnr.posix.POSIX;
import jnr.posix.POSIXHandler;
import jnr.posix.util.WindowsHelpers;
import jnr.posix.windows.CommonFileInformation;

public class WindowsRawFileStat
extends JavaFileStat {
    private int st_atime;
    private int st_rdev;
    private int st_dev;
    private int st_nlink;

    public WindowsRawFileStat(POSIX posix, POSIXHandler handler) {
        super(posix, handler);
    }

    public void setup(String path, CommonFileInformation fileInfo) {
        this.st_mode = fileInfo.getMode(path);
        this.setup(fileInfo);
        if (WindowsHelpers.isDriveLetterPath(path)) {
            int letterAsNumber;
            this.st_rdev = letterAsNumber = path.charAt(0) - 65;
            this.st_dev = letterAsNumber;
        }
    }

    public void setup(CommonFileInformation fileInfo) {
        this.st_atime = (int)fileInfo.getLastAccessTimeMicroseconds();
        this.st_mtime = (int)fileInfo.getLastWriteTimeMicroseconds();
        this.st_ctime = (int)fileInfo.getCreationTimeMicroseconds();
        this.st_size = this.isDirectory() ? 0L : fileInfo.getFileSize();
        this.st_nlink = 1;
        this.st_mode = (short)(this.st_mode & 0xFFFFFFED);
    }

    @Override
    public long atime() {
        return this.st_atime;
    }

    @Override
    public long dev() {
        return this.st_dev;
    }

    @Override
    public int nlink() {
        return this.st_nlink;
    }

    @Override
    public long rdev() {
        return this.st_rdev;
    }
}

