/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import jnr.ffi.Platform;
import jnr.unixsocket.UnixDatagramChannel;
import jnr.unixsocket.UnixSocketAddress;
import junit.framework.Assert;
import org.junit.Assume;
import org.junit.Test;

public class BasicDatagramFunctionalityTest {
    private static final String DATA = "foo bar baz. The quick brown fox jumps over the lazy dog. ";
    volatile Throwable serverException;
    volatile long received = 0L;

    private UnixSocketAddress makeAddress() throws IOException {
        File socketFile = Files.createTempFile("jnr-unixsocket-test", ".sock", new FileAttribute[0]).toFile();
        socketFile.delete();
        socketFile.deleteOnExit();
        return new UnixSocketAddress(socketFile);
    }

    private void basicOperation(long minBytesToSend) throws Throwable {
        long written;
        this.serverException = null;
        final StringBuffer rxdata = new StringBuffer();
        StringBuffer txdata = new StringBuffer();
        final ByteBuffer rxbuf = ByteBuffer.allocate(1024);
        ByteBuffer txbuf = ByteBuffer.allocate(2024);
        final UnixSocketAddress serverAddress = this.makeAddress();
        Thread serverThread = new Thread("server side"){
            final UnixDatagramChannel serverChannel;
            {
                super(x0);
                this.serverChannel = UnixDatagramChannel.open().bind((SocketAddress)serverAddress);
            }

            @Override
            public void run() {
                while (null == BasicDatagramFunctionalityTest.this.serverException) {
                    try {
                        rxbuf.clear();
                        this.serverChannel.receive(rxbuf);
                        rxbuf.flip();
                        int count = rxbuf.limit();
                        rxdata.append(StandardCharsets.UTF_8.decode(rxbuf).toString());
                        BasicDatagramFunctionalityTest.this.received += (long)count;
                    }
                    catch (IOException ex) {
                        BasicDatagramFunctionalityTest.this.serverException = ex;
                    }
                }
            }
        };
        serverThread.start();
        UnixDatagramChannel clientChannel = UnixDatagramChannel.open();
        this.received = 0L;
        for (written = 0L; null == this.serverException && written < minBytesToSend; written += (long)clientChannel.send(txbuf, (SocketAddress)serverAddress)) {
            txbuf.put(StandardCharsets.UTF_8.encode(DATA));
            txbuf.flip();
            txbuf.compact();
            txdata.append(DATA);
            if (null == this.serverException) continue;
            throw new Exception().initCause(this.serverException);
        }
        clientChannel.close();
        while (null == this.serverException && this.received < written) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)"More than 0 bytes written", (written > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"received", (long)written, (long)this.received);
        Assert.assertEquals((String)"received data", (String)txdata.toString(), (String)rxdata.toString());
    }

    @Test
    public void smallBasicOperationTest() throws Throwable {
        this.basicOperation(DATA.length());
    }

    @Test
    public void largeBasicOperationTest() throws Throwable {
        Assume.assumeTrue((Platform.OS.LINUX == Platform.getNativePlatform().getOS() ? 1 : 0) != 0);
        this.basicOperation(1000L * (long)DATA.length());
    }

    @Test
    public void doubleBindTest() throws Exception {
        UnixDatagramChannel ch = UnixDatagramChannel.open().bind(null);
        try {
            ch.bind(null);
            Assert.fail((String)"Should have thrown AlreadyBoundException");
        }
        catch (AlreadyBoundException abx) {
            try {
                ch.socket().bind(null);
                Assert.fail((String)"Should have thrown SocketException");
            }
            catch (SocketException sx) {
                Assert.assertEquals((String)"exception message", (String)sx.getMessage(), (String)"already bound");
            }
        }
    }

    @Test
    public void pairTest() throws Exception {
        UnixDatagramChannel[] sp;
        for (UnixDatagramChannel ch : sp = UnixDatagramChannel.pair()) {
            Assert.assertTrue((String)"Channel is connected", (boolean)ch.isConnected());
            Assert.assertTrue((String)"Channel is bound", (boolean)ch.isBound());
            Assert.assertFalse((String)"Channel's socket is not closed", (boolean)ch.socket().isClosed());
        }
    }
}

