/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import jnr.ffi.Platform;
import jnr.unixsocket.Credentials;
import jnr.unixsocket.UnixDatagramChannel;
import jnr.unixsocket.UnixSocketChannel;
import jnr.unixsocket.UnixSocketOptions;
import junit.framework.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ChannelOptionsTest {
    @Test
    public void readonlyDatagramChannelOptionTest() throws Exception {
        Assume.assumeTrue((Platform.OS.LINUX == Platform.getNativePlatform().getOS() ? 1 : 0) != 0);
        UnixDatagramChannel[] sp = UnixDatagramChannel.pair();
        UnixDatagramChannel ch = sp[0];
        Credentials c = ch.socket().getCredentials();
        try {
            ch.setOption(UnixSocketOptions.SO_PEERCRED, (Object)c);
            Assert.fail((String)"Should have thrown AssertionError");
        }
        catch (AssertionError ae) {
            Assert.assertEquals((String)"exception message", (String)((Throwable)((Object)ae)).getMessage(), (String)"Option not found or not writable");
        }
    }

    @Test
    public void readonlySocketChannelOptionTest() throws Exception {
        Assume.assumeTrue((Platform.OS.LINUX == Platform.getNativePlatform().getOS() ? 1 : 0) != 0);
        UnixSocketChannel[] sp = UnixSocketChannel.pair();
        UnixSocketChannel ch = sp[0];
        Credentials c = ch.socket().getCredentials();
        try {
            ch.setOption(UnixSocketOptions.SO_PEERCRED, (Object)c);
            Assert.fail((String)"Should have thrown AssertionError");
        }
        catch (AssertionError ae) {
            Assert.assertEquals((String)"exception message", (String)((Throwable)((Object)ae)).getMessage(), (String)"Option not found or not writable");
        }
    }

    @Test
    public void unsupportedChannelOptionTest() throws Exception {
        UnixDatagramChannel ch = UnixDatagramChannel.open();
        try {
            ch.getOption(UnixSocketOptions.SO_KEEPALIVE);
            Assert.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException uoe) {
            Assert.assertEquals((String)"exception message", (String)uoe.getMessage(), (String)"'SO_KEEPALIVE' not supported");
        }
    }

    @Test
    public void keepaliveOptionTest() throws Exception {
        UnixSocketChannel ch = UnixSocketChannel.open();
        boolean origValue = (Boolean)ch.getOption(UnixSocketOptions.SO_KEEPALIVE);
        Assert.assertEquals((String)"Initial value of SO_KEEPALIVE", (boolean)origValue, (boolean)false);
        ch.setOption(UnixSocketOptions.SO_KEEPALIVE, (Object)Boolean.TRUE);
        boolean changedValue = (Boolean)ch.getOption(UnixSocketOptions.SO_KEEPALIVE);
        Assert.assertEquals((String)"Changed value of SO_KEEPALIVE", (boolean)changedValue, (boolean)true);
        ch.setOption(UnixSocketOptions.SO_KEEPALIVE, (Object)Boolean.FALSE);
        changedValue = (Boolean)ch.getOption(UnixSocketOptions.SO_KEEPALIVE);
        Assert.assertEquals((String)"Changed value of SO_KEEPALIVE", (boolean)changedValue, (boolean)origValue);
    }

    @Test
    public void invalidOptionValueTest() throws Exception {
        UnixSocketChannel ch = UnixSocketChannel.open();
        try {
            ch.setOption(UnixSocketOptions.SO_RCVTIMEO, (Object)-1);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertEquals((String)"exception message", (String)iae.getMessage(), (String)"Invalid send/receive timeout");
        }
        try {
            ch.setOption(UnixSocketOptions.SO_SNDTIMEO, (Object)-1);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertEquals((String)"exception message", (String)iae.getMessage(), (String)"Invalid send/receive timeout");
        }
        try {
            ch.setOption(UnixSocketOptions.SO_RCVBUF, (Object)-1);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertEquals((String)"exception message", (String)iae.getMessage(), (String)"Invalid send/receive buffer size");
        }
        try {
            ch.setOption(UnixSocketOptions.SO_SNDBUF, (Object)-1);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertEquals((String)"exception message", (String)iae.getMessage(), (String)"Invalid send/receive buffer size");
        }
    }

    @Test
    public void socketBufferTest() throws Exception {
        UnixDatagramChannel ch = UnixDatagramChannel.open();
        int rxs = (Integer)ch.getOption(UnixSocketOptions.SO_RCVBUF);
        int txs = (Integer)ch.getOption(UnixSocketOptions.SO_SNDBUF);
        Assert.assertTrue((String)"receive buffer size >= 256", (rxs >= 256 ? 1 : 0) != 0);
        Assert.assertTrue((String)"send buffer size >= 256", (txs >= 256 ? 1 : 0) != 0);
    }
}

