/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.File;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.unixsocket.Native;
import jnr.unixsocket.SockAddrUnix;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import junit.framework.Assert;
import org.junit.Test;

public class ForFDTest {
    private static final File SOCKADDR = new File("/tmp/jnr-unixsocket-forfd" + System.currentTimeMillis() + ".sock");
    private static final UnixSocketAddress ADDRESS;
    private static final String FOOBAR = "foobar";
    private volatile Exception serverException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForFD() throws Exception {
        int fd = 0;
        try (UnixSocketChannel channel = null;){
            final UnixServerSocketChannel server = UnixServerSocketChannel.open();
            server.socket().bind((SocketAddress)ADDRESS);
            new Thread("accept thread"){

                @Override
                public void run() {
                    UnixSocketChannel channel = null;
                    try {
                        channel = server.accept();
                        channel.write(ByteBuffer.wrap(ForFDTest.FOOBAR.getBytes(StandardCharsets.UTF_8)));
                    }
                    catch (Exception e) {
                        ForFDTest.this.serverException = e;
                    }
                    finally {
                        try {
                            channel.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }.start();
            fd = Native.socket((ProtocolFamily)ProtocolFamily.PF_UNIX, (Sock)Sock.SOCK_STREAM, (int)0);
            Assert.assertTrue((String)"socket failed", (fd > 0 ? 1 : 0) != 0);
            int ret = Native.connect((int)fd, (SockAddrUnix)ADDRESS.getStruct(), (int)ADDRESS.getStruct().length());
            Assert.assertTrue((String)"connect failed", (ret >= 0 ? 1 : 0) != 0);
            channel = UnixSocketChannel.fromFD((int)fd);
            Assert.assertNotNull((Object)channel);
            ByteBuffer buf = ByteBuffer.allocate(1024);
            channel.read(buf);
            Assert.assertEquals((int)FOOBAR.length(), (int)buf.position());
            buf.flip();
            String result = new String(buf.array(), buf.position(), buf.limit(), "UTF-8");
            Assert.assertEquals((String)FOOBAR, (String)result);
            if (this.serverException != null) {
                throw this.serverException;
            }
        }
    }

    static {
        SOCKADDR.deleteOnExit();
        ADDRESS = new UnixSocketAddress(SOCKADDR);
    }
}

