/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jnr.unixsocket.TcpChannelsApiSocketPair;
import jnr.unixsocket.TcpSocketsApiSocketPair;
import jnr.unixsocket.TestSocketPair;
import jnr.unixsocket.UnixSocketPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SocketInteropTest {
    @Rule
    public Timeout timeout = new Timeout(5L, TimeUnit.SECONDS);
    @Parameterized.Parameter
    public TestSocketPair.Factory socketPairFactory;
    private TestSocketPair socketPair;

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> parameters() {
        return Arrays.asList({UnixSocketPair.FACTORY}, {TcpSocketsApiSocketPair.FACTORY}, {TcpChannelsApiSocketPair.FACTORY});
    }

    @Before
    public void setUp() throws Exception {
        this.socketPair = this.socketPairFactory.createUnconnected();
    }

    @After
    public void tearDown() throws Exception {
        this.socketPair.close();
    }

    @Test
    public void serverWritesAndClientReads() throws IOException {
        this.socketPair.connectBlocking();
        OutputStream serverOut = this.socketPair.server().getOutputStream();
        serverOut.write("message from server to client\n".getBytes(StandardCharsets.UTF_8));
        serverOut.flush();
        InputStream clientIn = this.socketPair.client().getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(clientIn, StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"message from server to client", (Object)reader.readLine());
    }

    @Test
    public void clientWritesAndServerReads() throws IOException {
        this.socketPair.connectBlocking();
        OutputStream clientOut = this.socketPair.client().getOutputStream();
        clientOut.write("message from client to server\n".getBytes(StandardCharsets.UTF_8));
        clientOut.flush();
        InputStream serverIn = this.socketPair.server().getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(serverIn, StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"message from client to server", (Object)reader.readLine());
    }

    @Test
    public void acceptThrowsWhenServerSocketIsNotYetBound() throws IOException {
        try {
            this.socketPair.serverAccept();
            Assert.fail();
        }
        catch (NotYetBoundException notYetBoundException) {
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Test
    public void acceptThrowsWhenServerSocketIsClosed() throws IOException {
        this.socketPair.serverBind();
        this.socketPair.close();
        try {
            this.socketPair.serverAccept();
            Assert.fail();
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Test
    public void acceptThrowsWhenServerSocketIsAsynchronouslyClosed() throws IOException {
        this.socketPair.serverBind();
        this.closeLater(this.socketPair, 500L, TimeUnit.MILLISECONDS);
        try {
            this.socketPair.serverAccept();
            Assert.fail();
        }
        catch (AsynchronousCloseException asynchronousCloseException) {
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    private void closeLater(final Closeable closeable, final long delay, final TimeUnit timeUnit) {
        new Thread(this.getClass().getName() + ".closeLater"){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeUnit.toMillis(delay));
                    closeable.close();
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    @Test
    public void acceptThrowsWhenAcceptingThreadIsInterrupted() throws IOException {
        Assume.assumeTrue((String)"the TCP sockets API doesn't support Thread.interrupt()", (this.socketPairFactory != TcpSocketsApiSocketPair.FACTORY ? 1 : 0) != 0);
        this.socketPair.serverBind();
        this.interruptLater(Thread.currentThread(), 500L, TimeUnit.MILLISECONDS);
        try {
            this.socketPair.serverAccept();
            Assert.fail();
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)Thread.interrupted());
    }

    private void interruptLater(final Thread target, final long delay, final TimeUnit timeUnit) {
        new Thread(this.getClass().getName() + ".interruptLater"){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeUnit.toMillis(delay));
                    target.interrupt();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    @Test
    public void concurrentReadAndWrite() throws IOException {
        Assume.assumeTrue((String)"the TCP channels API doesn't support concurrent read and write", (this.socketPairFactory != TcpChannelsApiSocketPair.FACTORY ? 1 : 0) != 0);
        this.socketPair.connectBlocking();
        new Thread(this.getClass().getName() + ".concurrentReadAndWrite"){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                    OutputStream clientOut = SocketInteropTest.this.socketPair.client().getOutputStream();
                    clientOut.write("message from client to server\n".getBytes(StandardCharsets.UTF_8));
                    clientOut.flush();
                    OutputStream serverOut = SocketInteropTest.this.socketPair.server().getOutputStream();
                    serverOut.write("message from server to client\n".getBytes(StandardCharsets.UTF_8));
                    serverOut.flush();
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            }
        }.start();
        InputStream clientIn = this.socketPair.client().getInputStream();
        BufferedReader clientReader = new BufferedReader(new InputStreamReader(clientIn, StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"message from server to client", (Object)clientReader.readLine());
        InputStream serverIn = this.socketPair.server().getInputStream();
        BufferedReader serverReader = new BufferedReader(new InputStreamReader(serverIn, StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"message from client to server", (Object)serverReader.readLine());
    }
}

