/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import jnr.unixsocket.TestSocketPair;

class TcpSocketsApiSocketPair
extends TestSocketPair {
    static final TestSocketPair.Factory FACTORY = new TestSocketPair.Factory(){

        @Override
        TestSocketPair createUnconnected() throws IOException {
            return new TcpSocketsApiSocketPair();
        }
    };
    private final ServerSocket serverSocket = new ServerSocket();
    private InetSocketAddress serverAddress;
    private Socket server;
    private Socket client;

    @Override
    void serverBind() throws IOException {
        if (this.serverAddress != null) {
            throw new IllegalStateException("already bound");
        }
        this.serverSocket.setReuseAddress(true);
        this.serverSocket.bind(new InetSocketAddress(0));
        this.serverAddress = new InetSocketAddress(this.serverSocket.getInetAddress(), this.serverSocket.getLocalPort());
    }

    @Override
    void clientConnect() throws IOException {
        if (this.client != null) {
            throw new IllegalStateException("already connected");
        }
        this.client = new Socket();
        this.client.connect(this.serverAddress);
    }

    @Override
    void serverAccept() throws IOException {
        if (this.server != null) {
            throw new IllegalStateException("already accepted");
        }
        this.server = this.serverSocket.accept();
    }

    @Override
    SocketAddress socketAddress() {
        return this.serverAddress;
    }

    @Override
    Socket server() {
        return this.server;
    }

    @Override
    Socket client() {
        return this.client;
    }

    @Override
    public void close() throws IOException {
        this.closeQuietly(this.serverSocket);
        this.closeQuietly(this.server);
        this.closeQuietly(this.client);
    }
}

