/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.net.SocketAddress;
import jnr.ffi.Platform;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import junit.framework.Assert;
import org.junit.Assume;
import org.junit.Test;

public class UnixSocketChannelTest {
    @Test
    public void testForUnnamedSockets() throws Exception {
        UnixSocketChannel[] sp = UnixSocketChannel.pair();
        Assert.assertEquals((String)"remote socket path", (String)"", (String)sp[0].getRemoteSocketAddress().path());
        Assert.assertEquals((String)"remote socket path", (String)"", (String)sp[1].getRemoteSocketAddress().path());
        Assert.assertEquals((String)"local socket path", (String)"", (String)sp[0].getLocalSocketAddress().path());
        Assert.assertEquals((String)"local socket path", (String)"", (String)sp[1].getLocalSocketAddress().path());
    }

    @Test
    public void testAutobind() throws Exception {
        Assume.assumeTrue((Platform.OS.LINUX == Platform.getNativePlatform().getOS() ? 1 : 0) != 0);
        String RE = "^\\000([0-9a-f]){5}$";
        UnixSocketChannel ch = UnixSocketChannel.open();
        ch.bind(null);
        UnixSocketAddress a = ch.getLocalSocketAddress();
        Assert.assertTrue((String)"socket path pattern matches ^\\000([0-9a-f]){5}$", (boolean)a.path().matches("^\\000([0-9a-f]){5}$"));
    }

    @Test
    public void testAbstractNamespace() throws Exception {
        Assume.assumeTrue((Platform.OS.LINUX == Platform.getNativePlatform().getOS() ? 1 : 0) != 0);
        String ABSTRACT = "\u0000foobarbaz";
        UnixSocketAddress a = new UnixSocketAddress("\u0000foobarbaz");
        UnixSocketChannel ch = UnixSocketChannel.open();
        ch.bind((SocketAddress)a);
        Assert.assertEquals((String)"local socket path", (String)"\u0000foobarbaz", (String)ch.getLocalSocketAddress().path());
    }
}

