/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket.example;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import jnr.ffi.Platform;
import jnr.unixsocket.UnixDatagramChannel;
import jnr.unixsocket.UnixSocketAddress;

public class LocalSyslogClient {
    private StringBuffer line = new StringBuffer();
    private SimpleDateFormat sdf = new SimpleDateFormat("MMM dd HH:mm:ss", Locale.US);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatDate() {
        LocalSyslogClient localSyslogClient = this;
        synchronized (localSyslogClient) {
            return this.sdf.format(new Date());
        }
    }

    private void formatLine(int pri, String tag, int pid, String[] args) {
        this.line.setLength(0);
        this.line.append(String.format("<%d>", pri)).append(this.formatDate()).append(" ").append(tag);
        if (0 < pid) {
            this.line.append(String.format("[%d]", pid));
        }
        this.line.append(":");
        for (String arg : args) {
            this.line.append(" ").append(arg);
        }
    }

    private int makePri(Priority priority, Facility facility) {
        return priority.ordinal() | facility.getValue();
    }

    private String getSocketPath() {
        if (Platform.getNativePlatform().getOS() == Platform.OS.DARWIN) {
            return "/var/run/syslog";
        }
        return "/dev/log";
    }

    private int getPid() {
        String[] nameParts = ManagementFactory.getRuntimeMXBean().getName().split("@", 2);
        if (2 == nameParts.length) {
            return Integer.parseInt(nameParts[0]);
        }
        return 0;
    }

    private void doit(String[] args) throws IOException, InterruptedException {
        File path = new File(this.getSocketPath());
        if (!path.exists()) {
            throw new IOException(String.format("%s does not exist", path.getAbsolutePath()));
        }
        UnixSocketAddress address = new UnixSocketAddress(path);
        UnixDatagramChannel channel = UnixDatagramChannel.open();
        int pri = this.makePri(Priority.LOG_WARNING, Facility.LOG_DAEMON);
        int pid = this.getPid();
        String tag = "whatever";
        if (args.length > 0) {
            this.formatLine(pri, tag, pid, args);
            ByteBuffer buf = ByteBuffer.wrap(this.line.toString().getBytes(StandardCharsets.UTF_8));
            channel.send(buf, (SocketAddress)address);
        } else {
            this.formatLine(pri, tag, pid, new String[]{"The quick brown fox jumps\nover the lazy dog"});
            ByteBuffer buf = ByteBuffer.wrap(this.line.toString().getBytes(StandardCharsets.UTF_8));
            channel.send(buf, (SocketAddress)address);
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        LocalSyslogClient client = new LocalSyslogClient();
        client.doit(args);
    }

    private static enum Facility {
        LOG_KERN(0),
        LOG_USER(8),
        LOG_MAIL(16),
        LOG_DAEMON(24),
        LOG_AUTH(32),
        LOG_SYSLOG(40),
        LOG_LPR(48),
        LOG_NEWS(56),
        LOG_UUCP(64),
        LOG_CRON(72),
        LOG_AUTHPRIV(80),
        LOG_FTP(88),
        LOG_LOCAL0(128),
        LOG_LOCAL1(136),
        LOG_LOCAL2(144),
        LOG_LOCAL3(152),
        LOG_LOCAL4(160),
        LOG_LOCAL5(168),
        LOG_LOCAL6(176),
        LOG_LOCAL7(184);

        private int myValue;

        private Facility(int value) {
            this.myValue = value;
        }

        public int getValue() {
            return this.myValue;
        }
    }

    private static enum Priority {
        LOG_EMERG,
        LOG_ALERT,
        LOG_CRIT,
        LOG_ERR,
        LOG_WARNING,
        LOG_NOTICE,
        LOG_INFO,
        LOG_DEBUG;

    }
}

