/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import jnr.enxio.channels.NativeSelectorProvider;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import jnr.unixsocket.UnixSocketPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicFunctionalityTest {
    private static final String DATA = "blah blah";
    private UnixSocketPair socketPair;
    private Thread server;
    private volatile Exception serverException;

    @Before
    public void setUp() throws Exception {
        this.socketPair = new UnixSocketPair();
    }

    @After
    public void tearDown() throws Exception {
        this.socketPair.close();
    }

    @Test
    public void doubleBindTest() throws Exception {
        UnixSocketChannel ch = UnixSocketChannel.open().bind(null);
        try {
            ch.bind(null);
            Assert.fail((String)"Should have thrown AlreadyBoundException");
        }
        catch (AlreadyBoundException abx) {
            try {
                ch.socket().bind(null);
                Assert.fail((String)"Should have thrown SocketException");
            }
            catch (SocketException sx) {
                Assert.assertEquals((String)"exception message", (Object)sx.getMessage(), (Object)"already bound");
            }
        }
    }

    @Test
    public void pairTest() throws Exception {
        UnixSocketChannel[] sp;
        for (UnixSocketChannel ch : sp = UnixSocketChannel.pair()) {
            Assert.assertTrue((String)"Channel is connected", (boolean)ch.isConnected());
            Assert.assertTrue((String)"Channel is bound", (boolean)ch.isBound());
            Assert.assertFalse((String)"Channel's socket is not closed", (boolean)ch.socket().isClosed());
        }
    }

    @Test
    public void basicOperation() throws Exception {
        UnixServerSocketChannel channel = UnixServerSocketChannel.open();
        final AbstractSelector sel = NativeSelectorProvider.getInstance().openSelector();
        channel.configureBlocking(false);
        channel.socket().bind((SocketAddress)this.socketPair.socketAddress());
        channel.register((Selector)sel, 16, (Object)new ServerActor(channel, sel));
        this.server = new Thread("server side"){

            @Override
            public void run() {
                try {
                    while (sel.select() > 0) {
                        Set<SelectionKey> keys = sel.selectedKeys();
                        Assert.assertNotNull(keys);
                        Assert.assertTrue((keys.size() > 0 ? 1 : 0) != 0);
                        for (SelectionKey k : keys) {
                            Assert.assertTrue((boolean)(k.attachment() instanceof Actor));
                            Actor a = (Actor)k.attachment();
                            if (a.rxready()) continue;
                            k.cancel();
                        }
                    }
                }
                catch (Exception ex) {
                    BasicFunctionalityTest.this.serverException = ex;
                }
            }
        };
        this.server.start();
        UnixSocketChannel channel2 = UnixSocketChannel.open((UnixSocketAddress)this.socketPair.socketAddress());
        Assert.assertEquals((Object)this.socketPair.socketAddress(), (Object)channel2.getRemoteSocketAddress());
        Channels.newOutputStream((WritableByteChannel)channel2).write(DATA.getBytes(StandardCharsets.UTF_8));
        InputStreamReader r = new InputStreamReader(Channels.newInputStream((ReadableByteChannel)channel2), StandardCharsets.UTF_8);
        CharBuffer result = CharBuffer.allocate(1024);
        r.read(result);
        Assert.assertEquals((long)DATA.length(), (long)result.position());
        result.flip();
        Assert.assertEquals((Object)DATA, (Object)result.toString());
        if (this.serverException != null) {
            throw this.serverException;
        }
    }

    final class ClientActor
    implements Actor {
        private final UnixSocketChannel channel;

        public ClientActor(UnixSocketChannel channel) {
            this.channel = channel;
        }

        @Override
        public final boolean rxready() {
            try {
                ByteBuffer buf = ByteBuffer.allocate(1024);
                int n = this.channel.read(buf);
                Assert.assertEquals((Object)"", (Object)this.channel.getRemoteSocketAddress().getStruct().getPath());
                Assert.assertEquals((long)BasicFunctionalityTest.DATA.length(), (long)n);
                if (n > 0) {
                    buf.flip();
                    this.channel.write(buf);
                    return true;
                }
                if (n < 0) {
                    return false;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
            return true;
        }
    }

    final class ServerActor
    implements Actor {
        private final UnixServerSocketChannel channel;
        private final Selector selector;

        public ServerActor(UnixServerSocketChannel channel, Selector selector) {
            this.channel = channel;
            this.selector = selector;
        }

        @Override
        public final boolean rxready() {
            try {
                UnixSocketChannel client = this.channel.accept();
                if (client == null) {
                    return false;
                }
                Assert.assertEquals((Object)BasicFunctionalityTest.this.socketPair.socketAddress(), (Object)client.getLocalSocketAddress());
                Assert.assertEquals((Object)"", (Object)client.getRemoteSocketAddress().getStruct().getPath());
                client.configureBlocking(false);
                client.register(this.selector, 1, (Object)new ClientActor(client));
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
    }

    static interface Actor {
        public boolean rxready();
    }
}

