/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.SocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jnr.ffi.Platform;
import jnr.unixsocket.Credentials;
import jnr.unixsocket.UnixServerSocket;
import jnr.unixsocket.UnixSocket;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import jnr.unixsocket.UnixSocketOptions;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CredentialsFunctionalTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private File serverSocket;
    private ExecutorService async = Executors.newSingleThreadExecutor();

    @Before
    public void createSockets() throws IOException {
        Assume.assumeTrue((Platform.OS.LINUX == Platform.getNativePlatform().getOS() ? 1 : 0) != 0);
        this.serverSocket = this.tempFolder.newFile("serverSocket");
        this.serverSocket.delete();
    }

    @Test(timeout=30000L)
    public void credentials() throws IOException, ExecutionException, InterruptedException {
        UnixSocketAddress address = new UnixSocketAddress(this.serverSocket);
        final UnixServerSocket socket = new UnixServerSocket();
        socket.bind((SocketAddress)address);
        Future<UnixSocket> socketFuture = this.async.submit(new Callable<UnixSocket>(){

            @Override
            public UnixSocket call() throws Exception {
                return socket.accept();
            }
        });
        UnixSocketChannel client = UnixSocketChannel.open((UnixSocketAddress)address);
        UnixSocket server = socketFuture.get();
        Assert.assertNotNull((String)"Client socket must be non-null.", (Object)client);
        Assert.assertNotNull((String)"Server socket must be non-null.", (Object)server);
        Credentials clientCreds = client.socket().getCredentials();
        Credentials serverCreds = server.getCredentials();
        int myPid = this.getCurrentPid();
        Assert.assertEquals((String)"Current PID should match client credentials", (long)myPid, (long)clientCreds.getPid());
        Assert.assertEquals((String)"Current PID should match server credentials", (long)myPid, (long)serverCreds.getPid());
        Assert.assertEquals((String)"Client/server running in same process, UID should be the same", (long)clientCreds.getUid(), (long)serverCreds.getUid());
        Assert.assertEquals((String)"Client/server running in same process, GID should be the same", (long)clientCreds.getGid(), (long)serverCreds.getGid());
        Credentials newCreds = (Credentials)client.getOption(UnixSocketOptions.SO_PEERCRED);
        Assert.assertNotNull((Object)newCreds);
        Assert.assertEquals((String)"Current PID should match new API PID", (long)myPid, (long)newCreds.getPid());
        Assert.assertEquals((String)"old/new API results (UID) should be the same", (long)clientCreds.getUid(), (long)newCreds.getUid());
        Assert.assertEquals((String)"old/new API results (GID) should be the same", (long)clientCreds.getGid(), (long)newCreds.getGid());
    }

    public int getCurrentPid() {
        String[] nameParts = ManagementFactory.getRuntimeMXBean().getName().split("@", 2);
        Assert.assertEquals((String)"Cannot determine PID", (long)2L, (long)nameParts.length);
        return Integer.parseInt(nameParts[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLoginUid() throws IOException {
        StringBuilder uidText = new StringBuilder();
        try (InputStreamReader fr = null;){
            fr = new FileReader("/proc/self/loginuid");
            char[] buf = new char[16];
            int read = -1;
            while ((read = fr.read(buf)) > -1) {
                uidText.append(buf, 0, read);
            }
        }
        return Integer.parseInt(uidText.toString());
    }
}

