/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import jnr.unixsocket.TestSocketPair;

class TcpChannelsApiSocketPair
extends TestSocketPair {
    static final TestSocketPair.Factory FACTORY = new TestSocketPair.Factory(){

        @Override
        TestSocketPair createUnconnected() throws IOException {
            return new TcpChannelsApiSocketPair();
        }
    };
    private final ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
    private InetSocketAddress serverAddress;
    private SocketChannel serverChannel;
    private SocketChannel clientChannel;

    TcpChannelsApiSocketPair() throws IOException {
    }

    @Override
    void serverBind() throws IOException {
        if (this.serverAddress != null) {
            throw new IllegalStateException("already bound");
        }
        ServerSocket serverSocket = this.serverSocketChannel.socket();
        serverSocket.setReuseAddress(true);
        this.serverSocketChannel.bind(new InetSocketAddress(0));
        this.serverSocketChannel.configureBlocking(true);
        this.serverAddress = new InetSocketAddress(serverSocket.getInetAddress(), serverSocket.getLocalPort());
    }

    @Override
    void clientConnect() throws IOException {
        if (this.clientChannel != null) {
            throw new IllegalStateException("already connected");
        }
        this.clientChannel = SocketChannel.open();
        this.clientChannel.connect(this.serverAddress);
    }

    @Override
    void serverAccept() throws IOException {
        if (this.serverChannel != null) {
            throw new IllegalStateException("already accepted");
        }
        this.serverChannel = this.serverSocketChannel.accept();
    }

    @Override
    SocketAddress socketAddress() {
        return this.serverAddress;
    }

    @Override
    Socket server() {
        return this.serverChannel.socket();
    }

    @Override
    Socket client() {
        return this.clientChannel.socket();
    }

    @Override
    public void close() throws IOException {
        this.closeQuietly(this.serverSocketChannel);
        this.closeQuietly(this.serverChannel);
        this.closeQuietly(this.clientChannel);
    }
}

