/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.File;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import jnr.ffi.Platform;
import jnr.unixsocket.UnixDatagramChannel;
import jnr.unixsocket.UnixSocketAddress;
import junit.framework.Assert;
import org.junit.Assume;
import org.junit.Test;

public class UnixDatagramChannelTest {
    @Test
    public void testForUnnamedSockets() throws Exception {
        UnixDatagramChannel[] sp = UnixDatagramChannel.pair();
        Assert.assertEquals((String)"remote socket path", (String)"", (String)sp[0].getRemoteSocketAddress().path());
        Assert.assertEquals((String)"remote socket path", (String)"", (String)sp[1].getRemoteSocketAddress().path());
        Assert.assertEquals((String)"local socket path", (String)"", (String)sp[0].getLocalSocketAddress().path());
        Assert.assertEquals((String)"local socket path", (String)"", (String)sp[1].getLocalSocketAddress().path());
    }

    @Test
    public void testAutobind() throws Exception {
        Assume.assumeTrue((Platform.OS.LINUX == Platform.getNativePlatform().getOS() ? 1 : 0) != 0);
        String RE = "^\\000([0-9a-f]){5}$";
        UnixDatagramChannel ch = UnixDatagramChannel.open();
        ch.bind(null);
        UnixSocketAddress a = ch.getLocalSocketAddress();
        Assert.assertTrue((String)"socket path pattern matches ^\\000([0-9a-f]){5}$", (boolean)a.path().matches("^\\000([0-9a-f]){5}$"));
    }

    @Test
    public void testAutobindEmulation() throws Exception {
        Assume.assumeTrue((Platform.OS.LINUX != Platform.getNativePlatform().getOS() ? 1 : 0) != 0);
        File f = Files.createTempFile("jnr-unixsocket-tmp", ".end", new FileAttribute[0]).toFile();
        f.delete();
        String path = f.getPath().replaceAll("-tmp.*\\.end", "-tmp");
        String RE = "^" + Pattern.quote(path) + ".*\\.sock$";
        UnixDatagramChannel ch = UnixDatagramChannel.open();
        ch.bind(null);
        UnixSocketAddress a = ch.getLocalSocketAddress();
        Assert.assertTrue((String)("socket path pattern matches " + RE), (boolean)a.path().matches(RE));
    }

    @Test
    public void testAbstractNamespace() throws Exception {
        Assume.assumeTrue((Platform.OS.LINUX == Platform.getNativePlatform().getOS() ? 1 : 0) != 0);
        String ABSTRACT = "\u0000foobarbaz";
        UnixSocketAddress a = new UnixSocketAddress("\u0000foobarbaz");
        UnixDatagramChannel ch = UnixDatagramChannel.open();
        ch.bind((SocketAddress)a);
        Assert.assertEquals((String)"local socket path", (String)"\u0000foobarbaz", (String)ch.getLocalSocketAddress().path());
    }
}

