/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CountDownLatch;
import jnr.ffi.Platform;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocket;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import junit.framework.Assert;
import org.junit.Assume;
import org.junit.Test;

public class UnixSocketChannelTest {
    @Test
    public void testForUnnamedSockets() throws Exception {
        UnixSocketChannel[] sp = UnixSocketChannel.pair();
        Assert.assertEquals((String)"remote socket path", (String)"", (String)sp[0].getRemoteSocketAddress().path());
        Assert.assertEquals((String)"remote socket path", (String)"", (String)sp[1].getRemoteSocketAddress().path());
        Assert.assertEquals((String)"local socket path", (String)"", (String)sp[0].getLocalSocketAddress().path());
        Assert.assertEquals((String)"local socket path", (String)"", (String)sp[1].getLocalSocketAddress().path());
    }

    @Test
    public void testAutobind() throws Exception {
        Assume.assumeTrue((Platform.OS.LINUX == Platform.getNativePlatform().getOS() ? 1 : 0) != 0);
        String RE = "^\\000([0-9a-f]){5}$";
        UnixSocketChannel ch = UnixSocketChannel.open();
        ch.bind(null);
        UnixSocketAddress a = ch.getLocalSocketAddress();
        Assert.assertTrue((String)"socket path pattern matches ^\\000([0-9a-f]){5}$", (boolean)a.path().matches("^\\000([0-9a-f]){5}$"));
    }

    @Test
    public void testAbstractNamespace() throws Exception {
        Assume.assumeTrue((Platform.OS.LINUX == Platform.getNativePlatform().getOS() ? 1 : 0) != 0);
        String ABSTRACT = "\u0000foobarbaz";
        UnixSocketAddress a = new UnixSocketAddress("\u0000foobarbaz");
        UnixSocketChannel ch = UnixSocketChannel.open();
        ch.bind((SocketAddress)a);
        Assert.assertEquals((String)"local socket path", (String)"\u0000foobarbaz", (String)ch.getLocalSocketAddress().path());
    }

    @Test
    public void testInterruptRead() throws Exception {
        Path socketPath = this.getTemporarySocketFileName();
        this.startServer(socketPath);
        int readTimeoutInMilliseconds = 5000;
        UnixSocket socket = this.createClient(socketPath, readTimeoutInMilliseconds);
        CountDownLatch readStartLatch = new CountDownLatch(1);
        ReadFromSocketRunnable runnable = new ReadFromSocketRunnable(readStartLatch, socket);
        Thread readThread = new Thread(runnable);
        readThread.setDaemon(true);
        long startTime = System.nanoTime();
        readThread.start();
        readStartLatch.await();
        Thread.sleep(100L);
        socket.close();
        readThread.join();
        long stopTime = System.nanoTime();
        long duration = stopTime - startTime;
        long durationInMilliseconds = duration / 1000000L;
        Assert.assertTrue((String)"read() was not interrupted by close() before read() timed out", (durationInMilliseconds < (long)readTimeoutInMilliseconds ? 1 : 0) != 0);
        Assert.assertEquals((String)"read() threw an exception", null, (Object)runnable.getThrownOnThread());
    }

    private Path getTemporarySocketFileName() throws IOException {
        Path socketPath = Files.createTempFile("jnr-unixsocket-tests", ".sock", new FileAttribute[0]);
        Files.delete(socketPath);
        socketPath.toFile().deleteOnExit();
        return socketPath;
    }

    private void startServer(Path socketPath) throws IOException {
        UnixServerSocketChannel serverChannel = UnixServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        serverChannel.socket().bind((SocketAddress)new UnixSocketAddress(socketPath.toFile()));
    }

    private UnixSocket createClient(Path socketPath, int readTimeoutInMilliseconds) throws IOException {
        UnixSocketChannel clientChannel = UnixSocketChannel.open((UnixSocketAddress)new UnixSocketAddress(socketPath.toFile()));
        UnixSocket socket = new UnixSocket(clientChannel);
        socket.setSoTimeout(readTimeoutInMilliseconds);
        return socket;
    }

    private class ReadFromSocketRunnable
    implements Runnable {
        private CountDownLatch readStartLatch;
        private UnixSocket socket;
        private IOException thrownOnThread;

        private ReadFromSocketRunnable(CountDownLatch readStartLatch, UnixSocket socket) {
            this.readStartLatch = readStartLatch;
            this.socket = socket;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.readStartLatch.countDown();
                    this.socket.getInputStream().read();
                }
                catch (IOException e) {
                    if (e.getMessage().equals("Bad file descriptor")) break block2;
                    this.thrownOnThread = e;
                }
            }
        }

        private IOException getThrownOnThread() {
            return this.thrownOnThread;
        }
    }
}

