/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.UUID;
import jnr.unixsocket.TestSocketPair;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

class UnixSocketPair
extends TestSocketPair {
    static final TestSocketPair.Factory FACTORY = new TestSocketPair.Factory(){

        @Override
        TestSocketPair createUnconnected() throws IOException {
            return new UnixSocketPair();
        }
    };
    private final File file = new File("/tmp/jnr-unixsocket-test" + UUID.randomUUID() + ".sock");
    private final UnixSocketAddress address = new UnixSocketAddress(this.file);
    private UnixServerSocketChannel serverSocketChannel = UnixServerSocketChannel.open();
    private UnixSocketChannel serverChannel;
    private UnixSocketChannel clientChannel;

    UnixSocketPair() throws IOException {
    }

    @Override
    void serverBind() throws IOException {
        this.serverSocketChannel.configureBlocking(true);
        this.serverSocketChannel.socket().bind((SocketAddress)this.address);
    }

    @Override
    void clientConnect() throws IOException {
        if (this.clientChannel != null) {
            throw new IllegalStateException("already connected");
        }
        this.clientChannel = UnixSocketChannel.open();
        this.clientChannel.connect(new UnixSocketAddress(this.file));
    }

    @Override
    void serverAccept() throws IOException {
        if (this.serverChannel != null) {
            throw new IllegalStateException("already accepted");
        }
        this.serverChannel = this.serverSocketChannel.accept();
    }

    UnixSocketAddress socketAddress() {
        return this.address;
    }

    @Override
    Socket server() {
        return this.serverChannel.socket();
    }

    @Override
    Socket client() {
        return this.clientChannel.socket();
    }

    @Override
    public void close() throws IOException {
        this.closeQuietly((Closeable)this.serverSocketChannel);
        this.closeQuietly((Closeable)this.serverChannel);
        this.closeQuietly((Closeable)this.clientChannel);
        this.file.delete();
    }
}

