/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket.example;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public class UnixClient {
    public static void main(String[] args) throws IOException, InterruptedException {
        int status;
        File path = new File("/tmp/fubar.sock");
        int retries = 0;
        while (!path.exists()) {
            TimeUnit.MILLISECONDS.sleep(500L);
            if (++retries <= 10) continue;
            throw new IOException(String.format("File %s does not exist after retry", path.getAbsolutePath()));
        }
        String data = "blah blah";
        UnixSocketAddress address = new UnixSocketAddress(path);
        UnixSocketChannel channel = UnixSocketChannel.open((UnixSocketAddress)address);
        System.out.println("connected to " + channel.getRemoteSocketAddress());
        PrintWriter w = new PrintWriter(Channels.newOutputStream((WritableByteChannel)channel));
        w.print(data);
        w.flush();
        InputStreamReader r = new InputStreamReader(Channels.newInputStream((ReadableByteChannel)channel));
        CharBuffer result = CharBuffer.allocate(1024);
        r.read(result);
        result.flip();
        System.out.println("read from server: " + result.toString());
        if (!result.toString().equals(data)) {
            System.out.println("ERROR: data mismatch");
            status = -1;
        } else {
            System.out.println("SUCCESS");
            status = 0;
        }
        System.exit(status);
    }
}

