/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket.example;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnr.enxio.channels.NativeSelectorProvider;
import jnr.unixsocket.UnixServerSocket;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public class UnixServer {
    public static void main(String[] args) throws IOException {
        File path = new File("/tmp/fubar.sock");
        path.deleteOnExit();
        UnixSocketAddress address = new UnixSocketAddress(path);
        UnixServerSocketChannel channel = UnixServerSocketChannel.open();
        try {
            AbstractSelector sel = NativeSelectorProvider.getInstance().openSelector();
            channel.configureBlocking(false);
            channel.socket().bind((SocketAddress)address);
            channel.register((Selector)sel, 16, (Object)new ServerActor(channel, sel));
            while (sel.select() > 0) {
                Set<SelectionKey> keys = sel.selectedKeys();
                Iterator<SelectionKey> iterator = keys.iterator();
                boolean running = false;
                boolean cancelled = false;
                while (iterator.hasNext()) {
                    SelectionKey k = iterator.next();
                    Actor a = (Actor)k.attachment();
                    if (a.rxready()) {
                        running = true;
                    } else {
                        k.cancel();
                        cancelled = true;
                    }
                    iterator.remove();
                }
                if (running || !cancelled) continue;
                System.out.println("No Actors Running any more");
                break;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(UnixServerSocket.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("UnixServer EXIT");
    }

    static final class ClientActor
    implements Actor {
        private final UnixSocketChannel channel;

        public ClientActor(UnixSocketChannel channel) {
            this.channel = channel;
        }

        @Override
        public final boolean rxready() {
            try {
                int n;
                ByteBuffer buf = ByteBuffer.allocate(1024);
                while ((n = this.channel.read(buf)) > 0) {
                    UnixSocketAddress remote = this.channel.getRemoteSocketAddress();
                    System.out.printf("Read in %d bytes from %s%n", n, remote);
                    if (n > 0) {
                        buf.flip();
                        this.channel.write(buf);
                        buf.clear();
                        continue;
                    }
                    if (n >= 0) continue;
                    return false;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
            return true;
        }
    }

    static final class ServerActor
    implements Actor {
        private final UnixServerSocketChannel channel;
        private final Selector selector;

        public ServerActor(UnixServerSocketChannel channel, Selector selector) {
            this.channel = channel;
            this.selector = selector;
        }

        @Override
        public final boolean rxready() {
            try {
                UnixSocketChannel client = this.channel.accept();
                client.configureBlocking(false);
                client.register(this.selector, 1, (Object)new ClientActor(client));
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
    }

    static interface Actor {
        public boolean rxready();
    }
}

