/*
 * Decompiled with CFR 0.152.
 */
package com.github.jnthnclt.os.lab.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.github.jnthnclt.os.lab.api.ValueIndex;
import com.github.jnthnclt.os.lab.base.BolBuffer;
import com.github.jnthnclt.os.lab.base.UIO;
import com.github.jnthnclt.os.lab.core.LABEnvironmentBuilder;
import com.github.jnthnclt.os.lab.core.LABHeapPressureBuilder;
import com.github.jnthnclt.os.lab.core.LABIndexProvider;
import com.github.jnthnclt.os.lab.core.LABStats;
import com.github.jnthnclt.os.lab.core.LABValueIndexConfigBuilder;
import com.github.jnthnclt.os.lab.core.api.ValueIndexConfig;
import com.github.jnthnclt.os.lab.core.guts.LABFiles;
import com.github.jnthnclt.os.lab.log.LABLogger;
import com.github.jnthnclt.os.lab.log.LABLoggerFactory;
import com.github.jnthnclt.os.lab.s3.BackUpper;
import com.github.jnthnclt.os.lab.s3.S3BackUpper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;

public class ContiniousBackupLABInitializer {
    private static final LABLogger LOG = LABLoggerFactory.getLogger();

    public static void main(String[] args) throws Exception {
        String awsApiKey = "";
        String awsApiSecret = "";
        File root = new File("");
        File restoreRoot = new File("");
        String bucketName = "";
        String keyPrefix = "";
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(awsApiKey, awsApiSecret);
        AmazonS3 s3client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials))).withRegion(Regions.US_EAST_1)).build();
        S3BackUpper backUpper = new S3BackUpper(s3client, bucketName, keyPrefix);
        long total = 1000000L;
        FileUtils.cleanDirectory((File)root);
        LABContinuousS3Backup.BackupPoint<Long> backupPoint = (indexName, batchId) -> System.out.println("Hooray index:" + indexName + " is backed up to:" + batchId);
        LABContinuousS3Backup<Long> labContinuousS3Backup = ContiniousBackupLABInitializer.initialize(backUpper, backupPoint);
        LABValueIndexConfigBuilder labValueIndexConfigBuilder = new LABValueIndexConfigBuilder("foo");
        labValueIndexConfigBuilder.setSplitWhenValuesAndKeysTotalExceedsNBytes(0xA00000);
        labContinuousS3Backup.open(root, labValueIndexConfigBuilder.build());
        labContinuousS3Backup.start();
        ExecutorService batchFlushers = Executors.newFixedThreadPool(1);
        ArrayList futures = Lists.newArrayList();
        int batchSize = 10000;
        for (long i = 0L; i < total; i += (long)batchSize) {
            long id = i;
            futures.add(batchFlushers.submit(() -> {
                labContinuousS3Backup.acquireIndex("foo", id, index -> {
                    long[] fromToAppend = new long[2];
                    boolean first = true;
                    for (int j = 0; j < batchSize; ++j) {
                        long key = id + (long)j;
                        fromToAppend[first ? 0 : 1] = index.append(stream -> {
                            stream.stream(1, UIO.longBytes((long)key), System.currentTimeMillis(), false, System.currentTimeMillis(), (Object)(key + " fluffy bunnies ate my carrots").getBytes());
                            return true;
                        }, true, new BolBuffer(), new BolBuffer());
                        first = false;
                    }
                    LOG.info("Commit " + (id + (long)batchSize) + "->" + total);
                    index.commit(true, false);
                    Thread.sleep(2000L);
                    return fromToAppend;
                });
                return null;
            }));
        }
        System.out.println("Waiting on batches...");
        for (Future future : futures) {
            future.get();
        }
        System.out.println("Indexing done");
        labContinuousS3Backup.acquireIndex("foo", null, index -> {
            index.close(true, true);
            return null;
        });
        System.out.println("Flushing done");
        labContinuousS3Backup.stop();
        backUpper.restore(restoreRoot, "foo");
        System.out.println("Restore index done");
        AtomicLong keyCount = new AtomicLong();
        LABContinuousS3Backup<Long> foo2 = ContiniousBackupLABInitializer.initialize(backUpper, backupPoint);
        labValueIndexConfigBuilder = new LABValueIndexConfigBuilder("foo");
        labValueIndexConfigBuilder.setSplitWhenValuesAndKeysTotalExceedsNBytes(0xA00000);
        foo2.open(restoreRoot, labValueIndexConfigBuilder.build());
        foo2.acquireIndex("foo", null, index -> {
            System.out.println(index.count());
            index.rowScan((index1, key, timestamp, tombstoned, version, payload) -> {
                long k = key.getLong(0);
                keyCount.incrementAndGet();
                if (k % 10000L == 0L) {
                    System.out.println(index1 + " " + k + " " + new String(payload.copy()));
                }
                return true;
            }, true);
            return null;
        });
        System.out.println(keyCount.get());
        System.exit(0);
    }

    public static <I> LABContinuousS3Backup<I> initialize(BackUpper backUpper, LABContinuousS3Backup.BackupPoint<I> backupPoint) {
        LABFiles labFiles = new LABFiles();
        AtomicLong globalHeapCostInBytes = new AtomicLong();
        LABStats stats = new LABStats(globalHeapCostInBytes);
        LABHeapPressureBuilder labHeapPressureBuilder = new LABHeapPressureBuilder(globalHeapCostInBytes);
        labHeapPressureBuilder.setMaxHeapPressureInBytes(0x2000000L);
        LABEnvironmentBuilder labEnvironmentBuilder = new LABEnvironmentBuilder().setLABFiles(labFiles);
        LABIndexProvider indexProvider = new LABIndexProvider(stats, labHeapPressureBuilder, labEnvironmentBuilder);
        return new LABContinuousS3Backup<I>(backUpper, labFiles, (LABIndexProvider<byte[]>)indexProvider, backupPoint);
    }

    public static class LABContinuousS3Backup<I> {
        private static final LABLogger LOG = LABLoggerFactory.getLogger();
        private final BackUpper backUpper;
        private final LABFiles labFiles;
        private final LABIndexProvider<byte[]> indexProvider;
        private final BackupPoint<I> backupPoint;
        private final ExecutorService backupThread = Executors.newSingleThreadExecutor();
        private final AtomicBoolean running = new AtomicBoolean(false);
        private final AtomicBoolean stopped = new AtomicBoolean(false);
        private final Map<String, RootAndIndex> indexes = Maps.newConcurrentMap();
        private final Map<String, ConcurrentLinkedQueue<BatchId<I>>> wroteRanges = Maps.newConcurrentMap();
        private final Map<String, TreeRangeSet<Long>> flushedRanges = Maps.newConcurrentMap();

        public LABContinuousS3Backup(BackUpper backUpper, LABFiles labFiles, LABIndexProvider<byte[]> indexProvider, BackupPoint<I> backupPoint) {
            this.backUpper = backUpper;
            this.labFiles = labFiles;
            this.indexProvider = indexProvider;
            this.backupPoint = backupPoint;
        }

        public void open(File indexRoot, ValueIndexConfig indexConfig) throws Exception {
            ValueIndex valueIndex = this.indexProvider.buildIndex(indexRoot, indexConfig);
            this.indexes.putIfAbsent(indexConfig.primaryName, new RootAndIndex(indexRoot, valueIndex));
        }

        public void acquireIndex(String indexName, I batchId, AcquireIndex acquireIndex) throws Exception {
            RootAndIndex rootAndIndex = this.indexes.get(indexName);
            if (batchId != null) {
                long[] fromToVersion = acquireIndex.index((ValueIndex<byte[]>)rootAndIndex.index);
                if (fromToVersion != null && fromToVersion[0] < fromToVersion[1]) {
                    ConcurrentLinkedQueue wroteQueue = this.wroteRanges.computeIfAbsent(indexName, s -> new ConcurrentLinkedQueue());
                    Range range = Range.closed((Comparable)Long.valueOf(fromToVersion[0]), (Comparable)Long.valueOf(fromToVersion[1]));
                    LOG.info("Added " + range + " for " + batchId);
                    wroteQueue.add(new BatchId(range, indexName, batchId));
                }
            } else {
                acquireIndex.index((ValueIndex<byte[]>)rootAndIndex.index);
            }
        }

        public void start() throws Exception {
            if (this.running.compareAndSet(false, true)) {
                this.backupThread.submit(() -> {
                    try {
                        this.labFiles.take(change -> {
                            if (change == null) {
                                for (RootAndIndex rootAndIndex : this.indexes.values()) {
                                    if (rootAndIndex.index.closed()) continue;
                                    return true;
                                }
                                return this.running.get();
                            }
                            String id = new String(change.labId, StandardCharsets.UTF_8);
                            RootAndIndex rootAndIndex = this.indexes.get(id);
                            String key = rootAndIndex.buildKey(change.file);
                            if (change.delete) {
                                while (true) {
                                    try {
                                        this.backUpper.delete(key, change.file);
                                        return true;
                                    }
                                    catch (Exception x) {
                                        LOG.error("Failed to remove " + key + " from backup. Will retry in 5 sec", (Throwable)x);
                                        Thread.sleep(5000L);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            while (true) {
                                try {
                                    ConcurrentLinkedQueue<BatchId<I>> wrote;
                                    boolean backedUp = false;
                                    if (change.file.exists()) {
                                        try {
                                            LOG.info("Backing up index:" + id + " key:" + key + " " + UIO.ram((long)FileUtils.sizeOf((File)change.file)) + "...");
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            // empty catch block
                                        }
                                        this.backUpper.backup(key, change.file);
                                        backedUp = true;
                                        LOG.info("Backed up index:" + id + " version:[" + change.fromAppendVersion + ".." + change.toAppendVersion + "] key:" + key);
                                    }
                                    if (backedUp && change.fromAppendVersion != -1L && change.toAppendVersion != -1L && (wrote = this.wroteRanges.get(id)) != null) {
                                        BatchId<I> next;
                                        TreeRangeSet rangeSet = this.flushedRanges.computeIfAbsent(id, s -> TreeRangeSet.create());
                                        rangeSet.add(Range.closed((Comparable)Long.valueOf(change.fromAppendVersion), (Comparable)Long.valueOf(change.toAppendVersion + 1L)));
                                        for (BatchId<I> next2 : wrote) {
                                            if (!rangeSet.encloses(((BatchId)next2).range)) continue;
                                            next2.setCompleted();
                                        }
                                        ArrayList backedUpPoints = Lists.newArrayList();
                                        Iterator<BatchId<I>> iterator = wrote.iterator();
                                        while (iterator.hasNext() && (next = iterator.next()).isComplete()) {
                                            backedUpPoints.add(next);
                                            iterator.remove();
                                        }
                                        LOG.info("Flushed RangeSet:" + rangeSet);
                                        for (BatchId i : backedUpPoints) {
                                            try {
                                                this.backupPoint.backedUp(i.indexName, i.batchId);
                                            }
                                            catch (Exception x) {
                                                LOG.error("Failure while call back point callback.", (Throwable)x);
                                            }
                                        }
                                    }
                                    return true;
                                }
                                catch (Exception x) {
                                    LOG.error("Failed to backup index:" + id + " key:" + key + ". Will retry in 5 sec", (Throwable)x);
                                    Thread.sleep(5000L);
                                    continue;
                                }
                                break;
                            }
                        });
                    }
                    catch (Exception x) {
                        LOG.error("Unexpected shutdown :(", (Throwable)x);
                    }
                    AtomicBoolean atomicBoolean = this.stopped;
                    synchronized (atomicBoolean) {
                        if (this.stopped.compareAndSet(false, true)) {
                            LOG.info("Stopped");
                            this.stopped.notifyAll();
                        }
                    }
                    return true;
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() throws Exception {
            if (this.running.compareAndSet(true, false)) {
                AtomicBoolean atomicBoolean = this.stopped;
                synchronized (atomicBoolean) {
                    if (!this.stopped.get()) {
                        LOG.info("Waiting for backup service to stop...");
                        this.stopped.wait();
                    }
                }
                this.backupThread.shutdown();
                LOG.info("Backup service has stopped");
            }
        }

        private static class BatchId<I> {
            private final Range<Long> range;
            private final I batchId;
            public String indexName;
            private AtomicBoolean completed = new AtomicBoolean(false);

            private BatchId(Range<Long> range, String indexName, I batchId) {
                this.range = range;
                this.indexName = indexName;
                this.batchId = batchId;
            }

            public void setCompleted() {
                this.completed.compareAndSet(false, true);
            }

            public boolean isComplete() {
                return this.completed.get();
            }
        }

        private static class RootAndIndex<I> {
            private final File root;
            private final ValueIndex<byte[]> index;

            private RootAndIndex(File root, ValueIndex<byte[]> index) {
                this.root = root;
                this.index = index;
            }

            private String buildKey(File child) {
                return child.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1);
            }
        }

        public static interface BackupPoint<I> {
            public void backedUp(String var1, I var2);
        }
    }

    public static interface AcquireIndex<R> {
        public long[] index(ValueIndex<byte[]> var1) throws Exception;
    }
}

