/*
 * Decompiled with CFR 0.152.
 */
package com.github.johnpoth;

import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.tools.Tool;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="run", defaultPhase=LifecyclePhase.INSTALL, requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class JShellMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.runtimeClasspathElements}", property="rcp", required=true)
    private List<String> runtimeClasspathElements;
    @Parameter(defaultValue="${project.testClasspathElements}", property="trcp", required=true)
    private List<String> testClasspathElements;
    @Parameter(defaultValue="false", property="testClasspath")
    private boolean testClasspath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        String cp = this.testClasspath ? this.testClasspathElements.stream().reduce(this.runtimeClasspathElements.get(0), (a, b) -> a + ":" + b) : this.runtimeClasspathElements.stream().reduce(this.runtimeClasspathElements.get(0), (a, b) -> a + ":" + b);
        this.getLog().debug((CharSequence)("Using classpath:" + cp));
        Optional<Module> module = ModuleLayer.boot().findModule("jdk.jshell");
        ClassLoader classLoader = module.get().getClassLoader();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            ServiceLoader<Tool> sl = ServiceLoader.load(Tool.class);
            Tool jshell = (Tool)sl.stream().filter(a -> ((Tool)a.get()).name().equals("jshell")).findAny().orElseThrow(() -> new RuntimeException("No JShell service providers found!")).get();
            String[] args = new String[]{"--class-path", cp};
            jshell.run(System.in, System.out, System.err, args);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }
}

