/*
 * Decompiled with CFR 0.152.
 */
package com.github.johnpoth.jshell;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.tools.Tool;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="run", defaultPhase=LifecyclePhase.INSTALL, requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class JShellMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.runtimeClasspathElements}", property="rcp", required=true)
    private List<String> runtimeClasspathElements;
    @Parameter(defaultValue="${project.testClasspathElements}", property="trcp", required=true)
    private List<String> testClasspathElements;
    @Parameter(property="plugin.artifacts", required=true, readonly=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="false", property="testClasspath")
    private boolean testClasspath;
    @Parameter(defaultValue="true", property="jshell.useProjectClasspath")
    private boolean useProjectClasspath;
    @Parameter(property="jshell.class-path")
    private String classpath;
    @Parameter(property="jshell.module-path")
    private String modulepath;
    @Parameter(property="jshell.add-modules")
    private String addModules;
    @Parameter(property="jshell.add-exports")
    private String addExports;
    @Parameter(property="jshell.scripts")
    private List<String> scripts = new ArrayList<String>();
    @Parameter(property="jshell.options")
    private List<String> options = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        String cp = this.buildClasspath();
        this.getLog().debug((CharSequence)("Using classpath: " + cp));
        Optional<Module> module = ModuleLayer.boot().findModule("jdk.jshell");
        ClassLoader classLoader = module.get().getClassLoader();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            ServiceLoader<Tool> sl = ServiceLoader.load(Tool.class);
            Tool jshell = (Tool)sl.stream().filter(a -> ((Tool)a.get()).name().equals("jshell")).findAny().orElseThrow(() -> new RuntimeException("No JShell service providers found!")).get();
            String[] args = this.addArguments(cp);
            int exitCode = jshell.run(System.in, System.out, System.err, args);
            if (exitCode != 0) {
                throw new MojoExecutionException("An error was encountered while executing. Exit code:" + exitCode);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private String buildClasspath() {
        ArrayList<String> classpathElements = new ArrayList<String>();
        if (this.testClasspath) {
            classpathElements.addAll(this.filterClasspath(this.testClasspathElements));
        } else {
            classpathElements.addAll(this.filterClasspath(this.runtimeClasspathElements));
        }
        if (!this.pluginArtifacts.isEmpty()) {
            classpathElements.addAll(this.pluginArtifacts.stream().map(artifact -> artifact.getFile().getAbsolutePath()).collect(Collectors.toList()));
        }
        return this.filterClasspath(classpathElements).stream().reduce("", (a, b) -> a + File.pathSeparator + b);
    }

    private List<String> filterClasspath(List<String> cp) {
        return cp.stream().filter(s -> {
            Path path = Paths.get(s, new String[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                this.getLog().warn((CharSequence)("Removing: " + s + " from the classpath." + System.lineSeparator() + "If this is unexpected, please make sure you correctly build the project beforehand by invoking the correct Maven build phase (usually `install`, `test-compile` or `compile`). For example:" + System.lineSeparator() + "mvn test-compile com.github.johnpoth:jshell-maven-plugin:1.3:run" + System.lineSeparator() + "For more information visit https://github.com/johnpoth/jshell-maven-plugin"));
                return false;
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                return true;
            }
            if (s.endsWith(".jar")) {
                return true;
            }
            this.getLog().debug((CharSequence)("Removing: " + s + " from the classpath because it is unsupported in JShell."));
            return false;
        }).collect(Collectors.toList());
    }

    private String[] addArguments(String cp) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.useProjectClasspath) {
            args.add("--class-path");
            args.add(cp);
        } else if (this.classpath != null) {
            args.add("--class-path");
            args.add(this.classpath);
        }
        if (this.modulepath != null) {
            args.add("--module-path");
            args.add(this.modulepath);
        }
        if (this.addModules != null) {
            args.add("--add-modules");
            args.add(this.addModules);
        }
        if (this.addExports != null) {
            args.add("--add-exports");
            args.add(this.addExports);
        }
        for (String option : this.options) {
            args.add(option);
        }
        for (String script : this.scripts) {
            args.add(script);
        }
        return args.toArray(new String[0]);
    }
}

