/*
 * Decompiled with CFR 0.152.
 */
package com.github.johrstrom.collector;

import com.github.johrstrom.collector.BaseCollectorConfig;
import com.github.johrstrom.collector.JMeterCollectorRegistry;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CollectorElement<C extends BaseCollectorConfig>
extends AbstractTestElement {
    public static final String COLLECTOR_DEF = "prometheus.collector_definitions";
    protected Map<C, Collector> collectors = new HashMap<C, Collector>();
    protected transient JMeterCollectorRegistry registry = JMeterCollectorRegistry.getInstance();
    private static Logger log = LoggerFactory.getLogger(CollectorElement.class);
    private static final long serialVersionUID = 963612021269632269L;

    public CollectorElement() {
        log.debug("making a new config element: " + ((Object)((Object)this)).toString());
        this.setCollectorConfigs(new ArrayList());
    }

    public CollectionProperty getCollectorConfigs() {
        JMeterProperty collectorDefinitions = this.getProperty(COLLECTOR_DEF);
        if (collectorDefinitions == null || collectorDefinitions instanceof NullProperty) {
            collectorDefinitions = new CollectionProperty(COLLECTOR_DEF, new ArrayList());
            collectorDefinitions.setName(COLLECTOR_DEF);
        }
        return (CollectionProperty)collectorDefinitions;
    }

    public void setCollectorConfigs(List<C> collectors) {
        log.debug("setting new collectors. size is: " + collectors.size());
        this.setCollectorConfigs(new CollectionProperty(COLLECTOR_DEF, collectors));
    }

    public void setCollectorConfigs(CollectionProperty collectors) {
        this.setProperty((JMeterProperty)collectors);
    }

    protected void clearCollectors() {
        Iterator<Map.Entry<C, Collector>> iter = this.collectors.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<C, Collector> entry = iter.next();
            this.registry.unregister((BaseCollectorConfig)((Object)entry.getKey()));
            iter.remove();
        }
    }

    protected void makeNewCollectors() {
        this.clearCollectors();
        CollectionProperty collectorDefs = this.getCollectorConfigs();
        PropertyIterator iter = collectorDefs.iterator();
        while (iter.hasNext()) {
            try {
                BaseCollectorConfig config = (BaseCollectorConfig)((Object)iter.next().getObjectValue());
                Collector collector = this.registry.getOrCreateAndRegister(config);
                this.collectors.put((C)((Object)config), collector);
                log.debug("added " + config.getMetricName() + " to list of collectors");
            }
            catch (Exception e) {
                log.error("Didn't create new collector because of error, ", (Throwable)e);
            }
        }
    }
}

