/*
 * Decompiled with CFR 0.152.
 */
package com.github.johrstrom.collector;

import com.github.johrstrom.collector.BaseCollectorConfig;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.hotspot.BufferPoolsExports;
import io.prometheus.client.hotspot.ClassLoadingExports;
import io.prometheus.client.hotspot.GarbageCollectorExports;
import io.prometheus.client.hotspot.MemoryAllocationExports;
import io.prometheus.client.hotspot.MemoryPoolsExports;
import io.prometheus.client.hotspot.StandardExports;
import io.prometheus.client.hotspot.ThreadExports;
import io.prometheus.client.hotspot.VersionInfoExports;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMeterCollectorRegistry
extends CollectorRegistry {
    private static JMeterCollectorRegistry instance = null;
    private static Logger log = LoggerFactory.getLogger(JMeterCollectorRegistry.class);
    private ConcurrentHashMap<BaseCollectorConfig, Collector> registered = new ConcurrentHashMap();
    private static final boolean saveThreads = JMeterUtils.getPropDefault((String)"prometheus.save.threads", (boolean)true);
    public static final String COLLECT_JVM = "prometheus.save.jvm";
    public static final boolean COLLECT_JVM_DEFAULT = true;
    private static final boolean saveJVM = JMeterUtils.getPropDefault((String)"prometheus.save.jvm", (boolean)true);

    public static synchronized JMeterCollectorRegistry getInstance() {
        if (instance == null) {
            log.debug("Creating prometheus collector registry");
            instance = new JMeterCollectorRegistry();
        }
        return instance;
    }

    private JMeterCollectorRegistry() {
        super(true);
        this.initDefaultExports();
        this.createJMeterExports();
    }

    private void initDefaultExports() {
        if (saveJVM) {
            new StandardExports().register(this);
            new MemoryPoolsExports().register(this);
            new MemoryAllocationExports().register(this);
            new BufferPoolsExports().register(this);
            new GarbageCollectorExports().register(this);
            new ThreadExports().register(this);
            new ClassLoadingExports().register(this);
            new VersionInfoExports().register(this);
        }
    }

    private void createJMeterExports() {
        if (saveThreads) {
            ThreadCollector tc = new ThreadCollector();
            this.register(tc);
            this.registered.put(ThreadCollector.getConfig(), tc);
        }
    }

    public synchronized void unregister(BaseCollectorConfig cfg) {
        log.debug("unregistering {}", (Object)cfg.getMetricName());
        if (this.registered.containsKey((Object)cfg)) {
            Collector collector = this.registered.get((Object)cfg);
            try {
                this.unregister(collector);
                this.registered.remove((Object)cfg);
            }
            catch (Exception e) {
                log.error("can't unregister collector because error: ", (Throwable)e);
            }
        }
    }

    public synchronized Collector getOrCreateAndRegister(BaseCollectorConfig cfg) {
        if (this.registered.containsKey((Object)cfg)) {
            log.trace("{} found already registered.", (Object)cfg.getMetricName());
            return this.registered.get((Object)cfg);
        }
        Collector c = BaseCollectorConfig.fromConfig(cfg);
        this.register(c);
        this.registered.put(cfg, c);
        log.debug("created and registered {}", (Object)cfg);
        return c;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.registered.clear();
    }

    private static class ThreadCollector
    extends Collector {
        public static final String COLLECT_THREADS_NAME = "prometheus.save.threads.name";
        public static final String COLLECT_THREADS_NAME_DEFAULT = "jmeter_threads";
        public static final String COLLECT_THREADS = "prometheus.save.threads";
        public static final boolean COLLECT_THREADS_DEFAULT = true;
        private final Gauge innerCollector;

        protected ThreadCollector() {
            BaseCollectorConfig cfg = ThreadCollector.getConfig();
            this.innerCollector = ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name(cfg.getMetricName())).labelNames(cfg.getLabels())).help(cfg.getHelp())).create();
        }

        protected static BaseCollectorConfig getConfig() {
            BaseCollectorConfig cfg = new BaseCollectorConfig();
            cfg.setHelp("Gauge for jmeter threads");
            cfg.setMetricName(ThreadCollector.threadMetricName());
            cfg.setLabels(new String[]{"state"});
            cfg.setType(Collector.Type.GAUGE.name());
            return cfg;
        }

        public static String threadMetricName() {
            return JMeterUtils.getPropDefault((String)COLLECT_THREADS_NAME, (String)COLLECT_THREADS_NAME_DEFAULT);
        }

        @Override
        public List<Collector.MetricFamilySamples> collect() {
            JMeterContextService.ThreadCounts tc = JMeterContextService.getThreadCounts();
            ((Gauge.Child)this.innerCollector.labels("active")).set(tc.activeThreads);
            ((Gauge.Child)this.innerCollector.labels("finished")).set(tc.finishedThreads);
            ((Gauge.Child)this.innerCollector.labels("started")).set(tc.startedThreads);
            return this.innerCollector.collect();
        }
    }
}

