/*
 * Decompiled with CFR 0.152.
 */
package com.github.johrstrom.collector;

import com.github.johrstrom.collector.BaseCollectorConfig;
import io.prometheus.client.Collector;
import io.prometheus.client.Counter;
import java.util.ArrayList;
import java.util.List;

public class SuccessRatioCollector
extends Collector {
    private final Counter success;
    private final Counter failure;
    private final Counter total;

    public SuccessRatioCollector(BaseCollectorConfig config) {
        this.success = ((Counter.Builder)((Counter.Builder)((Counter.Builder)new Counter.Builder().help(config.getHelp())).name(SuccessRatioCollector.extendedName(config.getMetricName(), "success"))).labelNames(config.getLabels())).create();
        this.failure = ((Counter.Builder)((Counter.Builder)((Counter.Builder)new Counter.Builder().help(config.getHelp())).name(SuccessRatioCollector.extendedName(config.getMetricName(), "failure"))).labelNames(config.getLabels())).create();
        this.total = ((Counter.Builder)((Counter.Builder)((Counter.Builder)new Counter.Builder().help(config.getHelp())).name(SuccessRatioCollector.extendedName(config.getMetricName(), "total"))).labelNames(config.getLabels())).create();
    }

    public void incrementSuccess(String[] labels) {
        ((Counter.Child)this.success.labels(labels)).inc();
        ((Counter.Child)this.total.labels(labels)).inc();
        if (this.getFailure(labels) < 1.0) {
            ((Counter.Child)this.failure.labels(labels)).inc(0.0);
        }
    }

    public void incrementFailure(String[] labels) {
        ((Counter.Child)this.failure.labels(labels)).inc();
        ((Counter.Child)this.total.labels(labels)).inc();
        if (this.getSuccess(labels) < 1.0) {
            ((Counter.Child)this.success.labels(labels)).inc(0.0);
        }
    }

    public double getSuccess(String[] labels) {
        return ((Counter.Child)this.success.labels(labels)).get();
    }

    public double getFailure(String[] labels) {
        return ((Counter.Child)this.failure.labels(labels)).get();
    }

    public double getTotal(String[] labels) {
        return ((Counter.Child)this.total.labels(labels)).get();
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> metrics = new ArrayList<Collector.MetricFamilySamples>();
        metrics.addAll(this.success.collect());
        metrics.addAll(this.failure.collect());
        metrics.addAll(this.total.collect());
        return metrics;
    }

    private static String extendedName(String orig, String append) {
        StringBuilder sb = new StringBuilder(32);
        sb.append(orig);
        if (!orig.endsWith("_")) {
            sb.append("_");
        }
        sb.append(append);
        return sb.toString();
    }
}

