/*
 * Decompiled with CFR 0.152.
 */
package com.github.johrstrom.collector.gui;

import com.github.johrstrom.collector.BaseCollectorConfig;
import com.github.johrstrom.collector.CollectorElement;
import com.github.johrstrom.collector.gui.Flatten;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jorphan.gui.ObjectTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCollectorTable<C extends BaseCollectorConfig>
extends JPanel
implements ActionListener {
    public static final String ADD = "Add";
    public static final String DELETE = "Delete";
    protected transient JTable table;
    protected transient ObjectTableModel model;
    protected JButton add;
    protected JButton delete;
    private final Class<C> clazzType;
    private static final long serialVersionUID = 2027712606129940455L;
    private Logger log = LoggerFactory.getLogger(AbstractCollectorTable.class);

    public abstract Flatten getGuiHelper();

    public abstract void modifyColumns();

    public AbstractCollectorTable(Class<C> collectorType) {
        this.clazzType = collectorType;
        this.init();
        this.modifyColumns();
    }

    public List<C> getRowsAsCollectors() {
        ArrayList<BaseCollectorConfig> collectors = new ArrayList<BaseCollectorConfig>();
        Iterator iter = this.model.iterator();
        while (iter.hasNext()) {
            BaseCollectorConfig cfg = (BaseCollectorConfig)((Object)this.clazzType.cast(iter.next()));
            collectors.add(cfg);
            this.log.debug("populated config: " + cfg.toString() + " from table.");
        }
        return collectors;
    }

    public void clearModelData() {
        this.model.clearData();
    }

    public void populateTable(CollectorElement<C> config) {
        CollectionProperty collectors = config.getCollectorConfigs();
        this.log.debug("Configuring table with " + collectors.size() + " collectors.");
        this.model.clearData();
        PropertyIterator it = collectors.iterator();
        while (it.hasNext()) {
            BaseCollectorConfig cfg = (BaseCollectorConfig)((Object)it.next().getObjectValue());
            this.model.addRow((Object)cfg);
            this.log.debug("added row into table: " + cfg.toString());
        }
    }

    protected void init() {
        this.setLayout(new BorderLayout(0, 5));
        VerticalPanel panel = new VerticalPanel();
        panel.add(this.makeTablePanel());
        panel.add((Component)this.makeButtonPanel());
        this.add((Component)panel, "Center");
    }

    protected Component makeTablePanel() {
        Flatten helper = this.getGuiHelper();
        this.model = new ObjectTableModel(helper.getHeaders(), this.clazzType, helper.getReadFunctors(), helper.getWriteFunctors(), (Class[])helper.getEditorClasses());
        this.table = new JTable((TableModel)this.model);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        return scrollPane;
    }

    protected JPanel makeButtonPanel() {
        this.add = new JButton(ADD);
        this.add.setActionCommand(ADD);
        this.add.setEnabled(true);
        this.add.addActionListener(this);
        this.delete = new JButton(DELETE);
        this.delete.setActionCommand(DELETE);
        this.delete.setEnabled(true);
        this.delete.addActionListener(this);
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Component)this.add);
        panel.add((Component)this.delete);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        switch (event.getActionCommand()) {
            case "Add": {
                try {
                    this.model.addRow(this.clazzType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    this.log.error("Couldn't add to model becuase of error. ", (Throwable)e);
                }
                break;
            }
            case "Delete": {
                this.deleteSelectedRows();
                break;
            }
        }
    }

    protected void deleteSelectedRows() {
        int[] rows = this.table.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            this.model.removeRow(rows[i]);
        }
    }
}

