/*
 * Decompiled with CFR 0.152.
 */
package com.github.johrstrom.config;

import com.github.johrstrom.collector.BaseCollectorConfig;
import com.github.johrstrom.collector.CollectorElement;
import io.prometheus.client.Collector;
import java.util.Map;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsConfig
extends CollectorElement<BaseCollectorConfig>
implements NoThreadClone,
TestStateListener {
    private static final long serialVersionUID = 7602510312126862226L;
    private Logger log = LoggerFactory.getLogger(PrometheusMetricsConfig.class);

    public void testEnded() {
        this.setRunningVersion(false);
        JMeterVariables variables = this.getThreadContext().getVariables();
        for (Map.Entry entry : this.collectors.entrySet()) {
            BaseCollectorConfig cfg = (BaseCollectorConfig)((Object)entry.getKey());
            variables.remove(cfg.getMetricName());
        }
        this.clearCollectors();
    }

    public void testEnded(String arg0) {
        this.testEnded();
    }

    public void testStarted() {
        this.setRunningVersion(true);
        this.makeNewCollectors();
        JMeterVariables variables = this.getThreadContext().getVariables();
        this.log.debug("Test started, adding {} collectors to variables", (Object)this.collectors.size());
        for (Map.Entry entry : this.collectors.entrySet()) {
            BaseCollectorConfig cfg = (BaseCollectorConfig)((Object)entry.getKey());
            variables.putObject(cfg.getMetricName(), entry.getValue());
            this.log.debug("Added ({},{}) to variables.", entry.getKey(), (Object)((Collector)entry.getValue()).toString());
        }
    }

    public void testStarted(String arg0) {
        this.testStarted();
    }

    public PrometheusMetricsConfig clone() {
        PrometheusMetricsConfig clone = new PrometheusMetricsConfig();
        clone.setCollectorConfigs(this.getCollectorConfigs());
        return clone;
    }

    public boolean equals(Object o) {
        if (o instanceof PrometheusMetricsConfig) {
            PrometheusMetricsConfig other = (PrometheusMetricsConfig)((Object)o);
            CollectionProperty thisConfig = this.getCollectorConfigs();
            CollectionProperty otherConfig = other.getCollectorConfigs();
            boolean sameSize = thisConfig.size() == otherConfig.size();
            for (int i = 0; i < thisConfig.size(); ++i) {
                JMeterProperty right;
                JMeterProperty left = thisConfig.get(i);
                if (left.equals(right = otherConfig.get(i))) continue;
                return false;
            }
            return sameSize;
        }
        return false;
    }
}

