/*
 * Decompiled with CFR 0.152.
 */
package com.github.johrstrom.config.gui;

import com.github.johrstrom.collector.CollectorElement;
import com.github.johrstrom.config.PrometheusMetricsConfig;
import com.github.johrstrom.config.gui.ConfigCollectorTable;
import java.awt.BorderLayout;
import java.util.List;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.testelement.TestElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsConfigGui<C>
extends AbstractConfigGui {
    private static final long serialVersionUID = 6741986237897976082L;
    private ConfigCollectorTable table = new ConfigCollectorTable();
    private Logger log = LoggerFactory.getLogger(PrometheusMetricsConfigGui.class);

    public PrometheusMetricsConfigGui() {
        this.log.debug("making a new config gui: {}", (Object)this.toString());
        this.init();
    }

    public TestElement createTestElement() {
        PrometheusMetricsConfig cfg = new PrometheusMetricsConfig();
        cfg.setProperty("TestElement.gui_class", PrometheusMetricsConfigGui.class.getName());
        cfg.setProperty("TestElement.test_class", PrometheusMetricsConfig.class.getName());
        this.modifyTestElement((TestElement)cfg);
        return cfg;
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public String getStaticLabel() {
        return "Prometheus Metrics";
    }

    public String getName() {
        return super.getName() == null ? this.getStaticLabel() : super.getName();
    }

    public void modifyTestElement(TestElement ele) {
        if (!(ele instanceof CollectorElement)) {
            return;
        }
        CollectorElement config = (CollectorElement)ele;
        List collectors = this.table.getRowsAsCollectors();
        config.setCollectorConfigs(collectors);
        config.setName(this.getName());
        config.setComment(this.getComment());
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.add(this.makeTitlePanel(), "North");
        this.add(this.table, "Center");
    }

    public void configure(TestElement ele) {
        super.configure(ele);
        if (ele instanceof CollectorElement) {
            try {
                this.table.populateTable((CollectorElement)ele);
            }
            catch (Exception e) {
                this.log.error("didn't modify test element because {}:{}", e.getClass(), (Object)e.getMessage());
            }
        }
        this.setName(ele.getName());
        this.setComment(ele.getComment());
    }

    public void clearGui() {
        super.clearGui();
        this.table.clearModelData();
    }

    protected PrometheusMetricsConfigGui<C> clone() {
        return new PrometheusMetricsConfigGui<C>();
    }
}

