/*
 * Decompiled with CFR 0.152.
 */
package com.github.johrstrom.listener;

import com.github.johrstrom.collector.CollectorElement;
import com.github.johrstrom.collector.JMeterCollectorRegistry;
import com.github.johrstrom.listener.ListenerCollectorConfig;
import com.github.johrstrom.listener.PrometheusServer;
import com.github.johrstrom.listener.updater.AbstractUpdater;
import com.github.johrstrom.listener.updater.AggregatedTypeUpdater;
import com.github.johrstrom.listener.updater.CountTypeUpdater;
import io.prometheus.client.Collector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusListener
extends CollectorElement<ListenerCollectorConfig>
implements SampleListener,
Serializable,
TestStateListener,
NoThreadClone {
    private static final long serialVersionUID = -4833646252357876746L;
    private static final Logger log = LoggerFactory.getLogger(PrometheusListener.class);
    private transient PrometheusServer server = PrometheusServer.getInstance();
    private List<AbstractUpdater> updaters;

    public void sampleOccurred(SampleEvent event) {
        for (AbstractUpdater updater : this.updaters) {
            updater.update(event);
        }
    }

    public void sampleStarted(SampleEvent arg0) {
    }

    public void sampleStopped(SampleEvent arg0) {
    }

    public void testEnded() {
        this.clearCollectors();
        try {
            this.server.stop();
        }
        catch (Exception e) {
            log.error("Couldn't stop http server", (Throwable)e);
        }
    }

    public void testEnded(String arg0) {
        this.testEnded();
    }

    public void testStarted() {
        this.makeNewCollectors();
        try {
            if (this.server == null) {
                log.warn("Prometheus server has not yet been initialized, doing it now");
                this.server = PrometheusServer.getInstance();
            }
            this.server.start();
        }
        catch (Exception e) {
            log.error("Couldn't start http server", (Throwable)e);
        }
    }

    public void testStarted(String arg0) {
        this.testStarted();
    }

    @Override
    protected void makeNewCollectors() {
        if (this.registry == null) {
            log.warn("Collector registry has not yet been initialized, doing it now");
            this.registry = JMeterCollectorRegistry.getInstance();
        }
        this.updaters = new ArrayList<AbstractUpdater>();
        CollectionProperty collectorDefs = this.getCollectorConfigs();
        for (JMeterProperty collectorDef : collectorDefs) {
            try {
                ListenerCollectorConfig config = (ListenerCollectorConfig)((Object)collectorDef.getObjectValue());
                log.debug("Creating collector from configuration: " + (Object)((Object)config));
                Collector collector = this.registry.getOrCreateAndRegister(config);
                AbstractUpdater updater = null;
                switch (config.getMeasuringAsEnum()) {
                    case CountTotal: 
                    case FailureTotal: 
                    case SuccessTotal: 
                    case SuccessRatio: {
                        updater = new CountTypeUpdater(config);
                        break;
                    }
                    case ResponseSize: 
                    case ResponseTime: 
                    case Latency: 
                    case IdleTime: 
                    case ConnectTime: {
                        updater = new AggregatedTypeUpdater(config);
                        break;
                    }
                    default: {
                        log.error((Object)((Object)config.getMeasuringAsEnum()) + " triggered default case, which means there's no functionality for this and is likely a bug");
                    }
                }
                this.collectors.put(config, collector);
                this.updaters.add(updater);
                log.debug("added " + config.getMetricName() + " to list of collectors");
            }
            catch (Exception e) {
                log.error("Didn't create new collector because of error, ", (Throwable)e);
            }
        }
    }
}

