/*
 * Decompiled with CFR 0.152.
 */
package com.github.johrstrom.listener;

import com.github.johrstrom.collector.JMeterCollectorRegistry;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPOutputStream;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusServer {
    public static final String PROMETHEUS_PORT = "prometheus.port";
    public static final int PROMETHEUS_PORT_DEFAULT = 9270;
    public static final String PROMETHEUS_DELAY = "prometheus.delay";
    public static final int PROMETHEUS_DELAY_DEFAULT = 0;
    private static final Logger log = LoggerFactory.getLogger(PrometheusServer.class);
    private HttpServer server;
    private static PrometheusServer instance = null;
    private int port = JMeterUtils.getPropDefault((String)"prometheus.port", (int)9270);
    private int delay = JMeterUtils.getPropDefault((String)"prometheus.delay", (int)0);
    protected static final HTTPMetricHandler metricHandler = new HTTPMetricHandler(JMeterCollectorRegistry.getInstance());

    protected static boolean shouldUseCompression(HttpExchange exchange) {
        Object encodingHeaders = exchange.getRequestHeaders().get("Accept-Encoding");
        if (encodingHeaders == null) {
            return false;
        }
        Iterator iterator = encodingHeaders.iterator();
        while (iterator.hasNext()) {
            String[] encodings;
            String encodingHeader = (String)iterator.next();
            for (String encoding : encodings = encodingHeader.split(",")) {
                if (!encoding.trim().toLowerCase().equals("gzip")) continue;
                return true;
            }
        }
        return false;
    }

    protected static Set<String> parseQuery(String query) throws IOException {
        HashSet<String> names = new HashSet<String>();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                if (idx == -1 || !URLDecoder.decode(pair.substring(0, idx), "UTF-8").equals("name[]")) continue;
                names.add(URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
        }
        return names;
    }

    public static synchronized PrometheusServer getInstance() {
        if (instance == null) {
            log.debug("Creating Prometheus Server");
            instance = new PrometheusServer();
        }
        return instance;
    }

    private PrometheusServer() {
    }

    public synchronized void start() throws IOException {
        if (this.server != null) {
            this.server.stop(0);
            ((ExecutorService)this.server.getExecutor()).shutdown();
        }
        this.server = HttpServer.create();
        InetSocketAddress addr = new InetSocketAddress(this.port);
        this.server.bind(addr, 3);
        this.server.createContext("/", metricHandler);
        this.server.createContext("/metrics", metricHandler);
        this.server.setExecutor(Executors.newSingleThreadExecutor());
        this.server.start();
    }

    public synchronized void stop() {
        this.server.stop(this.delay);
        ((ExecutorService)this.server.getExecutor()).shutdown();
    }

    static class HTTPMetricHandler
    implements HttpHandler {
        private CollectorRegistry registry;
        private final LocalByteArray response = new LocalByteArray();

        HTTPMetricHandler(CollectorRegistry registry) {
            this.registry = registry;
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String query = t.getRequestURI().getRawQuery();
            ByteArrayOutputStream response = (ByteArrayOutputStream)this.response.get();
            response.reset();
            OutputStreamWriter osw = new OutputStreamWriter(response);
            TextFormat.write004(osw, this.registry.filteredMetricFamilySamples(PrometheusServer.parseQuery(query)));
            osw.flush();
            osw.close();
            response.flush();
            response.close();
            t.getResponseHeaders().set("Content-Type", "text/plain; version=0.0.4; charset=utf-8");
            if (PrometheusServer.shouldUseCompression(t)) {
                t.getResponseHeaders().set("Content-Encoding", "gzip");
                t.sendResponseHeaders(200, 0L);
                GZIPOutputStream os = new GZIPOutputStream(t.getResponseBody());
                response.writeTo(os);
                os.close();
            } else {
                t.getResponseHeaders().set("Content-Length", String.valueOf(response.size()));
                t.sendResponseHeaders(200, response.size());
                response.writeTo(t.getResponseBody());
            }
            t.close();
        }
    }

    private static class LocalByteArray
    extends ThreadLocal<ByteArrayOutputStream> {
        private LocalByteArray() {
        }

        @Override
        protected ByteArrayOutputStream initialValue() {
            return new ByteArrayOutputStream(0x100000);
        }
    }
}

